/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.query;

import java.io.IOException;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.util.OpenBitSet;
import org.apache.solr.search.BitDocSet;
import org.apache.solr.search.DocIterator;
import org.apache.solr.search.DocSet;
import org.apache.solr.search.SolrIndexReader;

public class AbstractSolrCachingScorer
extends Scorer {
    BitDocSet matches;
    int doc = -1;
    OpenBitSet openBitSet;
    SolrIndexReader solrIndexReader;

    AbstractSolrCachingScorer(Similarity similarity, DocSet in, SolrIndexReader solrIndexReader) {
        super(similarity);
        if (in instanceof BitDocSet) {
            this.matches = (BitDocSet)in;
        } else {
            this.matches = new BitDocSet();
            DocIterator it = in.iterator();
            while (it.hasNext()) {
                this.matches.addUnique(it.nextDoc());
            }
        }
        this.openBitSet = this.matches.getBits();
        this.solrIndexReader = solrIndexReader;
        this.doc = solrIndexReader.getBase() - 1;
    }

    public boolean next() throws IOException {
        this.doc = this.openBitSet.nextSetBit(this.doc + 1);
        return this.doc != -1 && this.doc < this.solrIndexReader.getBase() + this.solrIndexReader.maxDoc();
    }

    public int doc() {
        return this.doc - this.solrIndexReader.getBase();
    }

    public float score() throws IOException {
        return 1.0f;
    }

    public boolean skipTo(int target) throws IOException {
        while (this.next()) {
            if (this.doc() < target) continue;
            return true;
        }
        return false;
    }

    public Explanation explain(int position) throws IOException {
        throw new UnsupportedOperationException();
    }
}

