/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.query;

import org.alfresco.opencmis.search.CMISQueryOptions;
import org.alfresco.repo.search.impl.querymodel.Order;
import org.alfresco.repo.search.impl.querymodel.Ordering;
import org.alfresco.repo.search.impl.querymodel.PropertyArgument;
import org.alfresco.repo.search.impl.querymodel.Query;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.solr.AlfrescoSolrDataModel;
import org.alfresco.solr.query.AbstractQParser;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.queryParser.ParseException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.search.QParser;
import org.apache.solr.search.QParserPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CmisQParserPlugin
extends QParserPlugin {
    protected static final Logger log = LoggerFactory.getLogger(CmisQParserPlugin.class);

    public QParser createParser(String qstr, SolrParams localParams, SolrParams params, SolrQueryRequest req) {
        return new CmisQParser(qstr, localParams, params, req);
    }

    public void init(NamedList arg0) {
    }

    public static class CmisQParser
    extends AbstractQParser {
        public CmisQParser(String qstr, SolrParams localParams, SolrParams params, SolrQueryRequest req) {
            super(qstr, localParams, params, req);
        }

        public org.apache.lucene.search.Query parse() throws ParseException {
            SearchParameters searchParameters = this.getSearchParameters();
            String id = this.req.getSchema().getResourceLoader().getInstanceDir();
            IndexReader indexReader = this.req.getSearcher().getIndexReader();
            Query queryModelQuery = AlfrescoSolrDataModel.getInstance(id).parseCMISQueryToAlfrescoAbstractQuery(CMISQueryOptions.CMISQueryMode.CMS_WITH_ALFRESCO_EXTENSIONS, searchParameters, indexReader);
            if (queryModelQuery.getOrderings() != null && queryModelQuery.getOrderings().size() > 0) {
                StringBuilder sortParameter = new StringBuilder();
                for (Ordering ordering : queryModelQuery.getOrderings()) {
                    if (ordering.getColumn().getFunction().getName().equals("PropertyAccessor")) {
                        PropertyArgument property = (PropertyArgument)ordering.getColumn().getFunctionArguments().get("Property");
                        if (property == null) {
                            throw new IllegalStateException();
                        }
                        String propertyName = property.getPropertyName();
                        String luceneField = AlfrescoSolrDataModel.getInstance(id).getCMISFunctionEvaluationContext(CMISQueryOptions.CMISQueryMode.CMS_WITH_ALFRESCO_EXTENSIONS).getLuceneFieldName(propertyName);
                        if (sortParameter.length() > 0) {
                            sortParameter.append(", ");
                        }
                        sortParameter.append(luceneField).append(" ");
                        if (ordering.getOrder() == Order.DESCENDING) {
                            sortParameter.append("desc");
                            continue;
                        }
                        sortParameter.append("asc");
                        continue;
                    }
                    if (ordering.getColumn().getFunction().getName().equals("Score")) {
                        if (sortParameter.length() > 0) {
                            sortParameter.append(", ");
                        }
                        sortParameter.append("SCORE ");
                        if (ordering.getOrder() == Order.DESCENDING) {
                            sortParameter.append("desc");
                            continue;
                        }
                        sortParameter.append("asc");
                        continue;
                    }
                    throw new IllegalStateException();
                }
                ModifiableSolrParams newParams = new ModifiableSolrParams(this.req.getParams());
                newParams.set("sort", new String[]{sortParameter.toString()});
                this.req.setParams((SolrParams)newParams);
                this.params = newParams;
            }
            return AlfrescoSolrDataModel.getInstance(id).getCMISQuery(CMISQueryOptions.CMISQueryMode.CMS_WITH_ALFRESCO_EXTENSIONS, searchParameters, indexReader, queryModelQuery);
        }
    }
}

