/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.query;

import java.io.IOException;
import org.alfresco.solr.query.SolrCachingAuxDocScorer;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Weight;
import org.apache.solr.search.SolrIndexReader;
import org.apache.solr.search.SolrIndexSearcher;

public class SolrCachingAuxDocQuery
extends Query {
    Query query;

    public SolrCachingAuxDocQuery(Query query) {
        this.query = query;
    }

    public Weight createWeight(Searcher searcher) throws IOException {
        if (!(searcher instanceof SolrIndexSearcher)) {
            throw new IllegalStateException("Must have a SolrIndexSearcher");
        }
        return new SolrCachingAuxDocQueryWeight((SolrIndexSearcher)searcher);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("CACHED -> :");
        stringBuilder.append("AuxDocQuery " + this.query);
        return stringBuilder.toString();
    }

    public String toString(String field) {
        return this.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.query == null ? 0 : this.query.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        SolrCachingAuxDocQuery other = (SolrCachingAuxDocQuery)((Object)obj);
        return !(this.query == null ? other.query != null : !this.query.equals((Object)other.query));
    }

    private class SolrCachingAuxDocQueryWeight
    extends Weight {
        SolrIndexSearcher searcher;
        private Similarity similarity;
        private float value;
        private float idf;
        private float queryNorm;
        private float queryWeight;
        private Explanation.IDFExplanation idfExp;

        public SolrCachingAuxDocQueryWeight(SolrIndexSearcher searcher) throws IOException {
            this.searcher = searcher;
            this.similarity = SolrCachingAuxDocQuery.this.getSimilarity((Searcher)searcher);
            this.idfExp = new Explanation.IDFExplanation(){

                public float getIdf() {
                    return 1.0f;
                }

                public String explain() {
                    return "Aux doc wrapper shoud pass through the underlying stuff";
                }
            };
            this.idf = this.idfExp.getIdf();
        }

        public Explanation explain(IndexReader reader, int doc) throws IOException {
            throw new UnsupportedOperationException();
        }

        public Query getQuery() {
            return SolrCachingAuxDocQuery.this;
        }

        public float getValue() {
            return this.value;
        }

        public void normalize(float queryNorm) {
            this.queryNorm = queryNorm;
            this.queryWeight *= queryNorm;
            this.value = this.queryWeight * this.idf;
        }

        public float sumOfSquaredWeights() throws IOException {
            this.queryWeight = this.idf * SolrCachingAuxDocQuery.this.getBoost();
            return this.queryWeight * this.queryWeight;
        }

        public Scorer scorer(IndexReader reader, boolean scoreDocsInOrder, boolean topScorer) throws IOException {
            if (!(reader instanceof SolrIndexReader)) {
                throw new IllegalStateException("Must have a SolrIndexReader");
            }
            return SolrCachingAuxDocScorer.createAuxDocScorer(this.searcher, SolrCachingAuxDocQuery.this.getSimilarity((Searcher)this.searcher), SolrCachingAuxDocQuery.this.query, (SolrIndexReader)reader);
        }
    }
}

