/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.query;

import java.io.IOException;
import org.alfresco.solr.AlfrescoSolrEventListener;
import org.alfresco.solr.query.AbstractSolrCachingScorer;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.util.OpenBitSet;
import org.apache.solr.search.BitDocSet;
import org.apache.solr.search.DocIterator;
import org.apache.solr.search.DocSet;
import org.apache.solr.search.SolrIndexReader;
import org.apache.solr.search.SolrIndexSearcher;

public class SolrCachingAuxDocScorer
extends AbstractSolrCachingScorer {
    SolrCachingAuxDocScorer(Similarity similarity, DocSet in, SolrIndexReader solrIndexReader) {
        super(similarity, in, solrIndexReader);
    }

    public static SolrCachingAuxDocScorer createAuxDocScorer(SolrIndexSearcher searcher, Similarity similarity, Query query, SolrIndexReader reader) throws IOException {
        DocSet auxDocSet = searcher.getDocSet(query);
        AlfrescoSolrEventListener.CacheEntry[] indexedByDocId = (AlfrescoSolrEventListener.CacheEntry[])searcher.cacheLookup(AlfrescoSolrEventListener.ALFRESCO_CACHE, (Object)AlfrescoSolrEventListener.KEY_DBID_LEAF_PATH_BY_DOC_ID);
        OpenBitSet translated = new OpenBitSet();
        if (auxDocSet instanceof BitDocSet) {
            BitDocSet source = (BitDocSet)auxDocSet;
            OpenBitSet openBitSet = source.getBits();
            int current = -1;
            while ((current = openBitSet.nextSetBit(current + 1)) != -1) {
                AlfrescoSolrEventListener.CacheEntry entry = indexedByDocId[current];
                translated.set((long)entry.getLeaf());
            }
        } else {
            DocIterator it = auxDocSet.iterator();
            while (it.hasNext()) {
                AlfrescoSolrEventListener.CacheEntry entry = indexedByDocId[it.nextDoc()];
                translated.set((long)entry.getLeaf());
            }
        }
        return new SolrCachingAuxDocScorer(similarity, (DocSet)new BitDocSet(translated), reader);
    }
}

