/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.query;

import java.io.IOException;
import java.util.HashMap;
import org.alfresco.solr.AlfrescoSolrEventListener;
import org.alfresco.solr.query.AbstractSolrCachingScorer;
import org.apache.lucene.search.Similarity;
import org.apache.solr.search.BitDocSet;
import org.apache.solr.search.DocSet;
import org.apache.solr.search.SolrIndexReader;
import org.apache.solr.search.SolrIndexSearcher;

public class SolrCachingOwnerScorer
extends AbstractSolrCachingScorer {
    SolrCachingOwnerScorer(Similarity similarity, DocSet in, SolrIndexReader solrIndexReader) {
        super(similarity, in, solrIndexReader);
    }

    public static SolrCachingOwnerScorer createOwnerScorer(SolrIndexSearcher searcher, Similarity similarity, String authority, SolrIndexReader reader) throws IOException {
        BitDocSet authorityOwnedDocs = new BitDocSet();
        HashMap ownerLookUp = (HashMap)searcher.cacheLookup(AlfrescoSolrEventListener.ALFRESCO_CACHE, (Object)AlfrescoSolrEventListener.KEY_OWNER_LOOKUP);
        AlfrescoSolrEventListener.OwnerLookUp lookUp = (AlfrescoSolrEventListener.OwnerLookUp)ownerLookUp.get(authority);
        if (lookUp != null) {
            AlfrescoSolrEventListener.CacheEntry[] indexedOderedByOwnerIdThenDoc = (AlfrescoSolrEventListener.CacheEntry[])searcher.cacheLookup(AlfrescoSolrEventListener.ALFRESCO_CACHE, (Object)AlfrescoSolrEventListener.KEY_DBID_LEAF_PATH_BY_OWNER_ID_THEN_LEAF);
            for (int i = lookUp.getStart(); i < lookUp.getEnd(); ++i) {
                authorityOwnedDocs.addUnique(indexedOderedByOwnerIdThenDoc[i].getLeaf());
            }
        }
        return new SolrCachingOwnerScorer(similarity, (DocSet)authorityOwnedDocs, reader);
    }
}

