/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.tracker;

import org.alfresco.solr.AlfrescoCoreAdminHandler;
import org.alfresco.solr.tracker.CoreTracker;
import org.apache.solr.core.SolrCore;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoreWatcherJob
implements Job {
    protected static final Logger log = LoggerFactory.getLogger(CoreWatcherJob.class);

    public void execute(JobExecutionContext jec) throws JobExecutionException {
        AlfrescoCoreAdminHandler adminHandler = (AlfrescoCoreAdminHandler)((Object)jec.getJobDetail().getJobDataMap().get((Object)"ADMIN_HANDLER"));
        for (SolrCore core : adminHandler.getCoreContainer().getCores()) {
            if (adminHandler.getTrackers().containsKey(core.getName()) || !core.getSolrConfig().getBool("alfresco/track", false)) continue;
            log.info("Starting to track " + core.getName());
            adminHandler.getTrackers().put(core.getName(), new CoreTracker(adminHandler, core));
        }
    }
}

