/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.executor.loader;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.ibatis.executor.loader.ResultLoader;
import org.apache.ibatis.reflection.MetaObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultLoaderMap {
    private final Map<String, LoadPair> loaderMap = new HashMap<String, LoadPair>();

    public void addLoader(String property, MetaObject metaResultObject, ResultLoader resultLoader) {
        String upperFirst = ResultLoaderMap.getUppercaseFirstProperty(property);
        this.loaderMap.put(upperFirst, new LoadPair(property, metaResultObject, resultLoader));
    }

    public Set<String> getPropertyNames() {
        return this.loaderMap.keySet();
    }

    public int size() {
        return this.loaderMap.size();
    }

    public boolean hasLoader(String property) {
        return this.loaderMap.containsKey(property.toUpperCase(Locale.ENGLISH));
    }

    public boolean load(String property) throws SQLException {
        LoadPair pair = this.loaderMap.remove(property.toUpperCase(Locale.ENGLISH));
        if (pair != null) {
            pair.load();
            return true;
        }
        return false;
    }

    public void loadAll() throws SQLException {
        String[] methodNames;
        Set<String> methodNameSet = this.loaderMap.keySet();
        for (String methodName : methodNames = methodNameSet.toArray(new String[methodNameSet.size()])) {
            this.load(methodName);
        }
    }

    private static String getUppercaseFirstProperty(String property) {
        String[] parts = property.split("\\.");
        return parts[0].toUpperCase(Locale.ENGLISH);
    }

    private static class LoadPair {
        private String property;
        private MetaObject metaResultObject;
        private ResultLoader resultLoader;

        private LoadPair(String property, MetaObject metaResultObject, ResultLoader resultLoader) {
            this.property = property;
            this.metaResultObject = metaResultObject;
            this.resultLoader = resultLoader;
        }

        public void load() throws SQLException {
            this.metaResultObject.setValue(this.property, this.resultLoader.loadResult());
        }
    }
}

