/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.config.forms;

import java.util.ArrayList;
import java.util.List;
import org.alfresco.web.config.forms.DependenciesConfigElement;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.springframework.extensions.config.ConfigElement;
import org.springframework.extensions.config.ConfigException;
import org.springframework.extensions.config.xml.elementreader.ConfigElementReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependenciesElementReader
implements ConfigElementReader {
    public static final String ELEMENT_DEPENDENCIES = "dependencies";

    public ConfigElement parse(Element dependenciesElem) {
        DependenciesConfigElement result = null;
        if (dependenciesElem == null) {
            return null;
        }
        String name = dependenciesElem.getName();
        if (!name.equals(ELEMENT_DEPENDENCIES)) {
            throw new ConfigException(this.getClass().getName() + " can only parse " + ELEMENT_DEPENDENCIES + " elements, the element passed was '" + name + "'");
        }
        result = new DependenciesConfigElement();
        List<String> cssDependencies = this.getSrcDependencies(dependenciesElem, "./css");
        List<String> jsDependencies = this.getSrcDependencies(dependenciesElem, "./js");
        result.addCssDependencies(cssDependencies);
        result.addJsDependencies(jsDependencies);
        return result;
    }

    private List<String> getSrcDependencies(Element typeNode, String xpathExpression) {
        ArrayList<String> result = new ArrayList<String>();
        for (Object cssObj : typeNode.selectNodes(xpathExpression)) {
            Element cssElem = (Element)cssObj;
            List cssAttributes = cssElem.selectNodes("./@*");
            for (Attribute nextAttr : cssAttributes) {
                String nextAttrName = nextAttr.getName();
                if (!nextAttrName.equals("src")) continue;
                String nextAttrValue = nextAttr.getValue();
                result.add(nextAttrValue);
            }
        }
        return result;
    }
}

