/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.config.forms;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.alfresco.web.config.forms.ControlParam;
import org.alfresco.web.config.forms.DependenciesConfigElement;
import org.alfresco.web.config.forms.FormConfigBasicTest;
import org.alfresco.web.config.forms.FormConfigElement;
import org.alfresco.web.config.forms.FormsConfigElement;
import org.springframework.extensions.config.Config;
import org.springframework.extensions.config.ConfigElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormConfigBasicOverrideTest
extends FormConfigBasicTest {
    @Override
    protected List<String> getConfigFiles() {
        ArrayList<String> result = new ArrayList<String>(1);
        result.add("test-config-forms-basic.xml");
        result.add("test-config-forms-basic-override.xml");
        return result;
    }

    @Override
    protected String getExpectedMessageForNumericConstraint() {
        return "Test Message override";
    }

    @Override
    protected List<ControlParam> getExpectedControlParamsForDText() {
        return Arrays.asList(new ControlParam("size", "999"));
    }

    @Override
    protected List<ControlParam> getExpectedControlParamsForDTest() {
        return Arrays.asList(new ControlParam("a", "Goodbye"), new ControlParam("b", null), new ControlParam("c", "This is new"));
    }

    @Override
    protected List<String> getExpectedTemplatesForNoAppearanceDefaultForm() {
        return Arrays.asList("/view/template/override", "/edit/template/override", "/create/template/override");
    }

    @Override
    public void testGetForcedFields() {
        List<String> forcedFields = this.noAppearanceDefaultForm.getForcedFieldsAsList();
        FormConfigBasicOverrideTest.assertEquals((String)"Wrong forced fields count", (int)2, (int)forcedFields.size());
        FormConfigBasicOverrideTest.assertTrue((String)"Expected cm:name to be forced", (boolean)this.noAppearanceDefaultForm.isFieldForced("cm:name"));
        FormConfigBasicOverrideTest.assertTrue((String)"Expected cm:description to be forced", (boolean)this.noAppearanceDefaultForm.isFieldForced("cm:description"));
        FormConfigBasicOverrideTest.assertFalse((String)"Expected cm:title not to be forced", (boolean)this.noAppearanceDefaultForm.isFieldForced("cm:title"));
    }

    @Override
    public void testGetDependencies() throws Exception {
        FormsConfigElement globalForms = (FormsConfigElement)this.globalConfig.getConfigElement("forms");
        DependenciesConfigElement depsCE = globalForms.getDependencies();
        FormConfigBasicOverrideTest.assertNotNull((Object)((Object)depsCE));
        String[] expectedCssDependencies = new String[]{"/css/path/1", "/css/path/2", "/css/path/3"};
        String[] expectedJsDependencies = new String[]{"/js/path/1", "/js/path/2", "/js/path/3"};
        FormConfigBasicOverrideTest.assertEquals(Arrays.asList(expectedCssDependencies), Arrays.asList(depsCE.getCss()));
        FormConfigBasicOverrideTest.assertEquals(Arrays.asList(expectedJsDependencies), Arrays.asList(depsCE.getJs()));
    }

    public void testCombiningFormsAcrossXmlFiles() throws Exception {
        Config testConfigObj = this.configService.getConfig((Object)"combiningFormsAcrossXmlFiles");
        FormConfigBasicOverrideTest.assertNotNull((Object)testConfigObj);
        ConfigElement testFormsConfigObj = testConfigObj.getConfigElement("forms");
        FormConfigBasicOverrideTest.assertNotNull((Object)testFormsConfigObj);
        FormsConfigElement testFormsConfigElement = (FormsConfigElement)testFormsConfigObj;
        FormConfigElement testDefaultForm = testFormsConfigElement.getDefaultForm();
        FormConfigBasicOverrideTest.assertNotNull((Object)((Object)testDefaultForm));
        FormConfigElement formWithId = testFormsConfigElement.getForm("testing");
        FormConfigBasicOverrideTest.assertNotNull((Object)((Object)formWithId));
    }

    public void testCustomFormTemplatesOverride() throws Exception {
        Config testConfigObj = this.configService.getConfig((Object)"custom-form-templates");
        FormConfigBasicOverrideTest.assertNotNull((Object)testConfigObj);
        ConfigElement testFormsConfigObj = testConfigObj.getConfigElement("forms");
        FormConfigBasicOverrideTest.assertNotNull((Object)testFormsConfigObj);
        FormsConfigElement testFormsConfigElement = (FormsConfigElement)testFormsConfigObj;
        FormConfigElement testDefaultForm = testFormsConfigElement.getDefaultForm();
        FormConfigBasicOverrideTest.assertNotNull((Object)((Object)testDefaultForm));
        String viewTemplate = testDefaultForm.getViewTemplate();
        FormConfigBasicOverrideTest.assertEquals((String)"/path/to/my/template.ftl", (String)viewTemplate);
        String createTemplate = testDefaultForm.getCreateTemplate();
        FormConfigBasicOverrideTest.assertEquals((String)"/path/to/my/template.ftl", (String)createTemplate);
        String editTemplate = testDefaultForm.getEditTemplate();
        FormConfigBasicOverrideTest.assertEquals((String)"/path/to/my/template.ftl", (String)editTemplate);
    }
}

