/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.config.forms;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.web.config.forms.ConstraintHandlersConfigElement;
import org.alfresco.web.config.forms.DefaultControlsConfigElement;
import org.alfresco.web.config.forms.DependenciesConfigElement;
import org.alfresco.web.config.forms.FormConfigElement;
import org.springframework.extensions.config.ConfigElement;
import org.springframework.extensions.config.ConfigException;
import org.springframework.extensions.config.element.ConfigElementAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormsConfigElement
extends ConfigElementAdapter {
    private static final long serialVersionUID = -7196705568492121773L;
    public static final String FORMS_ID = "forms";
    private FormConfigElement defaultFormElement;
    private Map<String, FormConfigElement> formElementsById = new LinkedHashMap<String, FormConfigElement>();
    private DefaultControlsConfigElement defaultControlsElement;
    private ConstraintHandlersConfigElement constraintHandlersElement;
    private DependenciesConfigElement dependenciesConfigElement;

    public FormsConfigElement() {
        super(FORMS_ID);
    }

    public FormsConfigElement(String name) {
        super(name);
    }

    public List<ConfigElement> getChildren() {
        throw new ConfigException("Reading the forms config via the generic interfaces is not supported");
    }

    public FormConfigElement getDefaultForm() {
        return this.defaultFormElement;
    }

    public FormConfigElement getForm(String id) {
        return this.formElementsById.get(id);
    }

    void setDefaultForm(FormConfigElement formCE) {
        this.defaultFormElement = formCE;
    }

    void addFormById(FormConfigElement formCE, String formId) {
        this.formElementsById.put(formId, formCE);
    }

    public DefaultControlsConfigElement getDefaultControls() {
        return this.defaultControlsElement;
    }

    void setDefaultControls(DefaultControlsConfigElement defltCtrlsCE) {
        this.defaultControlsElement = defltCtrlsCE;
    }

    public ConstraintHandlersConfigElement getConstraintHandlers() {
        return this.constraintHandlersElement;
    }

    void setConstraintHandlers(ConstraintHandlersConfigElement constraintHandlersCE) {
        this.constraintHandlersElement = constraintHandlersCE;
    }

    public DependenciesConfigElement getDependencies() {
        return this.dependenciesConfigElement;
    }

    void setDependencies(DependenciesConfigElement dependenciesCS) {
        this.dependenciesConfigElement = dependenciesCS;
    }

    public ConfigElement combine(ConfigElement otherConfigElement) {
        FormsConfigElement otherFormsElem = (FormsConfigElement)otherConfigElement;
        FormsConfigElement result = new FormsConfigElement();
        FormConfigElement combinedDefaultForm = this.getDefaultForm() == null ? otherFormsElem.getDefaultForm() : this.defaultFormElement.combine((ConfigElement)otherFormsElem.getDefaultForm());
        result.setDefaultForm(combinedDefaultForm);
        for (String thisFormId : this.formElementsById.keySet()) {
            if (otherFormsElem.formElementsById.containsKey(thisFormId)) {
                FormConfigElement otherFormCE = otherFormsElem.getForm(thisFormId);
                FormConfigElement combinedElement = (FormConfigElement)this.formElementsById.get(thisFormId).combine((ConfigElement)otherFormCE);
                result.addFormById(combinedElement, thisFormId);
                continue;
            }
            result.addFormById(this.formElementsById.get(thisFormId), thisFormId);
        }
        for (String otherFormId : otherFormsElem.formElementsById.keySet()) {
            if (this.formElementsById.containsKey(otherFormId)) continue;
            result.addFormById(otherFormsElem.formElementsById.get(otherFormId), otherFormId);
        }
        DefaultControlsConfigElement combinedDefaultControls = this.defaultControlsElement == null ? otherFormsElem.getDefaultControls() : this.defaultControlsElement.combine((ConfigElement)otherFormsElem.getDefaultControls());
        result.setDefaultControls(combinedDefaultControls);
        ConstraintHandlersConfigElement combinedConstraintHandlers = this.constraintHandlersElement == null ? otherFormsElem.getConstraintHandlers() : this.constraintHandlersElement.combine((ConfigElement)otherFormsElem.getConstraintHandlers());
        result.setConstraintHandlers(combinedConstraintHandlers);
        DependenciesConfigElement combinedDependencies = this.dependenciesConfigElement == null ? otherFormsElem.getDependencies() : this.dependenciesConfigElement.combine((ConfigElement)otherFormsElem.getDependencies());
        result.setDependencies(combinedDependencies);
        return result;
    }
}

