/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.alfresco.repo.content.MimetypeMap;
import org.alfresco.service.cmr.repository.MimetypeService;
import org.alfresco.util.DataModelTestApplicationContextHelper;
import org.springframework.context.ApplicationContext;
import org.springframework.extensions.config.ConfigDeployment;
import org.springframework.extensions.config.ConfigService;
import org.springframework.extensions.config.ConfigSource;
import org.springframework.extensions.config.xml.XMLConfigService;

public class MimetypeMapTest
extends TestCase {
    private static ApplicationContext ctx = DataModelTestApplicationContextHelper.getApplicationContext();
    private MimetypeService mimetypeService;
    private ConfigService configService;
    private static final String MIMETYPE_1A = "      <mimetype mimetype=\"mimetype1\" display=\"Mimetype ONE\">        <extension display=\"Extension ONE\">ext1a</extension>      </mimetype>";
    private static final String MIMETYPE_1B = "      <mimetype mimetype=\"mimetype1\" display=\"Mimetype ONE\">        <extension display=\"Extension 1\">ext1a</extension>      </mimetype>";
    private static final String MIMETYPE_1C = "      <mimetype mimetype=\"mimetype1\" display=\"Mimetype ONE\">        <extension>ext1a</extension>      </mimetype>";
    private static final String MIMETYPE_1D = "      <mimetype mimetype=\"mimetype1\" display=\"Mimetype 1\">        <extension>ext1a</extension>      </mimetype>";
    private static final String MIMETYPE_1E = "      <mimetype mimetype=\"mimetype1\" text=\"true\">        <extension>ext1a</extension>      </mimetype>";
    private static final String MIMETYPE_1F = "      <mimetype mimetype=\"mimetype1\" text=\"true\">        <extension>ext1a</extension>        <extension default=\"true\">ext1b</extension>        <extension>ext1c</extension>      </mimetype>";
    private static final String MIMETYPE_1G = "      <mimetype mimetype=\"mimetype1\" text=\"true\">        <extension>ext1c</extension>        <extension>ext1b</extension>        <extension>ext1a</extension>      </mimetype>";
    private static final String MIMETYPE_2A = "      <mimetype mimetype=\"mimetype2\" display=\"Mimetype TWO\" text=\"true\">        <extension>ext2a</extension>      </mimetype>";
    private static final String MIMETYPE_2B = "      <mimetype mimetype=\"mimetype2\" display=\"Mimetype TWO\">        <extension>ext2a</extension>      </mimetype>";
    private static final String MIMETYPE_3A = "      <mimetype mimetype=\"mimetype3\" display=\"Mimetype THREE\">        <extension>ext3a</extension>        <extension>ext3b</extension>      </mimetype>";

    public void setUp() throws Exception {
        this.mimetypeService = (MimetypeService)ctx.getBean("mimetypeService");
        this.configService = ((MimetypeMap)this.mimetypeService).getConfigService();
    }

    protected void tearDown() throws Exception {
        ((MimetypeMap)this.mimetypeService).setConfigService(this.configService);
        ((MimetypeMap)this.mimetypeService).init();
    }

    public void testExtensions() throws Exception {
        Map<String, String> extensionsByMimetype = this.mimetypeService.getExtensionsByMimetype();
        Map<String, String> mimetypesByExtension = this.mimetypeService.getMimetypesByExtension();
        MimetypeMapTest.assertEquals((String)"txt", (String)extensionsByMimetype.get("text/plain"));
        MimetypeMapTest.assertEquals((String)"text/plain", (String)mimetypesByExtension.get("txt"));
        MimetypeMapTest.assertEquals((String)"text/plain", (String)mimetypesByExtension.get("java"));
        MimetypeMapTest.assertEquals((String)"text/csv", (String)mimetypesByExtension.get("csv"));
        MimetypeMapTest.assertEquals((String)"text/html", (String)mimetypesByExtension.get("html"));
        MimetypeMapTest.assertEquals((String)"jpg", (String)extensionsByMimetype.get("image/jpeg"));
        MimetypeMapTest.assertEquals((String)"image/jpeg", (String)mimetypesByExtension.get("jpg"));
        MimetypeMapTest.assertEquals((String)"image/jpeg", (String)mimetypesByExtension.get("jpeg"));
        MimetypeMapTest.assertEquals((String)"image/jpeg", (String)mimetypesByExtension.get("jpe"));
        MimetypeMapTest.assertEquals((String)"doc", (String)extensionsByMimetype.get("application/msword"));
        MimetypeMapTest.assertEquals((String)"application/msword", (String)mimetypesByExtension.get("doc"));
        MimetypeMapTest.assertEquals((String)"sds", (String)extensionsByMimetype.get("application/vnd.stardivision.chart"));
    }

    public void testIsText() throws Exception {
        MimetypeMapTest.assertTrue((boolean)this.mimetypeService.isText("text/html"));
    }

    public void testGetContentCharsetFinder() throws Exception {
        MimetypeMapTest.assertNotNull((String)"No charset finder", (Object)this.mimetypeService.getContentCharsetFinder());
    }

    public void testMimetypeFromExtension() throws Exception {
        MimetypeMapTest.assertEquals((String)"application/msword", (String)this.mimetypeService.getMimetype("doc"));
        MimetypeMapTest.assertEquals((String)"application/msword", (String)this.mimetypeService.getMimetype("DOC"));
        MimetypeMapTest.assertEquals((String)"application/octet-stream", (String)this.mimetypeService.getMimetype(null));
        MimetypeMapTest.assertEquals((String)"application/octet-stream", (String)this.mimetypeService.getMimetype("unknownext"));
    }

    public void testGuessMimetypeForFilename() throws Exception {
        MimetypeMapTest.assertEquals((String)"application/msword", (String)this.mimetypeService.guessMimetype("something.doc"));
        MimetypeMapTest.assertEquals((String)"application/msword", (String)this.mimetypeService.guessMimetype("SOMETHING.DOC"));
        MimetypeMapTest.assertEquals((String)"application/octet-stream", (String)this.mimetypeService.guessMimetype("noextension"));
        MimetypeMapTest.assertEquals((String)"application/octet-stream", (String)this.mimetypeService.guessMimetype("file.unknownext"));
        MimetypeMapTest.assertEquals((String)"application/msword", (String)this.mimetypeService.guessMimetype("something.doc", null));
        MimetypeMapTest.assertEquals((String)"application/msword", (String)this.mimetypeService.guessMimetype("SOMETHING.DOC", null));
        MimetypeMapTest.assertEquals((String)"application/octet-stream", (String)this.mimetypeService.guessMimetype("noextension", null));
        MimetypeMapTest.assertEquals((String)"application/octet-stream", (String)this.mimetypeService.guessMimetype("file.unknownext", null));
    }

    public void testNoDuplicates() throws Exception {
        this.setConfigService("      <mimetype mimetype=\"mimetype1\" display=\"Mimetype ONE\">        <extension display=\"Extension ONE\">ext1a</extension>      </mimetype>      <mimetype mimetype=\"mimetype2\" display=\"Mimetype TWO\" text=\"true\">        <extension>ext2a</extension>      </mimetype>      <mimetype mimetype=\"mimetype3\" display=\"Mimetype THREE\">        <extension>ext3a</extension>        <extension>ext3b</extension>      </mimetype>");
        ((MimetypeMap)this.mimetypeService).init();
        MimetypeMapTest.assertFalse((String)"mimetype1 should not be text", (boolean)this.mimetypeService.isText("mimetype1"));
        MimetypeMapTest.assertEquals((String)"ext1a", (String)this.mimetypeService.getExtension("mimetype1"));
        MimetypeMapTest.assertEquals((String)"mimetype1", (String)this.mimetypeService.getMimetype("ext1a"));
        MimetypeMapTest.assertEquals((String)"Mimetype ONE", (String)this.mimetypeService.getDisplaysByMimetype().get("mimetype1"));
        MimetypeMapTest.assertEquals((String)"Extension ONE", (String)this.mimetypeService.getDisplaysByExtension().get("ext1a"));
        MimetypeMapTest.assertTrue((String)"mimetype2 should be text", (boolean)this.mimetypeService.isText("mimetype2"));
        MimetypeMapTest.assertEquals((String)"mimetype2", (String)this.mimetypeService.getMimetype("ext2a"));
        MimetypeMapTest.assertEquals((String)"mimetype3", (String)this.mimetypeService.getMimetype("ext3a"));
    }

    public void testDuplicates() throws Exception {
        this.setConfigService("      <mimetype mimetype=\"mimetype1\" display=\"Mimetype ONE\">        <extension display=\"Extension ONE\">ext1a</extension>      </mimetype>      <mimetype mimetype=\"mimetype1\" display=\"Mimetype ONE\">        <extension display=\"Extension 1\">ext1a</extension>      </mimetype>      <mimetype mimetype=\"mimetype1\" display=\"Mimetype ONE\">        <extension>ext1a</extension>      </mimetype>      <mimetype mimetype=\"mimetype1\" display=\"Mimetype 1\">        <extension>ext1a</extension>      </mimetype>      <mimetype mimetype=\"mimetype1\" text=\"true\">        <extension>ext1a</extension>      </mimetype>      <mimetype mimetype=\"mimetype1\" text=\"true\">        <extension>ext1a</extension>        <extension default=\"true\">ext1b</extension>        <extension>ext1c</extension>      </mimetype>      <mimetype mimetype=\"mimetype2\" display=\"Mimetype TWO\" text=\"true\">        <extension>ext2a</extension>      </mimetype>      <mimetype mimetype=\"mimetype2\" display=\"Mimetype TWO\">        <extension>ext2a</extension>      </mimetype>      <mimetype mimetype=\"mimetype3\" display=\"Mimetype THREE\">        <extension>ext3a</extension>        <extension>ext3b</extension>      </mimetype>      <mimetype mimetype=\"mimetype3\" display=\"Mimetype THREE\">        <extension>ext3a</extension>        <extension>ext3b</extension>      </mimetype>");
        ((MimetypeMap)this.mimetypeService).init();
        MimetypeMapTest.assertTrue((String)"mimetype1 should have be reset to text", (boolean)this.mimetypeService.isText("mimetype1"));
        MimetypeMapTest.assertEquals((String)"ext1b", (String)this.mimetypeService.getExtension("mimetype1"));
        MimetypeMapTest.assertEquals((String)"mimetype1", (String)this.mimetypeService.getMimetype("ext1a"));
        MimetypeMapTest.assertEquals((String)"mimetype1", (String)this.mimetypeService.getMimetype("ext1b"));
        MimetypeMapTest.assertEquals((String)"mimetype1", (String)this.mimetypeService.getMimetype("ext1c"));
        MimetypeMapTest.assertEquals((String)"Mimetype 1", (String)this.mimetypeService.getDisplaysByMimetype().get("mimetype1"));
        MimetypeMapTest.assertEquals((String)"Extension 1", (String)this.mimetypeService.getDisplaysByExtension().get("ext1a"));
        MimetypeMapTest.assertFalse((String)"mimetype2 should have be reset to not text", (boolean)this.mimetypeService.isText("mimetype2"));
        MimetypeMapTest.assertEquals((String)"mimetype2", (String)this.mimetypeService.getMimetype("ext2a"));
        MimetypeMapTest.assertEquals((String)"mimetype3", (String)this.mimetypeService.getMimetype("ext3a"));
    }

    private void setConfigService(final String mimetypes) {
        ConfigSource configSource = new ConfigSource(){

            public List<ConfigDeployment> getConfigDeployments() {
                String xml = "<alfresco-config area=\"mimetype-map\">  <config evaluator=\"string-compare\" condition=\"Mimetype Map\">    <mimetypes>" + mimetypes + "    </mimetypes>" + "  </config>" + "</alfresco-config>";
                ArrayList<ConfigDeployment> configs = new ArrayList<ConfigDeployment>();
                configs.add(new ConfigDeployment("name", (InputStream)new ByteArrayInputStream(xml.getBytes())));
                return configs;
            }
        };
        XMLConfigService configService = new XMLConfigService(configSource);
        configService.initConfig();
        ((MimetypeMap)this.mimetypeService).setConfigService((ConfigService)configService);
    }
}

