/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.dictionary;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.alfresco.repo.dictionary.IndexTokenisationMode;
import org.alfresco.repo.dictionary.M2Constraint;
import org.alfresco.repo.dictionary.M2ConstraintDefinition;
import org.alfresco.repo.dictionary.M2Label;
import org.alfresco.repo.dictionary.M2ModelDiff;
import org.alfresco.repo.dictionary.M2Property;
import org.alfresco.repo.dictionary.M2PropertyOverride;
import org.alfresco.repo.dictionary.ModelQuery;
import org.alfresco.service.cmr.dictionary.ClassDefinition;
import org.alfresco.service.cmr.dictionary.ConstraintDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryException;
import org.alfresco.service.cmr.dictionary.ModelDefinition;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.EqualsHelper;
import org.springframework.extensions.surf.util.I18NUtil;
import org.springframework.util.StringUtils;

class M2PropertyDefinition
implements PropertyDefinition {
    private ClassDefinition classDef;
    private M2Property m2Property;
    private QName name;
    private QName propertyTypeName;
    private DataTypeDefinition dataType;
    private String analyserResourceBundleName;
    private List<ConstraintDefinition> constraintDefs = Collections.emptyList();

    M2PropertyDefinition(ClassDefinition classDef, M2Property m2Property, NamespacePrefixResolver prefixResolver) {
        this.classDef = classDef;
        this.m2Property = m2Property;
        this.name = QName.createQName(m2Property.getName(), prefixResolver);
        this.propertyTypeName = QName.createQName(m2Property.getType(), prefixResolver);
        this.analyserResourceBundleName = m2Property.getAnalyserResourceBundleName();
    }

    M2PropertyDefinition(ClassDefinition classDef, PropertyDefinition propertyDef, M2PropertyOverride override, NamespacePrefixResolver prefixResolver, Map<QName, ConstraintDefinition> modelConstraints) {
        this.classDef = classDef;
        this.m2Property = this.createOverriddenProperty(propertyDef, override, prefixResolver, modelConstraints);
        this.name = propertyDef.getName();
        this.dataType = propertyDef.getDataType();
        this.propertyTypeName = this.dataType.getName();
    }

    void resolveDependencies(ModelQuery query, NamespacePrefixResolver prefixResolver, Map<QName, ConstraintDefinition> modelConstraints) {
        if (this.propertyTypeName == null) {
            throw new DictionaryException("d_dictionary.property.err.property_type_not_specified", this.name.toPrefixString());
        }
        this.dataType = query.getDataType(this.propertyTypeName);
        if (this.dataType == null) {
            throw new DictionaryException("d_dictionary.property.err.property_type_not_found", this.propertyTypeName.toPrefixString(), this.name.toPrefixString());
        }
        if (this.propertyTypeName.equals(DataTypeDefinition.CONTENT) && this.isMultiValued()) {
            throw new DictionaryException("d_dictionary.property.err.single_valued_content");
        }
        this.constraintDefs = M2PropertyDefinition.buildConstraints(this.m2Property.getConstraints(), this, prefixResolver, modelConstraints);
    }

    private static List<ConstraintDefinition> buildConstraints(List<M2Constraint> m2constraints, M2PropertyDefinition m2PropertyDef, NamespacePrefixResolver prefixResolver, Map<QName, ConstraintDefinition> modelConstraints) {
        ArrayList<ConstraintDefinition> constraints = new ArrayList<ConstraintDefinition>(5);
        HashMap<QName, M2ConstraintDefinition> constraintsByQName = new HashMap<QName, M2ConstraintDefinition>(7);
        for (M2Constraint constraint : m2constraints) {
            M2ConstraintDefinition def = new M2ConstraintDefinition(m2PropertyDef, constraint, prefixResolver);
            QName qname = def.getName();
            if (constraintsByQName.containsKey(qname)) {
                throw new DictionaryException("d_dictionary.property.err.duplicate_constraint_on_property", def.getName().toPrefixString(), m2PropertyDef.name.toPrefixString());
            }
            if (modelConstraints.containsKey(qname)) {
                throw new DictionaryException("d_dictionary.model.err.duplicate_constraint_on_model", def.getName().toPrefixString());
            }
            constraintsByQName.put(qname, def);
            constraints.add(def);
            modelConstraints.put(qname, def);
        }
        return constraints;
    }

    private M2Property createOverriddenProperty(PropertyDefinition propertyDef, M2PropertyOverride override, NamespacePrefixResolver prefixResolver, Map<QName, ConstraintDefinition> modelConstraints) {
        M2Property property = new M2Property();
        property.setOverride(true);
        String defaultValue = override.getDefaultValue();
        property.setDefaultValue(defaultValue == null ? propertyDef.getDefaultValue() : defaultValue);
        Boolean isOverrideMandatory = override.isMandatory();
        Boolean isOverrideMandatoryEnforced = override.isMandatoryEnforced();
        if (isOverrideMandatory != null && propertyDef.isMandatory()) {
            if (!isOverrideMandatory.booleanValue()) {
                throw new DictionaryException("d_dictionary.property.err.cannot_relax_mandatory", propertyDef.getName().toPrefixString());
            }
            if (isOverrideMandatoryEnforced != null && !isOverrideMandatoryEnforced.booleanValue() && propertyDef.isMandatoryEnforced()) {
                throw new DictionaryException("d_dictionary.property.err.cannot_relax_mandatory_enforcement", propertyDef.getName().toPrefixString());
            }
        }
        property.setMandatory(isOverrideMandatory == null ? propertyDef.isMandatory() : isOverrideMandatory.booleanValue());
        property.setMandatoryEnforced(isOverrideMandatoryEnforced == null ? propertyDef.isMandatoryEnforced() : isOverrideMandatoryEnforced.booleanValue());
        List<M2Constraint> overrideConstraints = override.getConstraints();
        this.constraintDefs = overrideConstraints != null ? M2PropertyDefinition.buildConstraints(overrideConstraints, (M2PropertyDefinition)propertyDef, prefixResolver, modelConstraints) : propertyDef.getConstraints();
        property.setDescription(propertyDef.getDescription());
        property.setIndexed(propertyDef.isIndexed());
        property.setIndexedAtomically(propertyDef.isIndexedAtomically());
        property.setMultiValued(propertyDef.isMultiValued());
        property.setProtected(propertyDef.isProtected());
        property.setStoredInIndex(propertyDef.isStoredInIndex());
        property.setTitle(propertyDef.getTitle());
        property.setIndexTokenisationMode(propertyDef.getIndexTokenisationMode());
        return property;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Name: " + this.getName() + "\n");
        sb.append("Title: " + this.getTitle() + "\n");
        sb.append("Description: " + this.getDescription() + "\n");
        sb.append("Default Value: " + this.getDefaultValue() + "\n");
        sb.append("DataType Name: " + this.getDataType().getName() + "\n");
        sb.append("ContainerClass Name: " + this.getContainerClass().getName() + "\n");
        sb.append("isMultiValued: " + this.isMultiValued() + "\n");
        sb.append("isMandatory: " + this.isMandatory() + "\n");
        sb.append("isMandatoryEnforced: " + this.isMandatoryEnforced() + "\n");
        sb.append("isProtected: " + this.isProtected() + "\n");
        sb.append("isIndexed: " + this.isIndexed() + "\n");
        sb.append("isStoredInIndex: " + this.isStoredInIndex() + "\n");
        sb.append("isIndexedAtomically: " + this.isIndexedAtomically() + "\n");
        sb.append("indexTokenisationMode: " + (Object)((Object)this.getIndexTokenisationMode()) + "\n");
        return sb.toString();
    }

    @Override
    public ModelDefinition getModel() {
        return this.classDef.getModel();
    }

    @Override
    public QName getName() {
        return this.name;
    }

    @Override
    public String getTitle() {
        String value = M2Label.getLabel(this.classDef.getModel(), "property", this.name, "title");
        if (value == null) {
            value = this.m2Property.getTitle();
        }
        return value;
    }

    @Override
    public String getDescription() {
        String value = M2Label.getLabel(this.classDef.getModel(), "property", this.name, "description");
        if (value == null) {
            value = this.m2Property.getDescription();
        }
        return value;
    }

    @Override
    public String getDefaultValue() {
        return this.m2Property.getDefaultValue();
    }

    @Override
    public DataTypeDefinition getDataType() {
        return this.dataType;
    }

    @Override
    public ClassDefinition getContainerClass() {
        return this.classDef;
    }

    @Override
    public boolean isOverride() {
        return this.m2Property.isOverride();
    }

    @Override
    public boolean isMultiValued() {
        return this.m2Property.isMultiValued();
    }

    @Override
    public boolean isMandatory() {
        return this.m2Property.isMandatory();
    }

    @Override
    public boolean isMandatoryEnforced() {
        return this.m2Property.isMandatoryEnforced();
    }

    @Override
    public boolean isProtected() {
        return this.m2Property.isProtected();
    }

    @Override
    public boolean isIndexed() {
        if (this.m2Property.isIndexed() == null) {
            return true;
        }
        return this.m2Property.isIndexed();
    }

    @Override
    public boolean isStoredInIndex() {
        if (this.m2Property.isStoredInIndex() == null) {
            return false;
        }
        return this.m2Property.isStoredInIndex();
    }

    @Override
    public boolean isIndexedAtomically() {
        if (this.m2Property.isIndexedAtomically() == null) {
            return true;
        }
        return this.m2Property.isIndexedAtomically();
    }

    @Override
    public IndexTokenisationMode getIndexTokenisationMode() {
        if (this.m2Property.getIndexTokenisationMode() == null) {
            return IndexTokenisationMode.TRUE;
        }
        return this.m2Property.getIndexTokenisationMode();
    }

    @Override
    public List<ConstraintDefinition> getConstraints() {
        return this.constraintDefs;
    }

    M2ModelDiff diffProperty(PropertyDefinition propDef) {
        M2ModelDiff modelDiff = null;
        boolean isUpdated = false;
        boolean isUpdatedIncrementally = false;
        if (this == propDef) {
            modelDiff = new M2ModelDiff(this.name, "PROPERTY", "unchanged");
            return modelDiff;
        }
        if (!this.name.equals(propDef.getName())) {
            isUpdated = true;
        }
        if (!EqualsHelper.nullSafeEquals((String)this.getTitle(), (String)propDef.getTitle(), (boolean)false)) {
            isUpdatedIncrementally = true;
        }
        if (!EqualsHelper.nullSafeEquals((String)this.getDescription(), (String)propDef.getDescription(), (boolean)false)) {
            isUpdatedIncrementally = true;
        }
        if (!EqualsHelper.nullSafeEquals((String)this.getDefaultValue(), (String)propDef.getDefaultValue(), (boolean)false)) {
            isUpdatedIncrementally = true;
        }
        if (!EqualsHelper.nullSafeEquals((Object)this.getDataType().getName(), (Object)propDef.getDataType().getName())) {
            isUpdated = true;
        }
        if (!EqualsHelper.nullSafeEquals((Object)this.getContainerClass().getName(), (Object)propDef.getContainerClass().getName())) {
            isUpdated = true;
        }
        if (this.isMultiValued() != propDef.isMultiValued()) {
            isUpdated = true;
        }
        if (this.isMandatory() != propDef.isMandatory()) {
            isUpdated = true;
        }
        if (this.isMandatoryEnforced() != propDef.isMandatoryEnforced()) {
            isUpdated = true;
        }
        if (this.isProtected() != propDef.isProtected()) {
            isUpdated = true;
        }
        if (this.isIndexed() != propDef.isIndexed()) {
            isUpdated = true;
        }
        if (this.isStoredInIndex() != propDef.isStoredInIndex()) {
            isUpdatedIncrementally = true;
        }
        if (this.isIndexedAtomically() != propDef.isIndexedAtomically()) {
            isUpdatedIncrementally = true;
        }
        if (!EqualsHelper.nullSafeEquals((String)this.getIndexTokenisationMode().toString(), (String)propDef.getIndexTokenisationMode().toString(), (boolean)false)) {
            isUpdated = true;
        }
        if (this.isOverride() != propDef.isOverride()) {
            isUpdated = true;
        }
        modelDiff = isUpdated ? new M2ModelDiff(this.name, "PROPERTY", "updated") : (isUpdatedIncrementally ? new M2ModelDiff(this.name, "PROPERTY", "updated_inc") : new M2ModelDiff(this.name, "PROPERTY", "unchanged"));
        return modelDiff;
    }

    static Collection<M2ModelDiff> diffPropertyLists(Collection<PropertyDefinition> previousProperties, Collection<PropertyDefinition> newProperties) {
        boolean found;
        ArrayList<M2ModelDiff> modelDiffs = new ArrayList<M2ModelDiff>();
        for (PropertyDefinition previousProperty : previousProperties) {
            found = false;
            for (PropertyDefinition newProperty : newProperties) {
                if (!newProperty.getName().equals(previousProperty.getName())) continue;
                modelDiffs.add(((M2PropertyDefinition)previousProperty).diffProperty(newProperty));
                found = true;
                break;
            }
            if (found) continue;
            modelDiffs.add(new M2ModelDiff(previousProperty.getName(), "PROPERTY", "deleted"));
        }
        for (PropertyDefinition newProperty : newProperties) {
            found = false;
            for (PropertyDefinition previousProperty : previousProperties) {
                if (!newProperty.getName().equals(previousProperty.getName())) continue;
                found = true;
                break;
            }
            if (found) continue;
            modelDiffs.add(new M2ModelDiff(newProperty.getName(), "PROPERTY", "created"));
        }
        return modelDiffs;
    }

    @Override
    public String getAnalyserResourceBundleName() {
        return this.analyserResourceBundleName;
    }

    @Override
    public String resolveAnalyserClassName() {
        return this.resolveAnalyserClassName(I18NUtil.getLocale());
    }

    @Override
    public String resolveAnalyserClassName(Locale locale) {
        ResourceBundle bundle;
        ResourceBundle bundle2;
        ClassLoader resourceBundleClassLoader = this.getModel().getDictionaryDAO().getResourceClassLoader();
        if (resourceBundleClassLoader == null) {
            resourceBundleClassLoader = this.getClass().getClassLoader();
        }
        StringBuilder keyBuilder = new StringBuilder(64);
        keyBuilder.append(this.getDataType().getModel().getName().toPrefixString());
        keyBuilder.append(".datatype");
        keyBuilder.append(".").append(this.getDataType().getName().toPrefixString());
        keyBuilder.append(".analyzer");
        String key = StringUtils.replace((String)keyBuilder.toString(), (String)":", (String)"_");
        String analyserClassName = null;
        String analyserResourceBundleName = this.getAnalyserResourceBundleName();
        if (analyserResourceBundleName != null && (bundle2 = ResourceBundle.getBundle(analyserResourceBundleName, locale, resourceBundleClassLoader)).containsKey(key)) {
            analyserClassName = bundle2.getString(key);
        }
        ClassDefinition classDefinition = null;
        ClassDefinition parentClassDefinition = null;
        while (analyserClassName == null) {
            ResourceBundle bundle3;
            if (classDefinition == null) {
                classDefinition = this.getContainerClass();
            } else {
                if (parentClassDefinition == null) break;
                classDefinition = parentClassDefinition;
            }
            parentClassDefinition = classDefinition.getParentClassDefinition();
            analyserResourceBundleName = classDefinition.getAnalyserResourceBundleName();
            if (analyserResourceBundleName != null && (bundle3 = ResourceBundle.getBundle(analyserResourceBundleName, locale, resourceBundleClassLoader)).containsKey(key)) {
                analyserClassName = bundle3.getString(key);
            }
            if (analyserClassName != null || parentClassDefinition != null && classDefinition.getModel().getName().equals(parentClassDefinition.getModel().getName()) || (analyserResourceBundleName = classDefinition.getModel().getAnalyserResourceBundleName()) == null || !(bundle3 = ResourceBundle.getBundle(analyserResourceBundleName, locale, resourceBundleClassLoader)).containsKey(key)) continue;
            analyserClassName = bundle3.getString(key);
        }
        String defaultAnalyserResourceBundleName = this.getContainerClass().getModel().getDictionaryDAO().getDefaultAnalyserResourceBundleName();
        if (analyserClassName == null && defaultAnalyserResourceBundleName != null && (bundle = ResourceBundle.getBundle(defaultAnalyserResourceBundleName, locale, resourceBundleClassLoader)).containsKey(key)) {
            analyserClassName = bundle.getString(key);
        }
        if (analyserClassName == null) {
            analyserClassName = this.getDataType().resolveAnalyserClassName(locale);
        }
        return analyserClassName;
    }
}

