/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.lucene.analysis;

import java.io.IOException;
import java.io.Reader;
import org.alfresco.repo.search.impl.lucene.analysis.NumericEncoder;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.WhitespaceTokenizer;

public class IntegerTokenFilter
extends Tokenizer {
    Tokenizer baseTokeniser;

    public IntegerTokenFilter(Reader in) {
        super(in);
        this.baseTokeniser = new WhitespaceTokenizer(in);
    }

    public Token next() throws IOException {
        Token candidate;
        while ((candidate = this.baseTokeniser.next()) != null) {
            try {
                Integer integer = Integer.valueOf(candidate.termText());
                String valueString = NumericEncoder.encode(integer);
                Token integerToken = new Token(valueString, candidate.startOffset(), candidate.startOffset(), candidate.type());
                return integerToken;
            }
            catch (NumberFormatException numberFormatException) {
            }
        }
        return null;
    }
}

