/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.lucene.analysis;

import java.io.IOException;
import java.io.Reader;
import java.text.DecimalFormat;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.Tokenizer;

public class PathTokenFilter
extends Tokenizer {
    public static final String INTEGER_FORMAT = "0000000000";
    public static final char PATH_SEPARATOR = ';';
    public static final char NAMESPACE_START_DELIMITER = '{';
    public static final char NAMESPACE_END_DELIMITER = '}';
    public static final String SEPARATOR_TOKEN_TEXT = ";";
    public static final String NO_NS_TOKEN_TEXT = "<No Namespace>";
    public static final String TOKEN_TYPE_PATH_SEP = "PATH_SEPARATOR";
    public static final String TOKEN_TYPE_PATH_LENGTH = "PATH_LENGTH";
    public static final String TOKEN_TYPE_PATH_ELEMENT_NAME = "PATH_ELEMENT_NAME";
    public static final String TOKEN_TYPE_PATH_ELEMENT_NAMESPACE = "PATH_ELEMENT_NAMESPACE";
    public static final String TOKEN_TYPE_PATH_ELEMENT_NAMESPACE_PREFIX = "PATH_ELEMENT_NAMESPACE_PREFIX";
    char pathSeparator;
    String separatorTokenText;
    String noNsTokenText;
    char nsStartDelimiter;
    int nsStartDelimiterLength;
    char nsEndDelimiter;
    int nsEndDelimiterLength;
    char nsPrefixDelimiter = (char)58;
    LinkedList<Token> tokens = new LinkedList();
    Iterator<Token> it = null;
    private boolean includeNamespace;
    int readerPosition = 0;

    public PathTokenFilter(Reader in, char pathSeparator, String separatorTokenText, String noNsTokenText, char nsStartDelimiter, char nsEndDelimiter, boolean includeNameSpace) {
        super(in);
        this.pathSeparator = pathSeparator;
        this.separatorTokenText = separatorTokenText;
        this.noNsTokenText = noNsTokenText;
        this.nsStartDelimiter = nsStartDelimiter;
        this.nsEndDelimiter = nsEndDelimiter;
        this.includeNamespace = includeNameSpace;
        this.nsStartDelimiterLength = 1;
        this.nsEndDelimiterLength = 1;
    }

    public Token next() throws IOException {
        if (this.it == null) {
            this.buildTokenListAndIterator();
        }
        Token nextToken = this.it.hasNext() ? this.it.next() : null;
        return nextToken;
    }

    private void buildTokenListAndIterator() throws IOException {
        Token t;
        DecimalFormat nf = new DecimalFormat(INTEGER_FORMAT);
        int insertCountAt = 0;
        int lengthCounter = 0;
        Token pathSplitToken = null;
        Token nameToken = null;
        Token countToken = null;
        Token namespaceToken = null;
        while ((t = this.nextToken()) != null) {
            String text = t.termText();
            if (text.length() == 0) continue;
            if (text.charAt(text.length() - 1) == this.pathSeparator) {
                text = text.substring(0, text.length() - 1);
                pathSplitToken = new Token(this.separatorTokenText, t.startOffset(), t.endOffset(), TOKEN_TYPE_PATH_SEP);
                pathSplitToken.setPositionIncrement(1);
            }
            int split = -1;
            boolean isPrefix = false;
            if (text.length() > 0 && text.charAt(0) == this.nsStartDelimiter) {
                split = text.indexOf(this.nsEndDelimiter);
            }
            if (split == -1) {
                split = text.indexOf(this.nsPrefixDelimiter);
                isPrefix = true;
            }
            if (split == -1) {
                namespaceToken = new Token(this.noNsTokenText, t.startOffset(), t.startOffset(), TOKEN_TYPE_PATH_ELEMENT_NAMESPACE);
                nameToken = new Token(text, t.startOffset(), t.endOffset(), TOKEN_TYPE_PATH_ELEMENT_NAME);
            } else if (isPrefix) {
                namespaceToken = new Token(text.substring(0, split), t.startOffset(), t.startOffset() + split, TOKEN_TYPE_PATH_ELEMENT_NAMESPACE_PREFIX);
                nameToken = new Token(text.substring(split + 1), t.startOffset() + split + 1, t.endOffset(), TOKEN_TYPE_PATH_ELEMENT_NAME);
            } else {
                namespaceToken = new Token(text.substring(this.nsStartDelimiterLength, split + this.nsEndDelimiterLength - 1), t.startOffset(), t.startOffset() + split, TOKEN_TYPE_PATH_ELEMENT_NAMESPACE);
                nameToken = new Token(text.substring(split + this.nsEndDelimiterLength), t.startOffset() + split + this.nsEndDelimiterLength, t.endOffset(), TOKEN_TYPE_PATH_ELEMENT_NAME);
            }
            namespaceToken.setPositionIncrement(1);
            nameToken.setPositionIncrement(1);
            if (this.includeNamespace) {
                if (namespaceToken.termText().equals("")) {
                    namespaceToken = new Token(this.noNsTokenText, t.startOffset(), t.startOffset(), TOKEN_TYPE_PATH_ELEMENT_NAMESPACE);
                    namespaceToken.setPositionIncrement(1);
                }
                this.tokens.add(namespaceToken);
            }
            this.tokens.add(nameToken);
            ++lengthCounter;
            if (pathSplitToken == null) continue;
            String countString = nf.format(lengthCounter);
            countToken = new Token(countString, t.startOffset(), t.endOffset(), TOKEN_TYPE_PATH_SEP);
            countToken.setPositionIncrement(1);
            this.tokens.add(insertCountAt, countToken);
            this.tokens.add(pathSplitToken);
            lengthCounter = 0;
            insertCountAt = this.tokens.size();
            pathSplitToken = null;
        }
        String countString = nf.format(lengthCounter);
        countToken = new Token(countString, 0, 0, TOKEN_TYPE_PATH_SEP);
        countToken.setPositionIncrement(1);
        this.tokens.add(insertCountAt, countToken);
        if (this.tokens.size() == 0 || !this.tokens.get(this.tokens.size() - 1).termText().equals(TOKEN_TYPE_PATH_SEP)) {
            pathSplitToken = new Token(this.separatorTokenText, 0, 0, TOKEN_TYPE_PATH_SEP);
            pathSplitToken.setPositionIncrement(1);
            this.tokens.add(pathSplitToken);
        }
        this.it = this.tokens.iterator();
    }

    private Token nextToken() throws IOException {
        int current;
        if (this.readerPosition == -1) {
            return null;
        }
        StringBuilder buffer = new StringBuilder(64);
        boolean inNameSpace = false;
        int start = this.readerPosition;
        while ((current = this.input.read()) != -1) {
            char c = (char)current;
            ++this.readerPosition;
            if (c == this.nsStartDelimiter) {
                inNameSpace = true;
            } else if (c == this.nsEndDelimiter) {
                inNameSpace = false;
            } else {
                if (!inNameSpace && c == '/') {
                    return new Token(buffer.toString(), start, this.readerPosition - 1, "QNAME");
                }
                if (!inNameSpace && c == ';') {
                    buffer.append(c);
                    return new Token(buffer.toString(), start, this.readerPosition, "LASTQNAME");
                }
            }
            buffer.append(c);
        }
        int end = this.readerPosition - 1;
        this.readerPosition = -1;
        if (!inNameSpace) {
            return new Token(buffer.toString(), start, end, "QNAME");
        }
        throw new IllegalStateException("QName terminated incorrectly: " + buffer.toString());
    }
}

