/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.lucene.query;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.FilteredTermEnum;

public class CaseInsensitiveTermEnum
extends FilteredTermEnum {
    private String field = "";
    private boolean endEnum = false;
    private String text;

    public CaseInsensitiveTermEnum(IndexReader reader, Term term) throws IOException {
        this.field = term.field();
        this.text = term.text();
        this.setEnum(reader.terms(new Term(term.field(), "")));
    }

    public float difference() {
        return 1.0f;
    }

    protected boolean endEnum() {
        return this.endEnum;
    }

    protected boolean termCompare(Term term) {
        if (this.field.equals(term.field())) {
            String searchText = term.text();
            return searchText.equalsIgnoreCase(this.text);
        }
        this.endEnum = true;
        return false;
    }
}

