/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.querymodel.impl.lucene.functions;

import java.util.Map;
import java.util.Set;
import org.alfresco.repo.search.impl.lucene.AbstractLuceneQueryParser;
import org.alfresco.repo.search.impl.lucene.AnalysisMode;
import org.alfresco.repo.search.impl.lucene.LuceneFunction;
import org.alfresco.repo.search.impl.querymodel.Argument;
import org.alfresco.repo.search.impl.querymodel.FunctionEvaluationContext;
import org.alfresco.repo.search.impl.querymodel.PropertyArgument;
import org.alfresco.repo.search.impl.querymodel.impl.functions.FTSPhrase;
import org.alfresco.repo.search.impl.querymodel.impl.lucene.LuceneQueryBuilderComponent;
import org.alfresco.repo.search.impl.querymodel.impl.lucene.LuceneQueryBuilderContext;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.search.Query;

public class LuceneFTSPhrase
extends FTSPhrase
implements LuceneQueryBuilderComponent {
    @Override
    public Query addComponent(Set<String> selectors, Map<String, Argument> functionArgs, LuceneQueryBuilderContext luceneContext, FunctionEvaluationContext functionContext) throws ParseException {
        Query query;
        AbstractLuceneQueryParser lqp = luceneContext.getLuceneQueryParser();
        Argument argument = functionArgs.get("Phrase");
        String term = (String)((Object)argument.getValue(functionContext));
        Integer slop = lqp.getPhraseSlop();
        argument = functionArgs.get("Slop");
        if (argument != null) {
            slop = (Integer)argument.getValue(functionContext);
        }
        argument = functionArgs.get("TokenisationMode");
        AnalysisMode mode = (AnalysisMode)((Object)argument.getValue(functionContext));
        PropertyArgument propArg = (PropertyArgument)functionArgs.get("Property");
        if (propArg != null) {
            String prop = propArg.getPropertyName();
            query = lqp.getFieldQuery(functionContext.getLuceneFieldName(prop), term, mode, slop, LuceneFunction.FIELD);
        } else {
            query = lqp.getFieldQuery(lqp.getField(), term, mode, slop, LuceneFunction.FIELD);
        }
        return query;
    }
}

