/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authentication;

import java.util.Stack;
import net.sf.acegisecurity.Authentication;
import net.sf.acegisecurity.GrantedAuthority;
import net.sf.acegisecurity.GrantedAuthorityImpl;
import net.sf.acegisecurity.UserDetails;
import net.sf.acegisecurity.context.Context;
import net.sf.acegisecurity.context.ContextHolder;
import net.sf.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import net.sf.acegisecurity.providers.dao.User;
import org.alfresco.repo.security.authentication.AlfrescoSecureContext;
import org.alfresco.repo.security.authentication.AlfrescoSecureContextImpl;
import org.alfresco.repo.security.authentication.AuthenticationException;
import org.alfresco.repo.security.authentication.InMemoryTicketComponentImpl;
import org.alfresco.util.EqualsHelper;
import org.alfresco.util.log.NDC;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;

public class AuthenticationUtil
implements InitializingBean {
    static Log s_logger = LogFactory.getLog(AuthenticationUtil.class);
    private static boolean initialized = false;
    public static final String SYSTEM_USER_NAME = "System";
    private static String defaultAdminUserName = "ROLE_ADMINISTRATOR";
    private static String defaultGuestUserName = "ROLE_GUEST";
    private static boolean mtEnabled = false;
    private static ThreadLocal<Stack<Authentication>> threadLocalFullAuthenticationStack = new ThreadLocalStack();
    private static ThreadLocal<Stack<Authentication>> threadLocalRunAsAuthenticationStack = new ThreadLocalStack();

    public void afterPropertiesSet() throws Exception {
        initialized = true;
    }

    public void setDefaultAdminUserName(String defaultAdminUserName) {
        AuthenticationUtil.defaultAdminUserName = defaultAdminUserName;
    }

    public void setDefaultGuestUserName(String defaultGuestUserName) {
        AuthenticationUtil.defaultGuestUserName = defaultGuestUserName;
    }

    public static void setMtEnabled(boolean mtEnabled) {
        AuthenticationUtil.mtEnabled = mtEnabled;
    }

    public static boolean isMtEnabled() {
        return mtEnabled;
    }

    private static UsernamePasswordAuthenticationToken getAuthenticationToken(String userName, UserDetails providedDetails) {
        GrantedAuthority[] gas;
        UserDetails ud = null;
        if (userName.equals(SYSTEM_USER_NAME)) {
            gas = new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_SYSTEM")};
            ud = new User(SYSTEM_USER_NAME, "", true, true, true, true, gas);
        } else if (userName.equalsIgnoreCase(AuthenticationUtil.getGuestUserName())) {
            gas = new GrantedAuthority[]{};
            ud = new User(AuthenticationUtil.getGuestUserName().toLowerCase(), "", true, true, true, true, gas);
        } else if (providedDetails.getUsername().equals(userName)) {
            ud = providedDetails;
        } else {
            throw new AuthenticationException("Provided user details do not match the user name");
        }
        UsernamePasswordAuthenticationToken auth = new UsernamePasswordAuthenticationToken((Object)ud, (Object)"", ud.getAuthorities());
        auth.setDetails((Object)ud);
        auth.setAuthenticated(true);
        return auth;
    }

    private static UserDetails getDefaultUserDetails(String userName) {
        GrantedAuthority[] gas = new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_AUTHENTICATED")};
        User ud = new User(userName, "", true, true, true, true, gas);
        return ud;
    }

    private static String getUserName(Authentication authentication) {
        if (authentication.getPrincipal() instanceof UserDetails) {
            return ((UserDetails)authentication.getPrincipal()).getUsername();
        }
        return authentication.getPrincipal().toString();
    }

    public static Authentication setAdminUserAsFullyAuthenticatedUser() {
        return AuthenticationUtil.setFullyAuthenticatedUser(AuthenticationUtil.getAdminUserName());
    }

    public static Authentication setFullyAuthenticatedUser(String userName) {
        return AuthenticationUtil.setFullyAuthenticatedUser(userName, AuthenticationUtil.getDefaultUserDetails(userName));
    }

    private static Authentication setFullyAuthenticatedUser(String userName, UserDetails providedDetails) throws AuthenticationException {
        if (userName == null) {
            throw new AuthenticationException("Null user name");
        }
        try {
            UsernamePasswordAuthenticationToken auth = AuthenticationUtil.getAuthenticationToken(userName, providedDetails);
            return AuthenticationUtil.setFullAuthentication((Authentication)auth);
        }
        catch (net.sf.acegisecurity.AuthenticationException ae) {
            throw new AuthenticationException(ae.getMessage(), ae);
        }
    }

    public static Authentication setFullAuthentication(Authentication authentication) {
        if (authentication == null) {
            AuthenticationUtil.clearCurrentSecurityContext();
            return null;
        }
        Context context = ContextHolder.getContext();
        AlfrescoSecureContext sc = null;
        if (context == null || !(context instanceof AlfrescoSecureContext)) {
            sc = new AlfrescoSecureContextImpl();
            ContextHolder.setContext((Context)sc);
        } else {
            sc = (AlfrescoSecureContext)context;
        }
        authentication.setAuthenticated(true);
        sc.setRealAuthentication(authentication);
        sc.setEffectiveAuthentication(authentication);
        return authentication;
    }

    public static Authentication setRunAsUserSystem() {
        return AuthenticationUtil.setRunAsUser(SYSTEM_USER_NAME);
    }

    public static Authentication setRunAsUser(String userName) {
        return AuthenticationUtil.setRunAsUser(userName, AuthenticationUtil.getDefaultUserDetails(userName));
    }

    static Authentication setRunAsUser(String userName, UserDetails providedDetails) throws AuthenticationException {
        if (userName == null) {
            throw new AuthenticationException("Null user name");
        }
        try {
            UsernamePasswordAuthenticationToken auth = AuthenticationUtil.getAuthenticationToken(userName, providedDetails);
            return AuthenticationUtil.setRunAsAuthentication((Authentication)auth);
        }
        catch (net.sf.acegisecurity.AuthenticationException ae) {
            throw new AuthenticationException(ae.getMessage(), ae);
        }
    }

    static Authentication setRunAsAuthentication(Authentication authentication) {
        if (authentication == null) {
            AuthenticationUtil.clearCurrentSecurityContext();
            return null;
        }
        Context context = ContextHolder.getContext();
        AlfrescoSecureContext sc = null;
        if (context == null || !(context instanceof AlfrescoSecureContext)) {
            sc = new AlfrescoSecureContextImpl();
            ContextHolder.setContext((Context)sc);
        } else {
            sc = (AlfrescoSecureContext)context;
        }
        authentication.setAuthenticated(true);
        if (sc.getRealAuthentication() == null) {
            sc.setRealAuthentication(authentication);
        }
        sc.setEffectiveAuthentication(authentication);
        return authentication;
    }

    public static Authentication getRunAsAuthentication() throws AuthenticationException {
        Context context = ContextHolder.getContext();
        if (context == null || !(context instanceof AlfrescoSecureContext)) {
            return null;
        }
        return ((AlfrescoSecureContext)context).getEffectiveAuthentication();
    }

    public static Authentication getFullAuthentication() throws AuthenticationException {
        Context context = ContextHolder.getContext();
        if (context == null || !(context instanceof AlfrescoSecureContext)) {
            return null;
        }
        return ((AlfrescoSecureContext)context).getRealAuthentication();
    }

    public static String getRunAsUser() throws AuthenticationException {
        Context context = ContextHolder.getContext();
        if (context == null || !(context instanceof AlfrescoSecureContext)) {
            return null;
        }
        AlfrescoSecureContext ctx = (AlfrescoSecureContext)context;
        if (ctx.getEffectiveAuthentication() == null) {
            return null;
        }
        return AuthenticationUtil.getUserName(ctx.getEffectiveAuthentication());
    }

    public static boolean isRunAsUserTheSystemUser() {
        int idx;
        String runAsUser = AuthenticationUtil.getRunAsUser();
        if (runAsUser != null && AuthenticationUtil.isMtEnabled() && (idx = runAsUser.indexOf("@")) != -1) {
            runAsUser = runAsUser.substring(0, idx);
        }
        return EqualsHelper.nullSafeEquals((Object)runAsUser, (Object)SYSTEM_USER_NAME);
    }

    public static String getFullyAuthenticatedUser() throws AuthenticationException {
        Context context = ContextHolder.getContext();
        if (context == null || !(context instanceof AlfrescoSecureContext)) {
            return null;
        }
        AlfrescoSecureContext ctx = (AlfrescoSecureContext)context;
        if (ctx.getRealAuthentication() == null) {
            return null;
        }
        return AuthenticationUtil.getUserName(ctx.getRealAuthentication());
    }

    public static String getSystemUserName() {
        return SYSTEM_USER_NAME;
    }

    public static String getAdminUserName() {
        String[] parts;
        String runAsUser;
        if (!initialized) {
            throw new IllegalStateException("AuthenticationUtil not yet initialised; default admin username not available");
        }
        if (AuthenticationUtil.isMtEnabled() && (runAsUser = AuthenticationUtil.getRunAsUser()) != null && (parts = AuthenticationUtil.splitUserTenant(runAsUser)).length == 2) {
            return defaultAdminUserName + "@" + parts[1];
        }
        return defaultAdminUserName;
    }

    public static String getAdminRoleName() {
        return "ROLE_ADMINISTRATOR";
    }

    public static String getGuestUserName() {
        if (!initialized) {
            throw new IllegalStateException("AuthenticationUtil not yet initialised; default guest username not available");
        }
        return defaultGuestUserName;
    }

    public static String getGuestRoleName() {
        return "ROLE_GUEST";
    }

    public static void clearCurrentSecurityContext() {
        ContextHolder.setContext(null);
        InMemoryTicketComponentImpl.clearCurrentSecurityContext();
        NDC.remove();
    }

    public static <R> R runAs(RunAsWork<R> runAsWork, String uid) {
        Authentication originalFullAuthentication = AuthenticationUtil.getFullAuthentication();
        Authentication originalRunAsAuthentication = AuthenticationUtil.getRunAsAuthentication();
        try {
            String originalRunAsUserName;
            if (originalFullAuthentication == null) {
                AuthenticationUtil.setFullyAuthenticatedUser(uid);
            } else {
                int idx;
                if (originalRunAsAuthentication != null && AuthenticationUtil.isMtEnabled() && (idx = (originalRunAsUserName = AuthenticationUtil.getUserName(originalRunAsAuthentication)).indexOf("@")) != -1 && idx < originalRunAsUserName.length() - 1 && uid.equals(AuthenticationUtil.getSystemUserName())) {
                    uid = uid + "@" + originalRunAsUserName.substring(idx + 1);
                }
                AuthenticationUtil.setRunAsUser(uid);
            }
            AuthenticationUtil.logNDC(uid);
            R result = runAsWork.doWork();
            originalRunAsUserName = result;
            return (R)originalRunAsUserName;
        }
        catch (Throwable exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new RuntimeException("Error during run as.", exception);
        }
        finally {
            if (originalFullAuthentication == null) {
                AuthenticationUtil.clearCurrentSecurityContext();
                AuthenticationUtil.logNDC(null);
            } else {
                AuthenticationUtil.setFullAuthentication(originalFullAuthentication);
                AuthenticationUtil.setRunAsAuthentication(originalRunAsAuthentication);
                AuthenticationUtil.logNDC(AuthenticationUtil.getUserName(originalFullAuthentication));
            }
        }
    }

    public static <R> R runAsSystem(RunAsWork<R> runAsWork) {
        return AuthenticationUtil.runAs(runAsWork, AuthenticationUtil.getSystemUserName());
    }

    public static void pushAuthentication() {
        Authentication originalFullAuthentication = AuthenticationUtil.getFullAuthentication();
        Authentication originalRunAsAuthentication = AuthenticationUtil.getRunAsAuthentication();
        threadLocalFullAuthenticationStack.get().push(originalFullAuthentication);
        threadLocalRunAsAuthenticationStack.get().push(originalRunAsAuthentication);
    }

    public static void popAuthentication() {
        Authentication originalFullAuthentication = threadLocalFullAuthenticationStack.get().pop();
        Authentication originalRunAsAuthentication = threadLocalRunAsAuthenticationStack.get().pop();
        if (originalFullAuthentication == null) {
            AuthenticationUtil.clearCurrentSecurityContext();
        } else {
            AuthenticationUtil.setFullAuthentication(originalFullAuthentication);
            AuthenticationUtil.setRunAsAuthentication(originalRunAsAuthentication);
        }
    }

    public static void logAuthenticatedUsers() {
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("Authentication: \n   Fully authenticated: " + AuthenticationUtil.getFullyAuthenticatedUser() + "\n" + "   Run as:              " + AuthenticationUtil.getRunAsUser()));
        }
    }

    public static void logNDC(String userName) {
        NDC.remove();
        if (userName != null) {
            if (AuthenticationUtil.isMtEnabled()) {
                String[] parts = AuthenticationUtil.splitUserTenant(userName);
                if (parts.length == 2) {
                    NDC.push((String)("Tenant:" + parts[1] + " User:" + parts[0]));
                } else {
                    NDC.push((String)("User:" + userName));
                }
            } else {
                NDC.push((String)("User:" + userName));
            }
        }
    }

    private static String[] splitUserTenant(String userName) {
        int idx = userName.lastIndexOf("@");
        if (idx > 0 && idx < userName.length() - 1) {
            return new String[]{userName.substring(0, idx), userName.substring(idx + 1)};
        }
        return new String[]{userName};
    }

    static class ThreadLocalStack
    extends ThreadLocal<Stack<Authentication>> {
        ThreadLocalStack() {
        }

        @Override
        protected Stack<Authentication> initialValue() {
            return new Stack<Authentication>();
        }
    }

    public static interface RunAsWork<Result> {
        public Result doWork() throws Exception;
    }
}

