/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authentication;

import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.CRC32;
import org.alfresco.repo.cache.SimpleCache;
import org.alfresco.repo.security.authentication.AuthenticationException;
import org.alfresco.repo.security.authentication.TicketComponent;
import org.alfresco.repo.security.authentication.TicketExpiredException;
import org.alfresco.service.cmr.repository.datatype.Duration;
import org.alfresco.util.GUID;
import org.apache.commons.codec.binary.Hex;
import org.safehaus.uuid.UUIDGenerator;

public class InMemoryTicketComponentImpl
implements TicketComponent {
    public static final String GRANTED_AUTHORITY_TICKET_PREFIX = "TICKET_";
    private static ThreadLocal<String> currentTicket = new ThreadLocal();
    private boolean ticketsExpire;
    private Duration validDuration;
    private boolean oneOff;
    private String guid;
    private SimpleCache<String, Ticket> ticketsCache;
    private ExpiryMode expiryMode = ExpiryMode.AFTER_FIXED_TIME;

    public InMemoryTicketComponentImpl() {
        this.guid = GUID.generate();
    }

    public void setTicketsCache(SimpleCache<String, Ticket> ticketsCache) {
        this.ticketsCache = ticketsCache;
    }

    @Override
    public String getNewTicket(String userName) throws AuthenticationException {
        Date expiryDate = null;
        if (this.ticketsExpire) {
            expiryDate = Duration.add(new Date(), this.validDuration);
        }
        Ticket ticket = new Ticket(this.ticketsExpire ? this.expiryMode : ExpiryMode.DO_NOT_EXPIRE, expiryDate, userName, this.validDuration);
        this.ticketsCache.put(ticket.getTicketId(), ticket);
        String ticketString = GRANTED_AUTHORITY_TICKET_PREFIX + ticket.getTicketId();
        currentTicket.set(ticketString);
        return ticketString;
    }

    @Override
    public String validateTicket(String ticketString) throws AuthenticationException {
        String ticketKey = this.getTicketKey(ticketString);
        Ticket ticket = this.ticketsCache.get(ticketKey);
        if (ticket == null) {
            throw new AuthenticationException("Missing ticket for " + ticketString);
        }
        Ticket newTicket = ticket.getNewEntry();
        if (newTicket == null) {
            throw new TicketExpiredException("Ticket expired for " + ticketString);
        }
        if (this.oneOff) {
            this.ticketsCache.remove(ticketKey);
        } else if (newTicket != ticket) {
            this.ticketsCache.put(ticketKey, newTicket);
        }
        currentTicket.set(ticketString);
        return newTicket.getUserName();
    }

    private Ticket getTicketByTicketString(String ticketString) {
        Ticket ticket = this.ticketsCache.get(this.getTicketKey(ticketString));
        return ticket;
    }

    private String getTicketKey(String ticketString) {
        if (ticketString == null) {
            return null;
        }
        if (ticketString.length() < GRANTED_AUTHORITY_TICKET_PREFIX.length()) {
            throw new AuthenticationException(ticketString + " is an invalid ticket format");
        }
        String key = ticketString.substring(GRANTED_AUTHORITY_TICKET_PREFIX.length());
        return key;
    }

    @Override
    public void invalidateTicketById(String ticketString) {
        String key = ticketString.substring(GRANTED_AUTHORITY_TICKET_PREFIX.length());
        this.ticketsCache.remove(key);
    }

    @Override
    public Set<String> getUsersWithTickets(boolean nonExpiredOnly) {
        HashSet<String> users = new HashSet<String>();
        for (String key : this.ticketsCache.getKeys()) {
            Ticket ticket = this.ticketsCache.get(key);
            if (ticket == null || nonExpiredOnly && ticket.getNewEntry() == null) continue;
            users.add(ticket.getUserName());
        }
        return users;
    }

    @Override
    public int countTickets(boolean nonExpiredOnly) {
        if (nonExpiredOnly) {
            int count = 0;
            for (String key : this.ticketsCache.getKeys()) {
                Ticket ticket = this.ticketsCache.get(key);
                if (ticket == null || ticket.getNewEntry() == null) continue;
                ++count;
            }
            return count;
        }
        return this.ticketsCache.getKeys().size();
    }

    @Override
    public int invalidateTickets(boolean expiredOnly) {
        int count = 0;
        if (!expiredOnly) {
            count = this.ticketsCache.getKeys().size();
            this.ticketsCache.clear();
        } else {
            HashSet<String> toRemove = new HashSet<String>();
            for (String key : this.ticketsCache.getKeys()) {
                Ticket ticket = this.ticketsCache.get(key);
                if (ticket != null && ticket.getNewEntry() != null) continue;
                ++count;
                toRemove.add(key);
            }
            for (String id : toRemove) {
                this.ticketsCache.remove(id);
            }
        }
        return count;
    }

    @Override
    public void invalidateTicketByUser(String userName) {
        HashSet<String> toRemove = new HashSet<String>();
        for (String key : this.ticketsCache.getKeys()) {
            Ticket ticket = this.ticketsCache.get(key);
            if (ticket == null || !ticket.getUserName().equals(userName)) continue;
            toRemove.add(ticket.getTicketId());
        }
        for (String id : toRemove) {
            this.ticketsCache.remove(id);
        }
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.guid == null ? 0 : this.guid.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InMemoryTicketComponentImpl other = (InMemoryTicketComponentImpl)obj;
        return !(this.guid == null ? other.guid != null : !this.guid.equals(other.guid));
    }

    public void setOneOff(boolean oneOff) {
        this.oneOff = oneOff;
    }

    public void setTicketsExpire(boolean ticketsExpire) {
        this.ticketsExpire = ticketsExpire;
    }

    public void setExpiryMode(String expiryMode) {
        this.expiryMode = ExpiryMode.valueOf(expiryMode);
    }

    public void setValidDuration(String validDuration) {
        this.validDuration = new Duration(validDuration);
    }

    @Override
    public String getAuthorityForTicket(String ticketString) {
        Ticket ticket = this.getTicketByTicketString(ticketString);
        if (ticket == null) {
            return null;
        }
        return ticket.getUserName();
    }

    @Override
    public String getCurrentTicket(String userName, boolean autoCreate) {
        String ticket = currentTicket.get();
        if (ticket == null) {
            return autoCreate ? this.getNewTicket(userName) : null;
        }
        String ticketUser = this.getAuthorityForTicket(ticket);
        if (userName.equals(ticketUser)) {
            return ticket;
        }
        return autoCreate ? this.getNewTicket(userName) : null;
    }

    @Override
    public void clearCurrentTicket() {
        InMemoryTicketComponentImpl.clearCurrentSecurityContext();
    }

    public static void clearCurrentSecurityContext() {
        currentTicket.set(null);
    }

    public static enum ExpiryMode {
        AFTER_INACTIVITY,
        AFTER_FIXED_TIME,
        DO_NOT_EXPIRE;

    }

    public static class Ticket
    implements Serializable {
        private static final long serialVersionUID = -5904510560161261049L;
        private final ExpiryMode expires;
        private final Date expiryDate;
        private final String userName;
        private final String ticketId;
        private final Duration validDuration;

        Ticket(ExpiryMode expires, Date expiryDate, String userName, Duration validDuration) {
            String ticketId;
            this.expires = expires;
            this.expiryDate = expiryDate;
            this.userName = userName;
            this.validDuration = validDuration;
            String guid = UUIDGenerator.getInstance().generateRandomBasedUUID().toString();
            String encode = expires.toString() + (expiryDate == null ? new Date().toString() : expiryDate.toString()) + userName + guid;
            try {
                MessageDigest digester = MessageDigest.getInstance("SHA-1");
                ticketId = new String(Hex.encodeHex((byte[])digester.digest(encode.getBytes())));
            }
            catch (NoSuchAlgorithmException e) {
                try {
                    MessageDigest digester = MessageDigest.getInstance("MD5");
                    ticketId = new String(Hex.encodeHex((byte[])digester.digest(encode.getBytes())));
                }
                catch (NoSuchAlgorithmException e1) {
                    CRC32 crc = new CRC32();
                    crc.update(encode.getBytes());
                    byte[] bytes = new byte[4];
                    long value = crc.getValue();
                    bytes[0] = (byte)(value & 0xFFL);
                    bytes[1] = (byte)((value >>>= 4) & 0xFFL);
                    bytes[2] = (byte)((value >>>= 4) & 0xFFL);
                    bytes[3] = (byte)((value >>>= 4) & 0xFFL);
                    ticketId = new String(Hex.encodeHex((byte[])bytes));
                }
            }
            this.ticketId = ticketId;
        }

        private Ticket(ExpiryMode expires, Date expiryDate, String userName, Duration validDuration, String ticketId) {
            this.expires = expires;
            this.expiryDate = expiryDate;
            this.userName = userName;
            this.validDuration = validDuration;
            this.ticketId = ticketId;
        }

        Ticket getNewEntry() {
            switch (this.expires) {
                case AFTER_FIXED_TIME: {
                    if (this.expiryDate != null && this.expiryDate.compareTo(new Date()) < 0) {
                        return null;
                    }
                    return this;
                }
                case AFTER_INACTIVITY: {
                    Date now = new Date();
                    if (this.expiryDate != null && this.expiryDate.compareTo(now) < 0) {
                        return null;
                    }
                    return new Ticket(this.expires, Duration.add(now, this.validDuration), this.userName, this.validDuration, this.ticketId);
                }
            }
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Ticket)) {
                return false;
            }
            Ticket t = (Ticket)o;
            return this.expires == t.expires && this.expiryDate.equals(t.expiryDate) && this.userName.equals(t.userName) && this.ticketId.equals(t.ticketId);
        }

        public int hashCode() {
            return this.ticketId.hashCode();
        }

        protected ExpiryMode getExpires() {
            return this.expires;
        }

        protected Date getExpiryDate() {
            return this.expiryDate;
        }

        protected String getTicketId() {
            return this.ticketId;
        }

        protected String getUserName() {
            return this.userName;
        }
    }
}

