/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.cmis.acl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.alfresco.cmis.CMISAccessControlEntriesGroupedByPrincipalId;
import org.alfresco.cmis.CMISAccessControlEntry;
import org.alfresco.cmis.CMISAccessControlReport;
import org.alfresco.cmis.CMISAclCapabilityEnum;
import org.alfresco.cmis.CMISAclPropagationEnum;
import org.alfresco.cmis.CMISConstraintException;
import org.alfresco.cmis.CMISPermissionDefinition;
import org.alfresco.cmis.CMISPermissionMapping;
import org.alfresco.cmis.acl.CMISAccessControlEntryImpl;
import org.alfresco.cmis.acl.CMISAccessControlServiceImpl;
import org.alfresco.cmis.mapping.BaseCMISTest;
import org.alfresco.model.ContentModel;
import org.alfresco.opencmis.CMISAccessControlFormatEnum;
import org.alfresco.repo.security.permissions.PermissionReference;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.AccessPermission;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;

public class CMISAccessControlServiceTest
extends BaseCMISTest {
    private NodeRef parent;
    private NodeRef child;
    private NodeRef grandParent;

    public void testAclPropagationMode() {
        CMISAccessControlServiceTest.assertEquals((Object)((Object)CMISAclPropagationEnum.PROPAGATE), (Object)((Object)this.cmisAccessControlService.getAclPropagation()));
    }

    public void testAclCapability() {
        CMISAccessControlServiceTest.assertEquals((Object)((Object)CMISAclCapabilityEnum.MANAGE), (Object)((Object)this.cmisAccessControlService.getAclCapability()));
    }

    public void testPermissions() {
        List<CMISPermissionDefinition> allPermissions = this.cmisAccessControlService.getRepositoryPermissions();
        CMISAccessControlServiceTest.assertEquals((int)69, (int)allPermissions.size());
        HashSet<CMISPermissionDefinition> permissionSet = new HashSet<CMISPermissionDefinition>();
        permissionSet.addAll(allPermissions);
        CMISAccessControlServiceTest.assertEquals((int)69, (int)permissionSet.size());
    }

    public void testAclReportingCmisPermissionsOnly() throws Exception {
        this.createTestAcls();
        CMISAccessControlReport grandParentReport = this.cmisAccessControlService.getAcl(this.grandParent, CMISAccessControlFormatEnum.CMIS_BASIC_PERMISSIONS);
        CMISAccessControlServiceTest.assertFalse((boolean)grandParentReport.isExact());
        CMISAccessControlServiceTest.assertEquals((int)10, (int)grandParentReport.getAccessControlEntries().size());
        CMISAccessControlServiceTest.assertTrue((boolean)this.checkCounts(grandParentReport, "ROLE_ADMINISTRATOR", 1, 2));
        CMISAccessControlServiceTest.assertTrue((boolean)this.checkCounts(grandParentReport, "GROUP_EVERYONE", 1, 0));
        CMISAccessControlServiceTest.assertTrue((boolean)this.checkCounts(grandParentReport, "ToMask", 1, 0));
        CMISAccessControlServiceTest.assertTrue((boolean)this.checkCounts(grandParentReport, "Full", 0, 3));
        CMISAccessControlServiceTest.assertTrue((boolean)this.checkCounts(grandParentReport, "Reader", 1, 0));
        CMISAccessControlServiceTest.assertTrue((boolean)this.checkCounts(grandParentReport, "Writer", 1, 0));
        CMISAccessControlServiceTest.assertTrue((boolean)this.checkAbsent(grandParentReport, "SplitRead"));
        CMISAccessControlServiceTest.assertTrue((boolean)this.checkAbsent(grandParentReport, "SplitWrite"));
        CMISAccessControlServiceTest.assertTrue((boolean)this.checkAbsent(grandParentReport, "DuplicateRead"));
        CMISAccessControlServiceTest.assertTrue((boolean)this.checkAbsent(grandParentReport, "Writer2"));
        CMISAccessControlServiceTest.assertTrue((boolean)this.checkAbsent(grandParentReport, "Multi"));
        CMISAccessControlReport parentReport = this.cmisAccessControlService.getAcl(this.parent, CMISAccessControlFormatEnum.CMIS_BASIC_PERMISSIONS);
        CMISAccessControlServiceTest.assertFalse((boolean)parentReport.isExact());
        CMISAccessControlServiceTest.assertEquals((int)10, (int)parentReport.getAccessControlEntries().size());
        CMISAccessControlServiceTest.assertTrue((boolean)this.checkCounts(parentReport, "ROLE_ADMINISTRATOR", 0, 3));
        CMISAccessControlServiceTest.assertTrue((boolean)this.checkCounts(parentReport, "GROUP_EVERYONE", 0, 1));
        CMISAccessControlServiceTest.assertTrue((boolean)this.checkAbsent(parentReport, "ToMask"));
        CMISAccessControlServiceTest.assertTrue((boolean)this.checkCounts(parentReport, "Full", 0, 3));
        CMISAccessControlServiceTest.assertTrue((boolean)this.checkCounts(parentReport, "Reader", 0, 1));
        CMISAccessControlServiceTest.assertTrue((boolean)this.checkCounts(parentReport, "Writer", 0, 1));
        CMISAccessControlServiceTest.assertTrue((boolean)this.checkAbsent(parentReport, "SplitRead"));
        CMISAccessControlServiceTest.assertTrue((boolean)this.checkAbsent(parentReport, "SplitWrite"));
        CMISAccessControlServiceTest.assertTrue((boolean)this.checkCounts(parentReport, "DuplicateRead", 1, 0));
        CMISAccessControlServiceTest.assertTrue((boolean)this.checkAbsent(parentReport, "Writer2"));
        CMISAccessControlServiceTest.assertTrue((boolean)this.checkAbsent(parentReport, "Multi"));
        CMISAccessControlReport childReport = this.cmisAccessControlService.getAcl(this.child, CMISAccessControlFormatEnum.CMIS_BASIC_PERMISSIONS);
        CMISAccessControlServiceTest.assertFalse((boolean)childReport.isExact());
        CMISAccessControlServiceTest.assertEquals((int)13, (int)childReport.getAccessControlEntries().size());
        CMISAccessControlServiceTest.assertTrue((boolean)this.checkCounts(childReport, "ROLE_ADMINISTRATOR", 0, 3));
        CMISAccessControlServiceTest.assertTrue((boolean)this.checkCounts(childReport, "GROUP_EVERYONE", 0, 1));
        CMISAccessControlServiceTest.assertTrue((boolean)this.checkAbsent(childReport, "ToMask"));
        CMISAccessControlServiceTest.assertTrue((boolean)this.checkCounts(childReport, "Full", 0, 3));
        CMISAccessControlServiceTest.assertTrue((boolean)this.checkCounts(childReport, "Reader", 0, 1));
        CMISAccessControlServiceTest.assertTrue((boolean)this.checkCounts(childReport, "Writer", 0, 1));
        CMISAccessControlServiceTest.assertTrue((boolean)this.checkAbsent(childReport, "SplitRead"));
        CMISAccessControlServiceTest.assertTrue((boolean)this.checkAbsent(childReport, "SplitWrite"));
        CMISAccessControlServiceTest.assertTrue((boolean)this.checkCounts(childReport, "DuplicateRead", 1, 0));
        CMISAccessControlServiceTest.assertTrue((boolean)this.checkCounts(childReport, "Writer2", 1, 0));
        CMISAccessControlServiceTest.assertTrue((boolean)this.checkCounts(childReport, "Multi", 2, 0));
    }

    private Set<String> getAllPermissions() {
        HashSet<String> answer = new HashSet<String>();
        PermissionReference allPermission = this.permissionModelDao.getPermissionReference(null, "All");
        Set<PermissionReference> all = this.permissionModelDao.getAllPermissions();
        for (PermissionReference pr : all) {
            answer.add(pr.toString());
        }
        answer.add(allPermission.toString());
        answer.add("cmis:all");
        answer.add("cmis:read");
        answer.add("cmis:write");
        return answer;
    }

    private boolean checkCounts(CMISAccessControlReport report, String key, int direct, int indirect) throws Exception {
        Set<String> permissionNames = this.getAllPermissions();
        for (CMISAccessControlEntry cMISAccessControlEntry : report.getAccessControlEntries()) {
            if (permissionNames.contains(cMISAccessControlEntry.getPermission())) continue;
            return false;
        }
        for (CMISAccessControlEntriesGroupedByPrincipalId cMISAccessControlEntriesGroupedByPrincipalId : report.getAccessControlEntriesGroupedByPrincipalId()) {
            if (!cMISAccessControlEntriesGroupedByPrincipalId.getPrincipalId().equals(key)) continue;
            if (cMISAccessControlEntriesGroupedByPrincipalId.getDirectPermissions().size() != direct) {
                return false;
            }
            return cMISAccessControlEntriesGroupedByPrincipalId.getIndirectPermissions().size() == indirect;
        }
        return false;
    }

    private boolean checkAbsent(CMISAccessControlReport report, String key) throws Exception {
        for (CMISAccessControlEntriesGroupedByPrincipalId cMISAccessControlEntriesGroupedByPrincipalId : report.getAccessControlEntriesGroupedByPrincipalId()) {
            if (!cMISAccessControlEntriesGroupedByPrincipalId.getPrincipalId().equals(key)) continue;
            return false;
        }
        return true;
    }

    public void testAclReportingAllPermissions() throws Exception {
        this.createTestAcls();
        CMISAccessControlReport grandParentReport = this.cmisAccessControlService.getAcl(this.grandParent, CMISAccessControlFormatEnum.REPOSITORY_SPECIFIC_PERMISSIONS);
        CMISAccessControlServiceTest.assertFalse((boolean)grandParentReport.isExact());
        CMISAccessControlServiceTest.assertEquals((int)17, (int)grandParentReport.getAccessControlEntries().size());
        CMISAccessControlServiceTest.assertTrue((boolean)this.checkCounts(grandParentReport, "ROLE_ADMINISTRATOR", 1, 3));
        CMISAccessControlServiceTest.assertTrue((boolean)this.checkCounts(grandParentReport, "GROUP_EVERYONE", 1, 1));
        CMISAccessControlServiceTest.assertTrue((boolean)this.checkCounts(grandParentReport, "ToMask", 1, 1));
        CMISAccessControlServiceTest.assertTrue((boolean)this.checkCounts(grandParentReport, "Full", 1, 3));
        CMISAccessControlServiceTest.assertTrue((boolean)this.checkCounts(grandParentReport, "Reader", 1, 1));
        CMISAccessControlServiceTest.assertTrue((boolean)this.checkCounts(grandParentReport, "Writer", 1, 1));
        CMISAccessControlServiceTest.assertTrue((boolean)this.checkAbsent(grandParentReport, "SplitRead"));
        CMISAccessControlServiceTest.assertTrue((boolean)this.checkAbsent(grandParentReport, "SplitWrite"));
        CMISAccessControlServiceTest.assertTrue((boolean)this.checkAbsent(grandParentReport, "DuplicateRead"));
        CMISAccessControlServiceTest.assertTrue((boolean)this.checkAbsent(grandParentReport, "Writer2"));
        CMISAccessControlServiceTest.assertTrue((boolean)this.checkCounts(grandParentReport, "Multi", 1, 0));
        CMISAccessControlReport parentReport = this.cmisAccessControlService.getAcl(this.parent, CMISAccessControlFormatEnum.REPOSITORY_SPECIFIC_PERMISSIONS);
        CMISAccessControlServiceTest.assertFalse((boolean)parentReport.isExact());
        CMISAccessControlServiceTest.assertEquals((int)20, (int)parentReport.getAccessControlEntries().size());
        CMISAccessControlServiceTest.assertTrue((boolean)this.checkCounts(parentReport, "ROLE_ADMINISTRATOR", 0, 4));
        CMISAccessControlServiceTest.assertTrue((boolean)this.checkCounts(parentReport, "GROUP_EVERYONE", 0, 2));
        CMISAccessControlServiceTest.assertTrue((boolean)this.checkAbsent(parentReport, "ToMask"));
        CMISAccessControlServiceTest.assertTrue((boolean)this.checkCounts(parentReport, "Full", 0, 4));
        CMISAccessControlServiceTest.assertTrue((boolean)this.checkCounts(parentReport, "Reader", 0, 2));
        CMISAccessControlServiceTest.assertTrue((boolean)this.checkCounts(parentReport, "Writer", 0, 2));
        CMISAccessControlServiceTest.assertTrue((boolean)this.checkCounts(parentReport, "SplitRead", 1, 0));
        CMISAccessControlServiceTest.assertTrue((boolean)this.checkCounts(parentReport, "SplitWrite", 1, 0));
        CMISAccessControlServiceTest.assertTrue((boolean)this.checkCounts(parentReport, "DuplicateRead", 1, 1));
        CMISAccessControlServiceTest.assertTrue((boolean)this.checkAbsent(grandParentReport, "Writer2"));
        CMISAccessControlServiceTest.assertTrue((boolean)this.checkCounts(parentReport, "Multi", 1, 1));
        CMISAccessControlReport childReport = this.cmisAccessControlService.getAcl(this.child, CMISAccessControlFormatEnum.REPOSITORY_SPECIFIC_PERMISSIONS);
        CMISAccessControlServiceTest.assertFalse((boolean)childReport.isExact());
        CMISAccessControlServiceTest.assertEquals((int)29, (int)childReport.getAccessControlEntries().size());
        CMISAccessControlServiceTest.assertTrue((boolean)this.checkCounts(childReport, "ROLE_ADMINISTRATOR", 0, 4));
        CMISAccessControlServiceTest.assertTrue((boolean)this.checkCounts(childReport, "GROUP_EVERYONE", 0, 2));
        CMISAccessControlServiceTest.assertTrue((boolean)this.checkAbsent(childReport, "ToMask"));
        CMISAccessControlServiceTest.assertTrue((boolean)this.checkCounts(childReport, "Full", 0, 4));
        CMISAccessControlServiceTest.assertTrue((boolean)this.checkCounts(childReport, "Reader", 0, 2));
        CMISAccessControlServiceTest.assertTrue((boolean)this.checkCounts(childReport, "Writer", 0, 2));
        CMISAccessControlServiceTest.assertTrue((boolean)this.checkCounts(childReport, "SplitRead", 1, 1));
        CMISAccessControlServiceTest.assertTrue((boolean)this.checkCounts(childReport, "SplitWrite", 1, 1));
        CMISAccessControlServiceTest.assertTrue((boolean)this.checkCounts(childReport, "DuplicateRead", 1, 1));
        CMISAccessControlServiceTest.assertTrue((boolean)this.checkCounts(childReport, "Writer2", 1, 1));
        CMISAccessControlServiceTest.assertTrue((boolean)this.checkCounts(childReport, "Multi", 3, 4));
    }

    private void createTestAcls() {
        this.grandParent = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"cm", (String)"Parent", (NamespacePrefixResolver)this.namespaceService), ContentModel.TYPE_FOLDER).getChildRef();
        this.nodeService.setProperty(this.grandParent, ContentModel.PROP_NAME, (Serializable)((Object)"GrandParent"));
        this.parent = this.nodeService.createNode(this.grandParent, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"cm", (String)"Child", (NamespacePrefixResolver)this.namespaceService), ContentModel.TYPE_FOLDER).getChildRef();
        this.nodeService.setProperty(this.parent, ContentModel.PROP_NAME, (Serializable)((Object)"Parent"));
        this.child = this.nodeService.createNode(this.parent, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"cm", (String)"Child", (NamespacePrefixResolver)this.namespaceService), ContentModel.TYPE_FOLDER).getChildRef();
        this.nodeService.setProperty(this.child, ContentModel.PROP_NAME, (Serializable)((Object)"Child"));
        this.permissionService.setPermission(this.grandParent, "ROLE_ADMINISTRATOR", "All", true);
        this.permissionService.setPermission(this.grandParent, "GROUP_EVERYONE", "Read", true);
        this.permissionService.setPermission(this.grandParent, "ToMask", "Read", true);
        this.permissionService.setPermission(this.grandParent, "Full", "FullControl", true);
        this.permissionService.setPermission(this.grandParent, "Writer", "Write", true);
        this.permissionService.setPermission(this.grandParent, "Reader", "Read", true);
        this.permissionService.setPermission(this.grandParent, "Multi", "Delete", true);
        this.permissionService.setPermission(this.parent, "ToMask", "Read", false);
        this.permissionService.setPermission(this.parent, "SplitRead", "ReadProperties", true);
        this.permissionService.setPermission(this.parent, "SplitWrite", "WriteContent", true);
        this.permissionService.setPermission(this.parent, "DuplicateRead", "Read", true);
        this.permissionService.setPermission(this.parent, "Multi", "CreateChildren", true);
        this.permissionService.setPermission(this.child, "SplitRead", "ReadContent", true);
        this.permissionService.setPermission(this.child, "Writer2", "Write", true);
        this.permissionService.setPermission(this.child, "SplitWrite", "WriteProperties", true);
        this.permissionService.setPermission(this.child, "DuplicateRead", "Read", true);
        this.permissionService.setPermission(this.child, "Multi", "Read", true);
        this.permissionService.setPermission(this.child, "Multi", "Write", true);
        this.permissionService.setPermission(this.child, "Multi", "SetOwner", true);
    }

    public void testAccessEntryOrdering() {
        this.createTestAcls();
        HashSet<CMISPermissionDefinition> permDefs = new HashSet<CMISPermissionDefinition>();
        permDefs.addAll(this.cmisAccessControlService.getRepositoryPermissions());
        Set permissions = this.permissionService.getAllSetPermissions(this.child);
        ArrayList<AccessPermission> ordered = new ArrayList<AccessPermission>();
        CMISAccessControlServiceImpl.AccessPermissionComparator comparator = new CMISAccessControlServiceImpl.AccessPermissionComparator();
        for (AccessPermission current : permissions) {
            int index = Collections.binarySearch(ordered, current, comparator);
            if (index >= 0) continue;
            ordered.add(-index - 1, current);
        }
        int i = 0;
        CMISAccessControlServiceTest.assertEquals((int)4, (int)((AccessPermission)ordered.get(i)).getPosition());
        CMISAccessControlServiceTest.assertEquals((Object)AccessStatus.ALLOWED, (Object)((AccessPermission)ordered.get(i)).getAccessStatus());
        CMISAccessControlServiceTest.assertEquals((String)"Full", (String)((AccessPermission)ordered.get(i)).getAuthority());
        CMISAccessControlServiceTest.assertEquals((int)4, (int)((AccessPermission)ordered.get(++i)).getPosition());
        CMISAccessControlServiceTest.assertEquals((Object)AccessStatus.ALLOWED, (Object)((AccessPermission)ordered.get(i)).getAccessStatus());
        CMISAccessControlServiceTest.assertEquals((String)"GROUP_EVERYONE", (String)((AccessPermission)ordered.get(i)).getAuthority());
        CMISAccessControlServiceTest.assertEquals((int)4, (int)((AccessPermission)ordered.get(++i)).getPosition());
        CMISAccessControlServiceTest.assertEquals((Object)AccessStatus.ALLOWED, (Object)((AccessPermission)ordered.get(i)).getAccessStatus());
        CMISAccessControlServiceTest.assertEquals((String)"Multi", (String)((AccessPermission)ordered.get(i)).getAuthority());
        CMISAccessControlServiceTest.assertEquals((int)4, (int)((AccessPermission)ordered.get(++i)).getPosition());
        CMISAccessControlServiceTest.assertEquals((Object)AccessStatus.ALLOWED, (Object)((AccessPermission)ordered.get(i)).getAccessStatus());
        CMISAccessControlServiceTest.assertEquals((String)"ROLE_ADMINISTRATOR", (String)((AccessPermission)ordered.get(i)).getAuthority());
        CMISAccessControlServiceTest.assertEquals((int)4, (int)((AccessPermission)ordered.get(++i)).getPosition());
        CMISAccessControlServiceTest.assertEquals((Object)AccessStatus.ALLOWED, (Object)((AccessPermission)ordered.get(i)).getAccessStatus());
        CMISAccessControlServiceTest.assertEquals((String)"Reader", (String)((AccessPermission)ordered.get(i)).getAuthority());
        CMISAccessControlServiceTest.assertEquals((int)4, (int)((AccessPermission)ordered.get(++i)).getPosition());
        CMISAccessControlServiceTest.assertEquals((Object)AccessStatus.ALLOWED, (Object)((AccessPermission)ordered.get(i)).getAccessStatus());
        CMISAccessControlServiceTest.assertEquals((String)"ToMask", (String)((AccessPermission)ordered.get(i)).getAuthority());
        CMISAccessControlServiceTest.assertEquals((int)4, (int)((AccessPermission)ordered.get(++i)).getPosition());
        CMISAccessControlServiceTest.assertEquals((Object)AccessStatus.ALLOWED, (Object)((AccessPermission)ordered.get(i)).getAccessStatus());
        CMISAccessControlServiceTest.assertEquals((String)"Writer", (String)((AccessPermission)ordered.get(i)).getAuthority());
        CMISAccessControlServiceTest.assertEquals((int)2, (int)((AccessPermission)ordered.get(++i)).getPosition());
        CMISAccessControlServiceTest.assertEquals((Object)AccessStatus.DENIED, (Object)((AccessPermission)ordered.get(i)).getAccessStatus());
        CMISAccessControlServiceTest.assertEquals((String)"ToMask", (String)((AccessPermission)ordered.get(i)).getAuthority());
        CMISAccessControlServiceTest.assertEquals((int)2, (int)((AccessPermission)ordered.get(++i)).getPosition());
        CMISAccessControlServiceTest.assertEquals((Object)AccessStatus.ALLOWED, (Object)((AccessPermission)ordered.get(i)).getAccessStatus());
        CMISAccessControlServiceTest.assertEquals((String)"DuplicateRead", (String)((AccessPermission)ordered.get(i)).getAuthority());
        CMISAccessControlServiceTest.assertEquals((int)2, (int)((AccessPermission)ordered.get(++i)).getPosition());
        CMISAccessControlServiceTest.assertEquals((Object)AccessStatus.ALLOWED, (Object)((AccessPermission)ordered.get(i)).getAccessStatus());
        CMISAccessControlServiceTest.assertEquals((String)"Multi", (String)((AccessPermission)ordered.get(i)).getAuthority());
        CMISAccessControlServiceTest.assertEquals((int)2, (int)((AccessPermission)ordered.get(++i)).getPosition());
        CMISAccessControlServiceTest.assertEquals((Object)AccessStatus.ALLOWED, (Object)((AccessPermission)ordered.get(i)).getAccessStatus());
        CMISAccessControlServiceTest.assertEquals((String)"SplitRead", (String)((AccessPermission)ordered.get(i)).getAuthority());
        CMISAccessControlServiceTest.assertEquals((int)2, (int)((AccessPermission)ordered.get(++i)).getPosition());
        CMISAccessControlServiceTest.assertEquals((Object)AccessStatus.ALLOWED, (Object)((AccessPermission)ordered.get(i)).getAccessStatus());
        CMISAccessControlServiceTest.assertEquals((String)"SplitWrite", (String)((AccessPermission)ordered.get(i)).getAuthority());
        CMISAccessControlServiceTest.assertEquals((int)0, (int)((AccessPermission)ordered.get(++i)).getPosition());
        CMISAccessControlServiceTest.assertEquals((Object)AccessStatus.ALLOWED, (Object)((AccessPermission)ordered.get(i)).getAccessStatus());
        CMISAccessControlServiceTest.assertEquals((String)"DuplicateRead", (String)((AccessPermission)ordered.get(i)).getAuthority());
        CMISAccessControlServiceTest.assertEquals((int)0, (int)((AccessPermission)ordered.get(++i)).getPosition());
        CMISAccessControlServiceTest.assertEquals((Object)AccessStatus.ALLOWED, (Object)((AccessPermission)ordered.get(i)).getAccessStatus());
        CMISAccessControlServiceTest.assertEquals((String)"Multi", (String)((AccessPermission)ordered.get(i)).getAuthority());
        CMISAccessControlServiceTest.assertEquals((int)0, (int)((AccessPermission)ordered.get(++i)).getPosition());
        CMISAccessControlServiceTest.assertEquals((Object)AccessStatus.ALLOWED, (Object)((AccessPermission)ordered.get(i)).getAccessStatus());
        CMISAccessControlServiceTest.assertEquals((String)"Multi", (String)((AccessPermission)ordered.get(i)).getAuthority());
        CMISAccessControlServiceTest.assertEquals((int)0, (int)((AccessPermission)ordered.get(++i)).getPosition());
        CMISAccessControlServiceTest.assertEquals((Object)AccessStatus.ALLOWED, (Object)((AccessPermission)ordered.get(i)).getAccessStatus());
        CMISAccessControlServiceTest.assertEquals((String)"Multi", (String)((AccessPermission)ordered.get(i)).getAuthority());
        CMISAccessControlServiceTest.assertEquals((int)0, (int)((AccessPermission)ordered.get(++i)).getPosition());
        CMISAccessControlServiceTest.assertEquals((Object)AccessStatus.ALLOWED, (Object)((AccessPermission)ordered.get(i)).getAccessStatus());
        CMISAccessControlServiceTest.assertEquals((String)"SplitRead", (String)((AccessPermission)ordered.get(i)).getAuthority());
        CMISAccessControlServiceTest.assertEquals((int)0, (int)((AccessPermission)ordered.get(++i)).getPosition());
        CMISAccessControlServiceTest.assertEquals((Object)AccessStatus.ALLOWED, (Object)((AccessPermission)ordered.get(i)).getAccessStatus());
        CMISAccessControlServiceTest.assertEquals((String)"SplitWrite", (String)((AccessPermission)ordered.get(i)).getAuthority());
        CMISAccessControlServiceTest.assertEquals((int)0, (int)((AccessPermission)ordered.get(++i)).getPosition());
        CMISAccessControlServiceTest.assertEquals((Object)AccessStatus.ALLOWED, (Object)((AccessPermission)ordered.get(i)).getAccessStatus());
        CMISAccessControlServiceTest.assertEquals((String)"Writer2", (String)((AccessPermission)ordered.get(i)).getAuthority());
    }

    public void testApplyAcl() throws Exception {
        this.grandParent = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"cm", (String)"Parent", (NamespacePrefixResolver)this.namespaceService), ContentModel.TYPE_FOLDER).getChildRef();
        this.nodeService.setProperty(this.grandParent, ContentModel.PROP_NAME, (Serializable)((Object)"GrandParent"));
        this.parent = this.nodeService.createNode(this.grandParent, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"cm", (String)"Child", (NamespacePrefixResolver)this.namespaceService), ContentModel.TYPE_FOLDER).getChildRef();
        this.nodeService.setProperty(this.parent, ContentModel.PROP_NAME, (Serializable)((Object)"Parent"));
        this.child = this.nodeService.createNode(this.parent, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"cm", (String)"Child", (NamespacePrefixResolver)this.namespaceService), ContentModel.TYPE_CONTENT).getChildRef();
        this.nodeService.setProperty(this.child, ContentModel.PROP_NAME, (Serializable)((Object)"Child"));
        ArrayList<CMISAccessControlEntry> acesToAdd = new ArrayList<CMISAccessControlEntry>();
        acesToAdd.add(new CMISAccessControlEntryImpl("ROLE_ADMINISTRATOR", "All"));
        acesToAdd.add(new CMISAccessControlEntryImpl("GROUP_EVERYONE", "Read"));
        acesToAdd.add(new CMISAccessControlEntryImpl("ToMask", "Read"));
        acesToAdd.add(new CMISAccessControlEntryImpl("Full", "FullControl"));
        acesToAdd.add(new CMISAccessControlEntryImpl("Writer", "Write"));
        acesToAdd.add(new CMISAccessControlEntryImpl("Reader", "Read"));
        CMISAccessControlReport grandParentReport = this.cmisAccessControlService.applyAcl(this.grandParent, null, acesToAdd, CMISAclPropagationEnum.PROPAGATE, CMISAccessControlFormatEnum.REPOSITORY_SPECIFIC_PERMISSIONS);
        CMISAccessControlServiceTest.assertFalse((boolean)grandParentReport.isExact());
        CMISAccessControlServiceTest.assertEquals((int)16, (int)grandParentReport.getAccessControlEntries().size());
        ArrayList<CMISAccessControlEntry> acesToRemove = new ArrayList<CMISAccessControlEntry>();
        acesToRemove.add(new CMISAccessControlEntryImpl("ToMask", "Read"));
        grandParentReport = this.cmisAccessControlService.applyAcl(this.grandParent, acesToRemove, null, CMISAclPropagationEnum.PROPAGATE, CMISAccessControlFormatEnum.REPOSITORY_SPECIFIC_PERMISSIONS);
        CMISAccessControlServiceTest.assertFalse((boolean)grandParentReport.isExact());
        CMISAccessControlServiceTest.assertEquals((int)14, (int)grandParentReport.getAccessControlEntries().size());
        try {
            grandParentReport = this.cmisAccessControlService.applyAcl(this.grandParent, acesToRemove, null, CMISAclPropagationEnum.PROPAGATE, CMISAccessControlFormatEnum.REPOSITORY_SPECIFIC_PERMISSIONS);
            CMISAccessControlServiceTest.fail((String)"A non existent ACE should not be removable");
        }
        catch (CMISConstraintException e) {
            // empty catch block
        }
        acesToAdd = new ArrayList();
        acesToAdd.add(new CMISAccessControlEntryImpl("SplitRead", this.permissionModelDao.getPermissionReference(null, "ReadProperties").toString()));
        acesToAdd.add(new CMISAccessControlEntryImpl("SplitWrite", this.permissionModelDao.getPermissionReference(null, "WriteContent").toString()));
        acesToAdd.add(new CMISAccessControlEntryImpl("DuplicateRead", this.permissionModelDao.getPermissionReference(null, "Read").toString()));
        CMISAccessControlReport parentReport = this.cmisAccessControlService.applyAcl(this.parent, null, acesToAdd, CMISAclPropagationEnum.PROPAGATE, CMISAccessControlFormatEnum.REPOSITORY_SPECIFIC_PERMISSIONS);
        CMISAccessControlServiceTest.assertFalse((boolean)parentReport.isExact());
        CMISAccessControlServiceTest.assertEquals((int)18, (int)parentReport.getAccessControlEntries().size());
        acesToAdd = new ArrayList();
        acesToAdd.add(new CMISAccessControlEntryImpl("SplitRead", "ReadContent"));
        acesToAdd.add(new CMISAccessControlEntryImpl("Writer2", "Write"));
        acesToAdd.add(new CMISAccessControlEntryImpl("SplitWrite", "WriteProperties"));
        acesToAdd.add(new CMISAccessControlEntryImpl("DuplicateRead", "Read"));
        CMISAccessControlReport childReport = this.cmisAccessControlService.applyAcl(this.child, null, acesToAdd, CMISAclPropagationEnum.PROPAGATE, CMISAccessControlFormatEnum.REPOSITORY_SPECIFIC_PERMISSIONS);
        CMISAccessControlServiceTest.assertFalse((boolean)childReport.isExact());
        CMISAccessControlServiceTest.assertEquals((int)22, (int)childReport.getAccessControlEntries().size());
        grandParentReport = this.cmisAccessControlService.getAcl(this.grandParent, CMISAccessControlFormatEnum.CMIS_BASIC_PERMISSIONS);
        CMISAccessControlServiceTest.assertFalse((boolean)grandParentReport.isExact());
        CMISAccessControlServiceTest.assertEquals((int)9, (int)grandParentReport.getAccessControlEntries().size());
        parentReport = this.cmisAccessControlService.getAcl(this.parent, CMISAccessControlFormatEnum.CMIS_BASIC_PERMISSIONS);
        CMISAccessControlServiceTest.assertFalse((boolean)parentReport.isExact());
        CMISAccessControlServiceTest.assertEquals((int)10, (int)parentReport.getAccessControlEntries().size());
        childReport = this.cmisAccessControlService.getAcl(this.child, CMISAccessControlFormatEnum.CMIS_BASIC_PERMISSIONS);
        CMISAccessControlServiceTest.assertFalse((boolean)childReport.isExact());
        CMISAccessControlServiceTest.assertEquals((int)11, (int)childReport.getAccessControlEntries().size());
        grandParentReport = this.cmisAccessControlService.getAcl(this.grandParent, CMISAccessControlFormatEnum.REPOSITORY_SPECIFIC_PERMISSIONS);
        CMISAccessControlServiceTest.assertFalse((boolean)grandParentReport.isExact());
        CMISAccessControlServiceTest.assertEquals((int)14, (int)grandParentReport.getAccessControlEntries().size());
        parentReport = this.cmisAccessControlService.getAcl(this.parent, CMISAccessControlFormatEnum.REPOSITORY_SPECIFIC_PERMISSIONS);
        CMISAccessControlServiceTest.assertFalse((boolean)parentReport.isExact());
        CMISAccessControlServiceTest.assertEquals((int)18, (int)parentReport.getAccessControlEntries().size());
        childReport = this.cmisAccessControlService.getAcl(this.child, CMISAccessControlFormatEnum.REPOSITORY_SPECIFIC_PERMISSIONS);
        CMISAccessControlServiceTest.assertFalse((boolean)childReport.isExact());
        CMISAccessControlServiceTest.assertEquals((int)22, (int)childReport.getAccessControlEntries().size());
        acesToAdd = new ArrayList();
        acesToAdd.add(new CMISAccessControlEntryImpl("CMISReader", "cmis:read"));
        acesToAdd.add(new CMISAccessControlEntryImpl("CMISWriter", "cmis:write"));
        acesToAdd.add(new CMISAccessControlEntryImpl("CMISAll", "cmis:all"));
        childReport = this.cmisAccessControlService.applyAcl(this.child, null, acesToAdd, CMISAclPropagationEnum.PROPAGATE, CMISAccessControlFormatEnum.REPOSITORY_SPECIFIC_PERMISSIONS);
        CMISAccessControlServiceTest.assertFalse((boolean)childReport.isExact());
        CMISAccessControlServiceTest.assertEquals((int)30, (int)childReport.getAccessControlEntries().size());
        childReport = this.cmisAccessControlService.applyAcl(this.child, acesToAdd, acesToAdd, CMISAclPropagationEnum.PROPAGATE, CMISAccessControlFormatEnum.REPOSITORY_SPECIFIC_PERMISSIONS);
        CMISAccessControlServiceTest.assertFalse((boolean)childReport.isExact());
        CMISAccessControlServiceTest.assertEquals((int)30, (int)childReport.getAccessControlEntries().size());
        childReport = this.cmisAccessControlService.applyAcl(this.child, acesToAdd, null, CMISAclPropagationEnum.PROPAGATE, CMISAccessControlFormatEnum.REPOSITORY_SPECIFIC_PERMISSIONS);
        CMISAccessControlServiceTest.assertFalse((boolean)childReport.isExact());
        CMISAccessControlServiceTest.assertEquals((int)22, (int)childReport.getAccessControlEntries().size());
        try {
            childReport = this.cmisAccessControlService.applyAcl(this.child, acesToAdd, null, CMISAclPropagationEnum.PROPAGATE, CMISAccessControlFormatEnum.REPOSITORY_SPECIFIC_PERMISSIONS);
            CMISAccessControlServiceTest.fail((String)"A non existent ACE should not be removable");
        }
        catch (CMISConstraintException e) {
            // empty catch block
        }
    }

    public void testAllowableActionsAndPermissionMapping() {
        List<? extends CMISPermissionMapping> mappings = this.cmisAccessControlService.getPermissionMappings();
        CMISAccessControlServiceTest.assertEquals((int)29, (int)mappings.size());
        CMISAccessControlServiceTest.assertTrue((boolean)this.contains(mappings, "canGetDescendents.Folder", "cmis:read", "{http://www.alfresco.org/model/system/1.0}base.ReadChildren"));
        CMISAccessControlServiceTest.assertTrue((boolean)this.contains(mappings, "canGetChildren.Folder", "cmis:read", "{http://www.alfresco.org/model/system/1.0}base.ReadChildren"));
        CMISAccessControlServiceTest.assertTrue((boolean)this.contains(mappings, "canGetParents.Folder", "cmis:read", "{http://www.alfresco.org/model/system/1.0}base.ReadProperties"));
        CMISAccessControlServiceTest.assertTrue((boolean)this.contains(mappings, "canGetFolderParent.Object", "cmis:read", "{http://www.alfresco.org/model/system/1.0}base.ReadProperties"));
        CMISAccessControlServiceTest.assertTrue((boolean)this.contains(mappings, "canCreateDocument.Folder", "cmis:all", "{http://www.alfresco.org/model/system/1.0}base.CreateChildren"));
        CMISAccessControlServiceTest.assertTrue((boolean)this.contains(mappings, "canCreateFolder.Folder", "cmis:all", "{http://www.alfresco.org/model/system/1.0}base.CreateChildren"));
        CMISAccessControlServiceTest.assertTrue((boolean)this.contains(mappings, "canGetProperties.Object", "cmis:read", "{http://www.alfresco.org/model/system/1.0}base.ReadProperties"));
        CMISAccessControlServiceTest.assertTrue((boolean)this.contains(mappings, "canViewContent.Object", "cmis:read", "{http://www.alfresco.org/model/system/1.0}base.ReadContent"));
        CMISAccessControlServiceTest.assertTrue((boolean)this.contains(mappings, "canUpdateProperties.Object", "cmis:write", "{http://www.alfresco.org/model/system/1.0}base.WriteProperties"));
        CMISAccessControlServiceTest.assertTrue((boolean)this.contains(mappings, "canMove.Object", "cmis:all", "{http://www.alfresco.org/model/system/1.0}base.DeleteNode"));
        CMISAccessControlServiceTest.assertTrue((boolean)this.contains(mappings, "canMove.Target", "cmis:all", "{http://www.alfresco.org/model/system/1.0}base.CreateChildren"));
        CMISAccessControlServiceTest.assertTrue((boolean)this.contains(mappings, "canDelete.Object", "cmis:all", "{http://www.alfresco.org/model/system/1.0}base.DeleteNode"));
        CMISAccessControlServiceTest.assertTrue((boolean)this.contains(mappings, "canSetContent.Document", "cmis:write", "{http://www.alfresco.org/model/system/1.0}base.WriteContent"));
        CMISAccessControlServiceTest.assertTrue((boolean)this.contains(mappings, "canDeleteContent.Document", "cmis:write", "{http://www.alfresco.org/model/system/1.0}base.WriteContent"));
        CMISAccessControlServiceTest.assertTrue((boolean)this.contains(mappings, "canDeleteTree.Folder", "cmis:all", "{http://www.alfresco.org/model/system/1.0}base.DeleteNode"));
        CMISAccessControlServiceTest.assertTrue((boolean)this.contains(mappings, "canAddToFolder.Object", "cmis:read", "{http://www.alfresco.org/model/system/1.0}base.ReadProperties"));
        CMISAccessControlServiceTest.assertTrue((boolean)this.contains(mappings, "canAddToFolder.Folder", "cmis:all", "{http://www.alfresco.org/model/system/1.0}base.CreateChildren"));
        CMISAccessControlServiceTest.assertTrue((boolean)this.contains(mappings, "canRemoveFromFolder.Object", "cmis:all", "{http://www.alfresco.org/model/system/1.0}base.DeleteNode"));
        CMISAccessControlServiceTest.assertTrue((boolean)this.contains(mappings, "canCheckout.Document", "cmis:all", "{http://www.alfresco.org/model/content/1.0}lockable.CheckOut"));
        CMISAccessControlServiceTest.assertTrue((boolean)this.contains(mappings, "canCancelCheckout.Document", "cmis:all", "{http://www.alfresco.org/model/content/1.0}lockable.CancelCheckOut"));
        CMISAccessControlServiceTest.assertTrue((boolean)this.contains(mappings, "canCheckin.Document", "cmis:all", "{http://www.alfresco.org/model/content/1.0}lockable.CheckIn"));
        CMISAccessControlServiceTest.assertTrue((boolean)this.contains(mappings, "canGetAllVersions.VersionSeries", "cmis:read", "{http://www.alfresco.org/model/system/1.0}base.Read"));
        CMISAccessControlServiceTest.assertTrue((boolean)this.contains(mappings, "canAddPolicy.Object", "cmis:write", "{http://www.alfresco.org/model/system/1.0}base.Write"));
        CMISAccessControlServiceTest.assertTrue((boolean)this.contains(mappings, "canAddPolicy.Policy", "cmis:read"));
        CMISAccessControlServiceTest.assertTrue((boolean)this.contains(mappings, "canRemovePolicy.Object", "cmis:write", "{http://www.alfresco.org/model/system/1.0}base.Write"));
        CMISAccessControlServiceTest.assertTrue((boolean)this.contains(mappings, "canRemovePolicy.Policy", "cmis:read"));
        CMISAccessControlServiceTest.assertTrue((boolean)this.contains(mappings, "canGetAppliedPolicies.Object", "cmis:read", "{http://www.alfresco.org/model/system/1.0}base.ReadProperties"));
        CMISAccessControlServiceTest.assertTrue((boolean)this.contains(mappings, "canGetACL.Object", "cmis:all", "{http://www.alfresco.org/model/system/1.0}base.ReadPermissions"));
        CMISAccessControlServiceTest.assertTrue((boolean)this.contains(mappings, "canApplyACL.Object", "cmis:all", "{http://www.alfresco.org/model/system/1.0}base.ChangePermissions"));
    }

    private boolean contains(List<? extends CMISPermissionMapping> mappings, String key, String ... entries) {
        for (CMISPermissionMapping cMISPermissionMapping : mappings) {
            if (!cMISPermissionMapping.getKey().equals(key)) continue;
            Set<String> permissionNames = this.getAllPermissions();
            for (String permission : cMISPermissionMapping.getPermissions()) {
                if (permissionNames.contains(permission)) continue;
                return false;
            }
            if (entries.length > 0) {
                if (cMISPermissionMapping.getPermissions().size() != entries.length) continue;
                for (String entry : entries) {
                    if (cMISPermissionMapping.getPermissions().contains(entry)) continue;
                    return false;
                }
                return true;
            }
            return true;
        }
        return false;
    }
}

