/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.cmis.mapping;

import java.io.Serializable;
import org.alfresco.cmis.mapping.AbstractVersioningProperty;
import org.alfresco.model.ContentModel;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.version.Version;
import org.alfresco.service.cmr.version.VersionHistory;
import org.alfresco.service.cmr.version.VersionService;
import org.alfresco.service.cmr.version.VersionType;

public class IsLatestMajorVersionProperty
extends AbstractVersioningProperty {
    public IsLatestMajorVersionProperty(ServiceRegistry serviceRegistry) {
        super(serviceRegistry, "cmis:isLatestMajorVersion");
    }

    @Override
    public Serializable getValue(NodeRef nodeRef) {
        if (this.isWorkingCopy(nodeRef)) {
            return Boolean.valueOf(false);
        }
        NodeRef versionSeries = this.getVersionSeries(nodeRef);
        ServiceRegistry serviceRegistry = this.getServiceRegistry();
        VersionService versionService = serviceRegistry.getVersionService();
        VersionHistory versionHistory = versionService.getVersionHistory(versionSeries);
        if (versionHistory == null) {
            return Boolean.valueOf(false);
        }
        NodeRef versionNodeRef = nodeRef;
        if (!nodeRef.getStoreRef().getProtocol().equals("versionStore")) {
            String versionLabel = (String)((Object)serviceRegistry.getNodeService().getProperty(nodeRef, ContentModel.PROP_VERSION_LABEL));
            if (versionLabel == null) {
                return Boolean.valueOf(false);
            }
            Version version = versionHistory.getVersion(versionLabel);
            if (version == null) {
                return Boolean.valueOf(false);
            }
            versionNodeRef = version.getFrozenStateNodeRef();
        }
        Version currentVersion = versionService.getCurrentVersion(versionSeries);
        while (currentVersion != null) {
            if (currentVersion.getVersionType() == VersionType.MAJOR) {
                return Boolean.valueOf(currentVersion.getFrozenStateNodeRef().equals((Object)versionNodeRef));
            }
            if (currentVersion.getFrozenStateNodeRef().equals((Object)versionNodeRef)) {
                return Boolean.valueOf(false);
            }
            currentVersion = versionHistory.getPredecessor(currentVersion);
        }
        return Boolean.valueOf(false);
    }
}

