/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jcr.session;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.AccessControlException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.AccessDeniedException;
import javax.jcr.Credentials;
import javax.jcr.InvalidItemStateException;
import javax.jcr.InvalidSerializedDataException;
import javax.jcr.Item;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.LoginException;
import javax.jcr.NamespaceException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.ValueFactory;
import javax.jcr.Workspace;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.version.VersionException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.jcr.dictionary.JCRNamespacePrefixResolver;
import org.alfresco.jcr.dictionary.NamespaceRegistryImpl;
import org.alfresco.jcr.dictionary.NodeTypeManagerImpl;
import org.alfresco.jcr.exporter.JCRDocumentXMLExporter;
import org.alfresco.jcr.exporter.JCRSystemXMLExporter;
import org.alfresco.jcr.importer.JCRImportHandler;
import org.alfresco.jcr.item.ItemImpl;
import org.alfresco.jcr.item.ItemResolver;
import org.alfresco.jcr.item.JCRPath;
import org.alfresco.jcr.item.JCRTypeConverter;
import org.alfresco.jcr.item.NodeImpl;
import org.alfresco.jcr.item.ValueFactoryImpl;
import org.alfresco.jcr.repository.RepositoryImpl;
import org.alfresco.jcr.session.WorkspaceImpl;
import org.alfresco.jcr.util.JCRProxyFactory;
import org.alfresco.repo.importer.ImporterComponent;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.service.cmr.lock.LockService;
import org.alfresco.service.cmr.lock.LockType;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.view.ExporterCrawlerParameters;
import org.alfresco.service.cmr.view.ExporterService;
import org.alfresco.service.cmr.view.ImporterBinding;
import org.alfresco.service.cmr.view.ImporterException;
import org.alfresco.service.cmr.view.Location;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.springframework.extensions.surf.util.ParameterCheck;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class SessionImpl
implements Session {
    private RepositoryImpl repository;
    private String trxId;
    private Map<String, Object> attributes;
    private StoreRef workspaceStore;
    private WorkspaceImpl workspace = null;
    private JCRTypeConverter typeConverter = null;
    private NamespaceRegistryImpl namespaceResolver;
    private NodeTypeManagerImpl typeManager = null;
    private ValueFactoryImpl valueFactory = null;
    private Session proxy = null;
    private SessionIsolation sessionIsolation = null;
    private String ticket = null;

    public SessionImpl(RepositoryImpl repository) {
        this.repository = repository;
        this.typeConverter = new JCRTypeConverter(this);
        this.namespaceResolver = new NamespaceRegistryImpl(true, new JCRNamespacePrefixResolver((NamespacePrefixResolver)repository.getServiceRegistry().getNamespaceService()));
        this.typeManager = new NodeTypeManagerImpl(this, this.namespaceResolver.getNamespaceService());
        this.valueFactory = new ValueFactoryImpl(this);
    }

    public void init(String ticket, String workspaceName, Map<String, Object> attributes) throws RepositoryException {
        String trxId = AlfrescoTransactionSupport.getTransactionId();
        this.sessionIsolation = trxId == null ? new InnerTransaction() : new OuterTransaction();
        this.sessionIsolation.begin();
        this.ticket = ticket;
        this.attributes = attributes == null ? new HashMap() : attributes;
        this.workspaceStore = this.getWorkspaceStore(workspaceName);
    }

    public Session getProxy() {
        if (this.proxy == null) {
            this.proxy = (Session)JCRProxyFactory.create(this, Session.class, this);
        }
        return this.proxy;
    }

    public RepositoryImpl getRepositoryImpl() {
        return this.repository;
    }

    public String getTicket() {
        return this.ticket;
    }

    public String getTransactionId() {
        return this.trxId;
    }

    public JCRTypeConverter getTypeConverter() {
        return this.typeConverter;
    }

    public NodeTypeManagerImpl getTypeManager() {
        return this.typeManager;
    }

    public NamespacePrefixResolver getNamespaceResolver() {
        return this.namespaceResolver.getNamespaceService();
    }

    public StoreRef getWorkspaceStore() {
        return this.workspaceStore;
    }

    public Repository getRepository() {
        return this.repository;
    }

    public String getUserID() {
        return this.getRepositoryImpl().getServiceRegistry().getAuthenticationService().getCurrentUserName();
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public String[] getAttributeNames() {
        String[] names = this.attributes.keySet().toArray(new String[this.attributes.keySet().size()]);
        return names;
    }

    public Workspace getWorkspace() {
        if (this.workspace == null) {
            this.workspace = new WorkspaceImpl(this);
        }
        return this.workspace.getProxy();
    }

    public Session impersonate(Credentials credentials) throws LoginException, RepositoryException {
        throw new LoginException("Insufficient permission to impersonate");
    }

    public Node getRootNode() throws RepositoryException {
        NodeRef nodeRef = this.getRepositoryImpl().getServiceRegistry().getNodeService().getRootNode(this.workspaceStore);
        NodeImpl nodeImpl = new NodeImpl(this, nodeRef);
        return nodeImpl.getProxy();
    }

    public Node getNodeByUUID(String uuid) throws ItemNotFoundException, RepositoryException {
        NodeRef nodeRef = new NodeRef(this.workspaceStore, uuid);
        boolean exists = this.getRepositoryImpl().getServiceRegistry().getNodeService().exists(nodeRef);
        if (!exists) {
            throw new ItemNotFoundException();
        }
        NodeImpl nodeImpl = new NodeImpl(this, nodeRef);
        return nodeImpl.getProxy();
    }

    public Item getItem(String absPath) throws PathNotFoundException, RepositoryException {
        NodeRef nodeRef = this.getRepositoryImpl().getServiceRegistry().getNodeService().getRootNode(this.workspaceStore);
        ItemImpl itemImpl = ItemResolver.findItem(this, nodeRef, absPath);
        return itemImpl.getProxy();
    }

    public boolean itemExists(String absPath) throws RepositoryException {
        ParameterCheck.mandatoryString((String)"absPath", (String)absPath);
        NodeRef nodeRef = this.getRepositoryImpl().getServiceRegistry().getNodeService().getRootNode(this.workspaceStore);
        return ItemResolver.itemExists(this, nodeRef, absPath);
    }

    public void move(String srcAbsPath, String destAbsPath) throws ItemExistsException, PathNotFoundException, VersionException, ConstraintViolationException, LockException, RepositoryException {
        ParameterCheck.mandatoryString((String)"srcAbsPath", (String)srcAbsPath);
        ParameterCheck.mandatoryString((String)"destAbsPath", (String)destAbsPath);
        NodeService nodeService = this.getRepositoryImpl().getServiceRegistry().getNodeService();
        NodeRef rootRef = nodeService.getRootNode(this.workspaceStore);
        NodeRef sourceRef = ItemResolver.getNodeRef(this, rootRef, srcAbsPath);
        if (sourceRef == null) {
            throw new PathNotFoundException("Source path " + srcAbsPath + " cannot be found.");
        }
        NodeRef destRef = null;
        QName destName = null;
        Path destPath = new JCRPath(this.getNamespaceResolver(), destAbsPath).getPath();
        if (destPath.size() == 1) {
            destRef = rootRef;
            destName = ((JCRPath.SimpleElement)destPath.get(0)).getQName();
        } else {
            Path destParentPath = destPath.subPath(destPath.size() - 2);
            destRef = ItemResolver.getNodeRef(this, rootRef, destParentPath.toPrefixString(this.getNamespaceResolver()));
            if (destRef == null) {
                throw new PathNotFoundException("Destination path " + destParentPath + " cannot be found.");
            }
            destName = ((JCRPath.SimpleElement)destPath.get(destPath.size() - 1)).getQName();
        }
        if (destName.getLocalName().indexOf(91) != -1 || destName.getLocalName().indexOf(93) != -1) {
            throw new RepositoryException("Node name '" + destName + "' is invalid");
        }
        ChildAssociationRef childAssocRef = nodeService.getPrimaryParent(sourceRef);
        nodeService.moveNode(sourceRef, destRef, childAssocRef.getTypeQName(), destName);
    }

    public void save() throws AccessDeniedException, ItemExistsException, ConstraintViolationException, InvalidItemStateException, VersionException, LockException, NoSuchNodeTypeException, RepositoryException {
        this.sessionIsolation.commit();
        this.sessionIsolation.begin();
    }

    public void refresh(boolean keepChanges) throws RepositoryException {
        if (keepChanges) {
            throw new UnsupportedRepositoryOperationException("Keep changes is not supported.");
        }
        this.sessionIsolation.rollback();
        this.sessionIsolation.begin();
    }

    public boolean hasPendingChanges() throws RepositoryException {
        return AlfrescoTransactionSupport.isDirty();
    }

    public ValueFactory getValueFactory() throws UnsupportedRepositoryOperationException, RepositoryException {
        return this.valueFactory.getProxy();
    }

    public void checkPermission(String absPath, String actions) throws AccessControlException, RepositoryException {
        String[] checkActions;
        NodeService nodeService = this.getRepositoryImpl().getServiceRegistry().getNodeService();
        NodeRef rootRef = nodeService.getRootNode(this.getWorkspaceStore());
        NodeRef nodeRef = ItemResolver.getNodeRef(this, rootRef, absPath);
        if (nodeRef == null) {
            throw new AccessControlException("Unable to determine access control for path " + absPath);
        }
        PermissionService permissionService = this.getRepositoryImpl().getServiceRegistry().getPermissionService();
        for (String checkAction : checkActions = actions.split(",")) {
            checkAction = checkAction.trim();
            AccessStatus accessStatus = null;
            accessStatus = checkAction.equals("add_node") ? permissionService.hasPermission(nodeRef, "AddChildren") : (checkAction.equals("set_property") ? permissionService.hasPermission(nodeRef, "WriteProperties") : (checkAction.equals("remove") ? permissionService.hasPermission(nodeRef, "Delete") : (checkAction.equals("read") ? permissionService.hasPermission(nodeRef, "Read") : permissionService.hasPermission(nodeRef, checkAction))));
            if (accessStatus != AccessStatus.DENIED) continue;
            throw new AccessControlException("Permission " + checkAction + " not granted on path " + absPath);
        }
    }

    public ContentHandler getImportContentHandler(String parentAbsPath, int uuidBehavior) throws PathNotFoundException, ConstraintViolationException, VersionException, LockException, RepositoryException {
        NodeService nodeService = this.getRepositoryImpl().getServiceRegistry().getNodeService();
        NodeRef rootRef = nodeService.getRootNode(this.getWorkspaceStore());
        NodeRef nodeRef = ItemResolver.getNodeRef(this, rootRef, parentAbsPath);
        if (nodeRef == null) {
            throw new PathNotFoundException("Parent path " + parentAbsPath + " does not exist.");
        }
        JCRImportHandler jcrImportHandler = new JCRImportHandler(this);
        ImporterComponent importerComponent = this.getRepositoryImpl().getImporterComponent();
        return importerComponent.handlerImport(nodeRef, null, jcrImportHandler, new JCRImportBinding(uuidBehavior), null);
    }

    public void importXML(String parentAbsPath, InputStream in, int uuidBehavior) throws IOException, PathNotFoundException, ItemExistsException, ConstraintViolationException, VersionException, InvalidSerializedDataException, LockException, RepositoryException {
        ContentHandler handler = this.getImportContentHandler(parentAbsPath, uuidBehavior);
        try {
            XMLReader parser = XMLReaderFactory.createXMLReader();
            parser.setContentHandler(handler);
            parser.setFeature("http://xml.org/sax/features/namespaces", true);
            parser.setFeature("http://xml.org/sax/features/namespace-prefixes", false);
            parser.parse(new InputSource(in));
        }
        catch (SAXException se) {
            Exception e = se.getException();
            if (e != null && e instanceof AlfrescoRuntimeException) {
                throw (AlfrescoRuntimeException)((Object)e);
            }
            throw new InvalidSerializedDataException("Failed to import provided xml stream", (Throwable)se);
        }
    }

    public void exportSystemView(String absPath, ContentHandler contentHandler, boolean skipBinary, boolean noRecurse) throws PathNotFoundException, SAXException, RepositoryException {
        JCRSystemXMLExporter exporter = new JCRSystemXMLExporter(this, contentHandler);
        ExporterCrawlerParameters parameters = this.createExportParameters(absPath, skipBinary, noRecurse);
        ExporterService exporterService = this.getRepositoryImpl().getServiceRegistry().getExporterService();
        exporterService.exportView(exporter, parameters, null);
    }

    public void exportSystemView(String absPath, OutputStream out, boolean skipBinary, boolean noRecurse) throws IOException, PathNotFoundException, RepositoryException {
        JCRSystemXMLExporter exporter = new JCRSystemXMLExporter(this, this.createExportContentHandler(out));
        ExporterCrawlerParameters parameters = this.createExportParameters(absPath, skipBinary, noRecurse);
        ExporterService exporterService = this.getRepositoryImpl().getServiceRegistry().getExporterService();
        exporterService.exportView(exporter, parameters, null);
    }

    public void exportDocumentView(String absPath, ContentHandler contentHandler, boolean skipBinary, boolean noRecurse) throws PathNotFoundException, SAXException, RepositoryException {
        JCRDocumentXMLExporter exporter = new JCRDocumentXMLExporter(this, contentHandler);
        ExporterCrawlerParameters parameters = this.createExportParameters(absPath, skipBinary, noRecurse);
        ExporterService exporterService = this.getRepositoryImpl().getServiceRegistry().getExporterService();
        exporterService.exportView(exporter, parameters, null);
    }

    public void exportDocumentView(String absPath, OutputStream out, boolean skipBinary, boolean noRecurse) throws IOException, PathNotFoundException, RepositoryException {
        JCRDocumentXMLExporter exporter = new JCRDocumentXMLExporter(this, this.createExportContentHandler(out));
        ExporterCrawlerParameters parameters = this.createExportParameters(absPath, skipBinary, noRecurse);
        ExporterService exporterService = this.getRepositoryImpl().getServiceRegistry().getExporterService();
        exporterService.exportView(exporter, parameters, null);
    }

    public void setNamespacePrefix(String prefix, String uri) throws NamespaceException, RepositoryException {
        this.namespaceResolver.registerNamespace(prefix, uri);
    }

    public String[] getNamespacePrefixes() throws RepositoryException {
        return this.namespaceResolver.getPrefixes();
    }

    public String getNamespaceURI(String prefix) throws NamespaceException, RepositoryException {
        return this.namespaceResolver.getURI(prefix);
    }

    public String getNamespacePrefix(String uri) throws NamespaceException, RepositoryException {
        return this.namespaceResolver.getPrefix(uri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logout() {
        if (this.isLive()) {
            try {
                try {
                    this.getRepositoryImpl().getServiceRegistry().getAuthenticationService().invalidateTicket(this.getTicket());
                }
                finally {
                    try {
                        this.sessionIsolation.rollback();
                    }
                    catch (RepositoryException repositoryException) {}
                }
            }
            finally {
                this.ticket = null;
                this.repository.deregisterSession();
            }
        }
    }

    public boolean isLive() {
        return this.ticket != null;
    }

    public void addLockToken(String lt) {
    }

    public String[] getLockTokens() {
        LockService lockService = this.getRepositoryImpl().getServiceRegistry().getLockService();
        List<NodeRef> nodeRefs = lockService.getLocks(this.getWorkspaceStore(), LockType.WRITE_LOCK);
        String[] tokens = new String[nodeRefs.size()];
        int i = 0;
        for (NodeRef nodeRef : nodeRefs) {
            tokens[i++] = nodeRef.toString();
        }
        return tokens;
    }

    public void removeLockToken(String lt) {
    }

    private StoreRef getWorkspaceStore(String workspaceName) throws NoSuchWorkspaceException {
        if (workspaceName == null) {
            throw new NoSuchWorkspaceException("A default workspace could not be established.");
        }
        StoreRef workspace = new StoreRef("workspace", workspaceName);
        NodeService nodeService = this.getRepositoryImpl().getServiceRegistry().getNodeService();
        boolean exists = false;
        try {
            exists = nodeService.exists(workspace);
        }
        catch (org.alfresco.repo.security.permissions.AccessDeniedException e) {
            // empty catch block
        }
        if (!exists) {
            throw new NoSuchWorkspaceException("Workspace " + workspaceName + " does not exist.");
        }
        return workspace;
    }

    private ContentHandler createExportContentHandler(OutputStream output) throws RepositoryException {
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setNewLineAfterDeclaration(false);
        format.setIndentSize(2);
        format.setEncoding("UTF-8");
        try {
            return new XMLWriter(output, format);
        }
        catch (UnsupportedEncodingException e) {
            throw new RepositoryException("Failed to create content handler for export", (Throwable)e);
        }
    }

    private ExporterCrawlerParameters createExportParameters(String exportPath, boolean skipBinary, boolean noRecurse) {
        ExporterCrawlerParameters parameters = new ExporterCrawlerParameters();
        Location exportFrom = new Location(this.getWorkspaceStore());
        exportFrom.setPath(exportPath);
        parameters.setExportFrom(exportFrom);
        parameters.setCrawlSelf(true);
        parameters.setCrawlContent(!skipBinary);
        parameters.setCrawlChildNodes(!noRecurse);
        parameters.setCrawlNullProperties(false);
        return parameters;
    }

    private class InnerTransaction
    implements SessionIsolation {
        private UserTransaction userTransaction = null;

        private InnerTransaction() {
        }

        @Override
        public void begin() throws RepositoryException {
            try {
                UserTransaction trx = SessionImpl.this.repository.getServiceRegistry().getTransactionService().getUserTransaction();
                trx.begin();
                this.userTransaction = trx;
            }
            catch (NotSupportedException e) {
                throw new RepositoryException("Failed to start Repository transaction", (Throwable)e);
            }
            catch (SystemException e) {
                throw new RepositoryException("Failed to start Repository transaction", (Throwable)e);
            }
        }

        @Override
        public void commit() throws RepositoryException {
            try {
                this.userTransaction.commit();
            }
            catch (HeuristicRollbackException e) {
                throw new RepositoryException("Failed to commit Repository transaction", (Throwable)e);
            }
            catch (HeuristicMixedException e) {
                throw new RepositoryException("Failed to commit Repository transaction", (Throwable)e);
            }
            catch (RollbackException e) {
                throw new RepositoryException("Failed to commit Repository transaction", (Throwable)e);
            }
            catch (SystemException e) {
                throw new RepositoryException("Failed to commit Repository transaction", (Throwable)e);
            }
        }

        @Override
        public void rollback() throws RepositoryException {
            try {
                this.userTransaction.rollback();
            }
            catch (SystemException e) {
                throw new RepositoryException("Failed to rollback Repository transaction", (Throwable)e);
            }
        }
    }

    private class OuterTransaction
    implements SessionIsolation {
        private OuterTransaction() {
        }

        @Override
        public void begin() throws RepositoryException {
        }

        @Override
        public void commit() throws RepositoryException {
        }

        @Override
        public void rollback() throws RepositoryException {
        }
    }

    private static interface SessionIsolation {
        public void begin() throws RepositoryException;

        public void commit() throws RepositoryException;

        public void rollback() throws RepositoryException;
    }

    private class JCRImportBinding
    implements ImporterBinding {
        private ImporterBinding.UUID_BINDING uuidBinding;

        private JCRImportBinding(int uuidBehaviour) {
            switch (uuidBehaviour) {
                case 0: {
                    this.uuidBinding = ImporterBinding.UUID_BINDING.CREATE_NEW;
                    break;
                }
                case 1: {
                    this.uuidBinding = ImporterBinding.UUID_BINDING.REMOVE_EXISTING;
                    break;
                }
                case 2: {
                    this.uuidBinding = ImporterBinding.UUID_BINDING.REPLACE_EXISTING;
                    break;
                }
                case 3: {
                    this.uuidBinding = ImporterBinding.UUID_BINDING.THROW_ON_COLLISION;
                    break;
                }
                default: {
                    throw new ImporterException("Unknown Import UUID Behaviour: " + uuidBehaviour);
                }
            }
        }

        @Override
        public ImporterBinding.UUID_BINDING getUUIDBinding() {
            return this.uuidBinding;
        }

        @Override
        public String getValue(String key) {
            return null;
        }

        @Override
        public boolean allowReferenceWithinTransaction() {
            return false;
        }

        @Override
        public QName[] getExcludedClasses() {
            return null;
        }
    }
}

