/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.action.executer;

import java.io.Serializable;
import junit.framework.Assert;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.action.ActionImpl;
import org.alfresco.repo.action.executer.ExecuteAllRulesActionExecuter;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ActionService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.rule.Rule;
import org.alfresco.service.cmr.rule.RuleService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.BaseSpringTest;
import org.alfresco.util.GUID;

public class ExecuteAllRulesActionExecuterTest
extends BaseSpringTest {
    private NodeService nodeService;
    private RuleService ruleService;
    private ActionService actionService;
    private RetryingTransactionHelper transactionHelper;
    private StoreRef testStoreRef;
    private NodeRef rootNodeRef;
    private ExecuteAllRulesActionExecuter executer;
    private static final String ID = GUID.generate();

    protected void onSetUpInTransaction() throws Exception {
        this.nodeService = (NodeService)this.applicationContext.getBean("nodeService");
        this.ruleService = (RuleService)this.applicationContext.getBean("ruleService");
        this.actionService = (ActionService)this.applicationContext.getBean("actionService");
        this.transactionHelper = (RetryingTransactionHelper)this.applicationContext.getBean("retryingTransactionHelper");
        AuthenticationComponent authenticationComponent = (AuthenticationComponent)this.applicationContext.getBean("authenticationComponent");
        authenticationComponent.setCurrentUser(authenticationComponent.getSystemUserName());
        this.testStoreRef = this.nodeService.createStore("workspace", "Test_" + System.currentTimeMillis());
        this.rootNodeRef = this.nodeService.getRootNode(this.testStoreRef);
        this.executer = (ExecuteAllRulesActionExecuter)this.applicationContext.getBean("execute-all-rules");
    }

    public void testExecution() {
        final NodeRef folder = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}folderOne"), ContentModel.TYPE_FOLDER).getChildRef();
        final NodeRef doc1 = this.nodeService.createNode(folder, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"{test}docOne"), ContentModel.TYPE_CONTENT).getChildRef();
        final NodeRef doc2 = this.nodeService.createNode(folder, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"{test}docTwo"), ContentModel.TYPE_CONTENT).getChildRef();
        NodeRef folder2 = this.nodeService.createNode(folder, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"{test}folderTwo"), ContentModel.TYPE_FOLDER).getChildRef();
        final NodeRef doc3 = this.nodeService.createNode(folder2, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"{test}docThree"), ContentModel.TYPE_CONTENT).getChildRef();
        Rule rule1 = new Rule();
        rule1.setRuleType("inbound");
        Action action1 = this.actionService.createAction("add-features");
        action1.setParameterValue("aspect-name", (Serializable)ContentModel.ASPECT_VERSIONABLE);
        rule1.setAction(action1);
        this.ruleService.saveRule(folder, rule1);
        Rule rule2 = new Rule();
        rule2.setRuleType("inbound");
        Action action2 = this.actionService.createAction("add-features");
        action2.setParameterValue("aspect-name", (Serializable)ContentModel.ASPECT_CLASSIFIABLE);
        rule2.setAction(action2);
        this.ruleService.saveRule(folder, rule2);
        Rule rule3 = new Rule();
        rule3.setRuleType("inbound");
        Action action3 = this.actionService.createAction("add-features");
        action3.setParameterValue("aspect-name", (Serializable)ContentModel.ASPECT_TITLED);
        rule3.setAction(action3);
        this.ruleService.saveRule(folder2, rule3);
        ExecuteAllRulesActionExecuterTest.assertFalse((boolean)this.nodeService.hasAspect(doc1, ContentModel.ASPECT_VERSIONABLE));
        ExecuteAllRulesActionExecuterTest.assertFalse((boolean)this.nodeService.hasAspect(doc1, ContentModel.ASPECT_CLASSIFIABLE));
        ExecuteAllRulesActionExecuterTest.assertFalse((boolean)this.nodeService.hasAspect(doc1, ContentModel.ASPECT_TITLED));
        ExecuteAllRulesActionExecuterTest.assertFalse((boolean)this.nodeService.hasAspect(doc2, ContentModel.ASPECT_VERSIONABLE));
        ExecuteAllRulesActionExecuterTest.assertFalse((boolean)this.nodeService.hasAspect(doc2, ContentModel.ASPECT_CLASSIFIABLE));
        ExecuteAllRulesActionExecuterTest.assertFalse((boolean)this.nodeService.hasAspect(doc2, ContentModel.ASPECT_TITLED));
        ExecuteAllRulesActionExecuterTest.assertFalse((boolean)this.nodeService.hasAspect(doc3, ContentModel.ASPECT_VERSIONABLE));
        ExecuteAllRulesActionExecuterTest.assertFalse((boolean)this.nodeService.hasAspect(doc3, ContentModel.ASPECT_CLASSIFIABLE));
        ExecuteAllRulesActionExecuterTest.assertFalse((boolean)this.nodeService.hasAspect(doc3, ContentModel.ASPECT_TITLED));
        ExecuteAllRulesActionExecuterTest.assertTrue((boolean)this.nodeService.exists(folder));
        ActionImpl action = new ActionImpl(null, ID, "execute-all-rules", null);
        this.executer.execute(action, folder);
        this.setComplete();
        this.endTransaction();
        this.transactionHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() throws Throwable {
                Assert.assertTrue((boolean)ExecuteAllRulesActionExecuterTest.this.nodeService.hasAspect(doc1, ContentModel.ASPECT_VERSIONABLE));
                Assert.assertTrue((boolean)ExecuteAllRulesActionExecuterTest.this.nodeService.hasAspect(doc1, ContentModel.ASPECT_CLASSIFIABLE));
                Assert.assertFalse((boolean)ExecuteAllRulesActionExecuterTest.this.nodeService.hasAspect(doc2, ContentModel.ASPECT_TITLED));
                Assert.assertTrue((boolean)ExecuteAllRulesActionExecuterTest.this.nodeService.hasAspect(doc2, ContentModel.ASPECT_VERSIONABLE));
                Assert.assertTrue((boolean)ExecuteAllRulesActionExecuterTest.this.nodeService.hasAspect(doc2, ContentModel.ASPECT_CLASSIFIABLE));
                Assert.assertFalse((boolean)ExecuteAllRulesActionExecuterTest.this.nodeService.hasAspect(doc2, ContentModel.ASPECT_TITLED));
                Assert.assertFalse((boolean)ExecuteAllRulesActionExecuterTest.this.nodeService.hasAspect(doc3, ContentModel.ASPECT_VERSIONABLE));
                Assert.assertFalse((boolean)ExecuteAllRulesActionExecuterTest.this.nodeService.hasAspect(doc3, ContentModel.ASPECT_CLASSIFIABLE));
                Assert.assertFalse((boolean)ExecuteAllRulesActionExecuterTest.this.nodeService.hasAspect(doc3, ContentModel.ASPECT_TITLED));
                ExecuteAllRulesActionExecuterTest.this.clearAspects(doc1);
                ExecuteAllRulesActionExecuterTest.this.clearAspects(doc2);
                ExecuteAllRulesActionExecuterTest.this.clearAspects(doc3);
                return null;
            }
        });
        this.transactionHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() throws Throwable {
                Assert.assertFalse((boolean)ExecuteAllRulesActionExecuterTest.this.nodeService.hasAspect(doc1, ContentModel.ASPECT_VERSIONABLE));
                Assert.assertFalse((boolean)ExecuteAllRulesActionExecuterTest.this.nodeService.hasAspect(doc1, ContentModel.ASPECT_CLASSIFIABLE));
                Assert.assertFalse((boolean)ExecuteAllRulesActionExecuterTest.this.nodeService.hasAspect(doc1, ContentModel.ASPECT_TITLED));
                Assert.assertFalse((boolean)ExecuteAllRulesActionExecuterTest.this.nodeService.hasAspect(doc2, ContentModel.ASPECT_VERSIONABLE));
                Assert.assertFalse((boolean)ExecuteAllRulesActionExecuterTest.this.nodeService.hasAspect(doc2, ContentModel.ASPECT_CLASSIFIABLE));
                Assert.assertFalse((boolean)ExecuteAllRulesActionExecuterTest.this.nodeService.hasAspect(doc2, ContentModel.ASPECT_TITLED));
                Assert.assertFalse((boolean)ExecuteAllRulesActionExecuterTest.this.nodeService.hasAspect(doc3, ContentModel.ASPECT_VERSIONABLE));
                Assert.assertFalse((boolean)ExecuteAllRulesActionExecuterTest.this.nodeService.hasAspect(doc3, ContentModel.ASPECT_CLASSIFIABLE));
                Assert.assertFalse((boolean)ExecuteAllRulesActionExecuterTest.this.nodeService.hasAspect(doc3, ContentModel.ASPECT_TITLED));
                ActionImpl action = new ActionImpl(null, ID, "execute-all-rules", null);
                action.setParameterValue("run-all-rules-on-children", Boolean.TRUE);
                ExecuteAllRulesActionExecuterTest.this.executer.execute(action, folder);
                return null;
            }
        });
        this.transactionHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() throws Throwable {
                Assert.assertTrue((boolean)ExecuteAllRulesActionExecuterTest.this.nodeService.hasAspect(doc1, ContentModel.ASPECT_VERSIONABLE));
                Assert.assertTrue((boolean)ExecuteAllRulesActionExecuterTest.this.nodeService.hasAspect(doc1, ContentModel.ASPECT_CLASSIFIABLE));
                Assert.assertFalse((boolean)ExecuteAllRulesActionExecuterTest.this.nodeService.hasAspect(doc2, ContentModel.ASPECT_TITLED));
                Assert.assertTrue((boolean)ExecuteAllRulesActionExecuterTest.this.nodeService.hasAspect(doc2, ContentModel.ASPECT_VERSIONABLE));
                Assert.assertTrue((boolean)ExecuteAllRulesActionExecuterTest.this.nodeService.hasAspect(doc2, ContentModel.ASPECT_CLASSIFIABLE));
                Assert.assertFalse((boolean)ExecuteAllRulesActionExecuterTest.this.nodeService.hasAspect(doc2, ContentModel.ASPECT_TITLED));
                Assert.assertFalse((boolean)ExecuteAllRulesActionExecuterTest.this.nodeService.hasAspect(doc3, ContentModel.ASPECT_VERSIONABLE));
                Assert.assertFalse((boolean)ExecuteAllRulesActionExecuterTest.this.nodeService.hasAspect(doc3, ContentModel.ASPECT_CLASSIFIABLE));
                Assert.assertTrue((boolean)ExecuteAllRulesActionExecuterTest.this.nodeService.hasAspect(doc3, ContentModel.ASPECT_TITLED));
                ExecuteAllRulesActionExecuterTest.this.clearAspects(doc1);
                ExecuteAllRulesActionExecuterTest.this.clearAspects(doc2);
                ExecuteAllRulesActionExecuterTest.this.clearAspects(doc3);
                return null;
            }
        });
    }

    private void clearAspects(NodeRef nodeRef) {
        this.nodeService.removeAspect(nodeRef, ContentModel.ASPECT_VERSIONABLE);
        this.nodeService.removeAspect(nodeRef, ContentModel.ASPECT_CLASSIFIABLE);
        this.nodeService.removeAspect(nodeRef, ContentModel.ASPECT_TITLED);
    }
}

