/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.activities.feed;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.activities.feed.FeedNotifier;
import org.alfresco.repo.activities.feed.UserNotifier;
import org.alfresco.repo.domain.activities.ActivityFeedEntity;
import org.alfresco.service.cmr.activities.ActivityService;
import org.alfresco.service.cmr.admin.RepoAdminService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.namespace.NamespaceException;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.ModelUtil;
import org.alfresco.util.Pair;
import org.alfresco.util.PropertyCheck;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;

public abstract class AbstractUserNotifier
implements UserNotifier {
    protected static Log logger = LogFactory.getLog(FeedNotifier.class);
    protected ActivityService activityService;
    protected NamespaceService namespaceService;
    protected RepoAdminService repoAdminService;
    protected NodeService nodeService;
    protected SiteService siteService;

    public void setActivityService(ActivityService activityService) {
        this.activityService = activityService;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void setRepoAdminService(RepoAdminService repoAdminService) {
        this.repoAdminService = repoAdminService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    protected void checkProperties() {
        PropertyCheck.mandatory((Object)this, (String)"activityService", (Object)this.activityService);
        PropertyCheck.mandatory((Object)this, (String)"nodeService", (Object)this.nodeService);
        PropertyCheck.mandatory((Object)this, (String)"namespaceService", (Object)this.namespaceService);
        PropertyCheck.mandatory((Object)this, (String)"siteService", (Object)this.siteService);
    }

    protected abstract boolean skipUser(NodeRef var1);

    protected abstract Long getFeedId(NodeRef var1);

    protected abstract void notifyUser(NodeRef var1, String var2, Map<String, Object> var3, NodeRef var4);

    private void addSiteName(String siteId, Map<String, String> siteNames) {
        if (siteId == null) {
            return;
        }
        String siteName = siteNames.get(siteId);
        if (siteName == null) {
            SiteInfo site = this.siteService.getSite(siteId);
            if (site == null) {
                return;
            }
            String siteTitle = site.getTitle();
            siteName = siteTitle != null && siteTitle.length() > 0 ? siteTitle : siteId;
            siteNames.put(siteId, siteName);
        }
    }

    @Override
    public Pair<Integer, Long> notifyUser(NodeRef personNodeRef, String subjectText, Map<String, String> siteNames, String shareUrl, int repeatIntervalMins, NodeRef templateNodeRef) {
        Map personProps = this.nodeService.getProperties(personNodeRef);
        String feedUserId = (String)personProps.get(ContentModel.PROP_USERNAME);
        if (this.skipUser(personNodeRef)) {
            return null;
        }
        Long feedDBID = this.getFeedId(personNodeRef);
        List<ActivityFeedEntity> feedEntries = this.activityService.getUserFeedEntries(feedUserId, "json", null, false, false, null, null, feedDBID);
        if (feedEntries.size() > 0) {
            long userMaxFeedId = -1L;
            HashMap<String, Object> model = new HashMap<String, Object>();
            ArrayList<Map<String, Object>> activityFeedModels = new ArrayList<Map<String, Object>>();
            for (ActivityFeedEntity feedEntry : feedEntries) {
                Map<String, Object> map = null;
                try {
                    map = feedEntry.getModel();
                    activityFeedModels.add(map);
                    String siteId = feedEntry.getSiteNetwork();
                    this.addSiteName(siteId, siteNames);
                    long feedId = feedEntry.getId();
                    if (feedId <= userMaxFeedId) continue;
                    userMaxFeedId = feedId;
                }
                catch (JSONException je) {
                    logger.warn((Object)("Skip feed entry for user (" + feedUserId + "): " + je.getMessage()));
                }
            }
            if (activityFeedModels.size() > 0) {
                model.put("activities", activityFeedModels);
                model.put("siteTitles", siteNames);
                model.put("repeatIntervalMins", repeatIntervalMins);
                model.put("feedItemsMax", this.activityService.getMaxFeedItems());
                model.put("feedItemsCount", activityFeedModels.size());
                model.put("productName", ModelUtil.getProductName(this.repoAdminService));
                HashMap personPrefixProps = new HashMap(personProps.size());
                for (QName propQName : personProps.keySet()) {
                    try {
                        String propPrefix = propQName.toPrefixString((NamespacePrefixResolver)this.namespaceService);
                        personPrefixProps.put(propPrefix, personProps.get(propQName));
                    }
                    catch (NamespaceException ne) {
                        logger.warn((Object)("Ignoring property '" + propQName + "' as it's namespace is not registered"));
                    }
                }
                model.put("personProps", personPrefixProps);
                this.notifyUser(personNodeRef, subjectText, model, templateNodeRef);
                return new Pair((Object)activityFeedModels.size(), (Object)userMaxFeedId);
            }
        }
        return null;
    }
}

