/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.activities.feed;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.alfresco.model.ContentModel;
import org.alfresco.query.PagingRequest;
import org.alfresco.query.PagingResults;
import org.alfresco.repo.activities.feed.FeedNotifier;
import org.alfresco.repo.activities.feed.UserNotifier;
import org.alfresco.repo.admin.SysAdminParams;
import org.alfresco.repo.batch.BatchProcessWorkProvider;
import org.alfresco.repo.batch.BatchProcessor;
import org.alfresco.repo.dictionary.RepositoryLocation;
import org.alfresco.repo.lock.JobLockService;
import org.alfresco.repo.lock.LockAcquisitionException;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.admin.RepoAdminService;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ModelUtil;
import org.alfresco.util.Pair;
import org.alfresco.util.PropertyCheck;
import org.alfresco.util.UrlUtil;
import org.alfresco.util.VmShutdownListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.extensions.surf.util.I18NUtil;

public class FeedNotifierImpl
implements FeedNotifier,
ApplicationContextAware {
    protected static Log logger = LogFactory.getLog(FeedNotifier.class);
    private static final QName LOCK_QNAME = QName.createQName((String)"http://www.alfresco.org/model/system/1.0", (String)"ActivityFeedNotifier");
    private static final long LOCK_TTL = 30000L;
    private static VmShutdownListener vmShutdownListener = new VmShutdownListener(FeedNotifierImpl.class.getName());
    private static final String MSG_EMAIL_SUBJECT = "activities.feed.notifier.email.subject";
    private NamespaceService namespaceService;
    private FileFolderService fileFolderService;
    private SearchService searchService;
    private PersonService personService;
    private NodeService nodeService;
    private JobLockService jobLockService;
    private TransactionService transactionService;
    private SysAdminParams sysAdminParams;
    private RepoAdminService repoAdminService;
    private UserNotifier userNotifier;
    private ApplicationContext applicationContext;
    private RepositoryLocation feedEmailTemplateLocation;
    private int numThreads = 4;
    private int batchSize = 200;

    public void setNumThreads(int numThreads) {
        this.numThreads = numThreads;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public void setUserNotifier(UserNotifier userNotifier) {
        this.userNotifier = userNotifier;
    }

    public void setFileFolderService(FileFolderService fileFolderService) {
        this.fileFolderService = fileFolderService;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setJobLockService(JobLockService jobLockService) {
        this.jobLockService = jobLockService;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void setSysAdminParams(SysAdminParams sysAdminParams) {
        this.sysAdminParams = sysAdminParams;
    }

    public void setRepoAdminService(RepoAdminService repoAdminService) {
        this.repoAdminService = repoAdminService;
    }

    protected void checkProperties() {
        PropertyCheck.mandatory((Object)this, (String)"personService", (Object)this.personService);
        PropertyCheck.mandatory((Object)this, (String)"nodeService", (Object)this.nodeService);
        PropertyCheck.mandatory((Object)this, (String)"jobLockService", (Object)this.jobLockService);
        PropertyCheck.mandatory((Object)this, (String)"transactionService", (Object)this.transactionService);
        PropertyCheck.mandatory((Object)this, (String)"sysAdminParams", (Object)this.sysAdminParams);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(int repeatIntervalMins) {
        this.checkProperties();
        if (this.transactionService.isReadOnly()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Activities email notification bypassed; the system is read-only");
            }
            return;
        }
        String lockToken = this.getLock(30000L);
        try {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)"Activities email notification started");
            }
            this.executeInternal(lockToken, repeatIntervalMins);
            if (logger.isTraceEnabled()) {
                logger.trace((Object)"Activities email notification completed");
            }
        }
        catch (LockAcquisitionException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Activities email notification already underway");
            }
        }
        catch (VmShutdownListener.VmShutdownException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Activities email notification aborted");
            }
        }
        finally {
            this.releaseLock(lockToken);
        }
    }

    public void setFeedEmailTemplateLocation(RepositoryLocation feedEmailTemplateLocation) {
        this.feedEmailTemplateLocation = feedEmailTemplateLocation;
    }

    private NodeRef getEmailTemplateRef() {
        StoreRef store = this.feedEmailTemplateLocation.getStoreRef();
        String xpath = this.feedEmailTemplateLocation.getPath();
        if (!this.feedEmailTemplateLocation.getQueryLanguage().equals("xpath")) {
            logger.warn((Object)("Cannot find the activities email template - repository location query language is not 'xpath': " + this.feedEmailTemplateLocation.getQueryLanguage()));
            return null;
        }
        List nodeRefs = this.searchService.selectNodes(this.nodeService.getRootNode(store), xpath, null, (NamespacePrefixResolver)this.namespaceService, false);
        if (nodeRefs.size() != 1) {
            logger.warn((Object)("Cannot find the activities email template: " + xpath));
            return null;
        }
        return this.fileFolderService.getLocalizedSibling((NodeRef)nodeRefs.get(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeInternal(final String lockToken, final int repeatIntervalMins) {
        block17: {
            block15: {
                int entryCount;
                int count;
                final NodeRef emailTemplateRef = this.getEmailTemplateRef();
                if (emailTemplateRef == null) {
                    return;
                }
                final String shareUrl = UrlUtil.getShareUrl(this.sysAdminParams);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Share URL configured as: " + shareUrl));
                }
                final AtomicInteger userCnt = new AtomicInteger(0);
                final AtomicInteger feedEntryCnt = new AtomicInteger(0);
                long startTime = System.currentTimeMillis();
                final ConcurrentHashMap siteNames = new ConcurrentHashMap(10);
                try {
                    final String subjectText = this.buildSubjectText(startTime);
                    final String currentUser = AuthenticationUtil.getFullyAuthenticatedUser();
                    BatchProcessor.BatchProcessWorker<PersonService.PersonInfo> worker = new BatchProcessor.BatchProcessWorker<PersonService.PersonInfo>(){

                        @Override
                        public String getIdentifier(PersonService.PersonInfo person) {
                            StringBuilder sb = new StringBuilder("Person ");
                            sb.append(person.getUserName());
                            return sb.toString();
                        }

                        @Override
                        public void beforeProcess() throws Throwable {
                            AuthenticationUtil.setRunAsUser((String)currentUser);
                            FeedNotifierImpl.this.refreshLock(lockToken, (long)FeedNotifierImpl.this.batchSize * 500L);
                        }

                        @Override
                        public void afterProcess() throws Throwable {
                        }

                        @Override
                        public void process(PersonService.PersonInfo person) throws Throwable {
                            NodeRef personNodeRef = person.getNodeRef();
                            try {
                                Pair<Integer, Long> result = FeedNotifierImpl.this.userNotifier.notifyUser(personNodeRef, subjectText, siteNames, shareUrl, repeatIntervalMins, emailTemplateRef);
                                if (result != null) {
                                    int entryCnt = (Integer)result.getFirst();
                                    long maxFeedId = (Long)result.getSecond();
                                    Long currentMaxFeedId = (Long)FeedNotifierImpl.this.nodeService.getProperty(personNodeRef, ContentModel.PROP_EMAIL_FEED_ID);
                                    if (currentMaxFeedId == null || currentMaxFeedId < maxFeedId) {
                                        FeedNotifierImpl.this.nodeService.setProperty(personNodeRef, ContentModel.PROP_EMAIL_FEED_ID, (Serializable)Long.valueOf(maxFeedId));
                                    }
                                    userCnt.incrementAndGet();
                                    feedEntryCnt.addAndGet(entryCnt);
                                }
                            }
                            catch (InvalidNodeRefException inre) {
                                logger.warn((Object)("Skip feed notification for user (" + personNodeRef + "): " + inre.getMessage()));
                            }
                        }
                    };
                    BatchProcessWorkProvider<PersonService.PersonInfo> provider = new BatchProcessWorkProvider<PersonService.PersonInfo>(){
                        private int skip = 0;
                        private int maxItems = FeedNotifierImpl.access$000(FeedNotifierImpl.this);

                        @Override
                        public int getTotalEstimatedWorkSize() {
                            return FeedNotifierImpl.this.personService.countPeople();
                        }

                        @Override
                        public Collection<PersonService.PersonInfo> getNextWork() {
                            PagingResults<PersonService.PersonInfo> people = FeedNotifierImpl.this.personService.getPeople(null, true, null, new PagingRequest(this.skip, this.maxItems));
                            this.skip += this.maxItems;
                            return people.getPage();
                        }
                    };
                    RetryingTransactionHelper txHelper = this.transactionService.getRetryingTransactionHelper();
                    txHelper.setMaxRetries(0);
                    new BatchProcessor<PersonService.PersonInfo>("FeedNotifier", txHelper, provider, this.numThreads, this.batchSize, (ApplicationEventPublisher)this.applicationContext, logger, 100).process(worker, true);
                    count = userCnt.get();
                    entryCount = feedEntryCnt.get();
                    if (count <= 0) break block15;
                }
                catch (Throwable e) {
                    block16: {
                        int entryCount2;
                        int count2;
                        try {
                            if (!vmShutdownListener.isVmShuttingDown()) {
                                logger.error((Object)"Exception during notification of feeds", e);
                            }
                            count2 = userCnt.get();
                            entryCount2 = feedEntryCnt.get();
                            if (count2 <= 0) break block16;
                        }
                        catch (Throwable throwable) {
                            int count3 = userCnt.get();
                            int entryCount3 = feedEntryCnt.get();
                            if (count3 > 0) {
                                if (logger.isInfoEnabled()) {
                                    StringBuilder sb = new StringBuilder();
                                    sb.append("Notified ").append(userCnt).append(" user").append(count3 != 1 ? "s" : "");
                                    sb.append(" of ").append(feedEntryCnt).append(" activity feed entr").append(entryCount3 != 1 ? "ies" : "y");
                                    sb.append(" (in ").append(System.currentTimeMillis() - startTime).append(" msecs)");
                                    logger.info((Object)sb.toString());
                                }
                            } else if (logger.isTraceEnabled()) {
                                logger.trace((Object)"Nothing to send since no new user activities found");
                            }
                            throw throwable;
                        }
                        if (logger.isInfoEnabled()) {
                            StringBuilder sb = new StringBuilder();
                            sb.append("Notified ").append(userCnt).append(" user").append(count2 != 1 ? "s" : "");
                            sb.append(" of ").append(feedEntryCnt).append(" activity feed entr").append(entryCount2 != 1 ? "ies" : "y");
                            sb.append(" (in ").append(System.currentTimeMillis() - startTime).append(" msecs)");
                            logger.info((Object)sb.toString());
                        }
                    }
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)"Nothing to send since no new user activities found");
                    }
                }
                if (logger.isInfoEnabled()) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("Notified ").append(userCnt).append(" user").append(count != 1 ? "s" : "");
                    sb.append(" of ").append(feedEntryCnt).append(" activity feed entr").append(entryCount != 1 ? "ies" : "y");
                    sb.append(" (in ").append(System.currentTimeMillis() - startTime).append(" msecs)");
                    logger.info((Object)sb.toString());
                }
                break block17;
            }
            if (logger.isTraceEnabled()) {
                logger.trace((Object)"Nothing to send since no new user activities found");
            }
        }
    }

    protected String buildSubjectText(long currentTime) {
        return I18NUtil.getMessage((String)MSG_EMAIL_SUBJECT, (Object[])new Object[]{ModelUtil.getProductName(this.repoAdminService)});
    }

    private String getLock(long time) {
        try {
            return this.jobLockService.getLock(LOCK_QNAME, time);
        }
        catch (LockAcquisitionException e) {
            return null;
        }
    }

    protected void refreshLock(String lockToken, long time) {
        if (lockToken == null) {
            throw new IllegalArgumentException("Must provide existing lockToken");
        }
        this.jobLockService.refreshLock(lockToken, LOCK_QNAME, time);
    }

    private void releaseLock(String lockToken) {
        if (lockToken == null) {
            throw new IllegalArgumentException("Must provide existing lockToken");
        }
        this.jobLockService.releaseLock(lockToken, LOCK_QNAME);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

