/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.activities.feed;

import freemarker.cache.TemplateLoader;
import freemarker.cache.URLTemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.alfresco.repo.activities.feed.RepoCtx;
import org.alfresco.repo.domain.activities.ActivityFeedEntity;
import org.alfresco.repo.domain.activities.ActivityPostEntity;
import org.alfresco.repo.domain.activities.FeedControlEntity;
import org.alfresco.repo.template.ISO8601DateFormatMethod;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.util.JSONtoFmModel;
import org.alfresco.util.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.extensions.surf.util.Base64;

public abstract class FeedTaskProcessor {
    private static final Log logger = LogFactory.getLog(FeedTaskProcessor.class);
    public static final String FEED_FORMAT_JSON = "json";
    public static final String FEED_FORMAT_ATOMENTRY = "atomentry";
    public static final String FEED_FORMAT_HTML = "html";
    public static final String FEED_FORMAT_RSS = "rss";
    public static final String FEED_FORMAT_TEXT = "text";
    public static final String FEED_FORMAT_XML = "xml";
    private static final String defaultFormat = "text";
    private static final String[] formats = new String[]{"atomentry", "rss", "json", "html", "xml", "text"};
    private static final String URL_SERVICE_SITES = "/api/sites";
    private static final String URL_MEMBERSHIPS = "/memberships";
    private static final String URL_SERVICE_TEMPLATES = "/api/activities/templates";
    private static final String URL_SERVICE_TEMPLATE = "/api/activities/template";
    private boolean jsonFormatOnly = true;

    public void setJsonFormatOnly(boolean jsonOnly) {
        this.jsonFormatOnly = jsonOnly;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(int jobTaskNode, long minSeq, long maxSeq, RepoCtx ctx) throws Exception {
        int postCnt;
        long startTime = System.currentTimeMillis();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Process: jobTaskNode '" + jobTaskNode + "' from seq '" + minSeq + "' to seq '" + maxSeq + "' on this node from grid job."));
        }
        ActivityPostEntity selector = new ActivityPostEntity();
        selector.setJobTaskNode(jobTaskNode);
        selector.setMinId(minSeq);
        selector.setMaxId(maxSeq);
        selector.setStatus(ActivityPostEntity.STATUS.POSTED.toString());
        String ticket = ctx.getTicket();
        List<ActivityPostEntity> activityPosts = null;
        int totalGenerated = 0;
        try {
            activityPosts = this.selectPosts(selector);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Process: " + activityPosts.size() + " activity posts"));
            }
            Configuration cfg = this.getFreemarkerConfiguration(ctx);
            HashMap<String, ArrayList<String>> activityTemplates = new HashMap<String, ArrayList<String>>(10);
            HashMap<String, Set<String>> siteConnectedUsers = new HashMap<String, Set<String>>();
            HashMap<Pair<String, String>, Set<String>> followerConnectedUsers = new HashMap<Pair<String, String>, Set<String>>();
            HashMap<Pair<String, String>, Boolean> canUserReadSite = new HashMap<Pair<String, String>, Boolean>();
            HashMap<String, List<FeedControlEntity>> userFeedControls = new HashMap<String, List<FeedControlEntity>>();
            TreeMap<String, Template> templateCache = new TreeMap<String, Template>();
            ArrayList<String> fmTemplates = null;
            if (this.jsonFormatOnly) {
                fmTemplates = Arrays.asList("activities/org/alfresco/generic.json.ftl");
            }
            for (ActivityPostEntity activityPost : activityPosts) {
                Map<String, Object> model;
                String activityType;
                String postingUserId;
                block41: {
                    postingUserId = activityPost.getUserId();
                    activityType = activityPost.getActivityType();
                    String baseActivityType = this.getBaseActivityType(activityType);
                    if (!this.jsonFormatOnly && (fmTemplates = (ArrayList<String>)activityTemplates.get(baseActivityType)) == null) {
                        int idx;
                        String templateSubPath = this.getTemplateSubPath(activityType);
                        fmTemplates = new ArrayList<String>(0);
                        while ((idx = templateSubPath.lastIndexOf("/")) != -1) {
                            templateSubPath = templateSubPath.substring(0, idx);
                            Map<String, List<String>> templates = null;
                            try {
                                templates = this.getActivityTypeTemplates(ctx.getRepoEndPoint(), ticket, templateSubPath + "/");
                            }
                            catch (FileNotFoundException fnfe) {
                                // empty catch block
                            }
                            if (templates == null) continue;
                            if (templates.get(baseActivityType) != null) {
                                this.addMissingFormats(activityType, fmTemplates, templates.get(baseActivityType));
                            }
                            if (templates.get("generic") == null) continue;
                            this.addMissingFormats(activityType, fmTemplates, templates.get("generic"));
                        }
                        activityTemplates.put(baseActivityType, fmTemplates);
                        if (logger.isTraceEnabled()) {
                            for (String fmTemplate : fmTemplates) {
                                logger.trace((Object)("For activityType '" + activityType + "' found activity type template: " + fmTemplate));
                            }
                        }
                    }
                    if (fmTemplates.size() == 0) {
                        logger.error((Object)("Skipping activity post " + activityPost.getId() + " since no specific/generic templates for activityType: " + activityType));
                        this.updatePostStatus(activityPost.getId(), ActivityPostEntity.STATUS.ERROR);
                        continue;
                    }
                    model = null;
                    try {
                        model = JSONtoFmModel.convertJSONObjectToMap(activityPost.getActivityData());
                    }
                    catch (JSONException je) {
                        logger.error((Object)("Skipping activity post " + activityPost.getId() + " due to invalid activity data: " + (Object)((Object)je)));
                        this.updatePostStatus(activityPost.getId(), ActivityPostEntity.STATUS.ERROR);
                        continue;
                    }
                    String nodeRefStr = (String)model.get("nodeRef");
                    try {
                        if (nodeRefStr == null) break block41;
                        new NodeRef(nodeRefStr);
                    }
                    catch (Exception e) {
                        logger.error((Object)("Skipping activity post " + activityPost.getId() + " due to invalid nodeRef: " + nodeRefStr));
                        this.updatePostStatus(activityPost.getId(), ActivityPostEntity.STATUS.ERROR);
                        continue;
                    }
                }
                String thisSite = activityPost.getSiteNetwork();
                String tenantDomain = (String)model.get("tenantDomain");
                if (thisSite != null) {
                    if (tenantDomain != null) {
                        thisSite = this.getTenantName(thisSite, tenantDomain);
                    } else {
                        tenantDomain = this.getTenantDomain(thisSite);
                    }
                }
                if (tenantDomain == null) {
                    tenantDomain = "";
                }
                model.put("activityType", activityPost.getActivityType());
                model.put("siteNetwork", thisSite);
                model.put("userId", activityPost.getUserId());
                model.put("id", activityPost.getId());
                model.put("date", activityPost.getPostDate());
                model.put("xmldate", new ISO8601DateFormatMethod());
                model.put("repoEndPoint", ctx.getRepoEndPoint());
                Set<String> recipients = null;
                try {
                    recipients = this.getRecipients(ctx, thisSite, activityPost.getUserId(), tenantDomain, siteConnectedUsers, followerConnectedUsers, canUserReadSite);
                }
                catch (Exception e) {
                    logger.error((Object)("Skipping activity post " + activityPost.getId() + " since failed to get recipients: " + e));
                    this.updatePostStatus(activityPost.getId(), ActivityPostEntity.STATUS.ERROR);
                    continue;
                }
                try {
                    this.startTransaction();
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)("Process: " + recipients.size() + " candidate connections for activity post " + activityPost.getId()));
                    }
                    int excludedConnections = 0;
                    for (String recipient : recipients) {
                        List<FeedControlEntity> feedControls = null;
                        if (!recipient.equals("") && (feedControls = (List<FeedControlEntity>)userFeedControls.get(recipient)) == null) {
                            feedControls = this.getFeedControls(recipient);
                            userFeedControls.put(recipient, feedControls);
                        }
                        if (!this.acceptActivity(activityPost, feedControls)) {
                            ++excludedConnections;
                            continue;
                        }
                        if (!this.canRead(ctx, recipient, model)) {
                            ++excludedConnections;
                            continue;
                        }
                        for (String fmTemplate : fmTemplates) {
                            String formatFound = null;
                            if (this.jsonFormatOnly) {
                                formatFound = FEED_FORMAT_JSON;
                            } else {
                                for (String format : formats) {
                                    if (!fmTemplate.contains("." + format + ".")) continue;
                                    formatFound = format;
                                    break;
                                }
                                if (formatFound == null) {
                                    formatFound = "text";
                                    logger.warn((Object)("Unknown format for: " + fmTemplate + " default to '" + formatFound + "'"));
                                }
                            }
                            ActivityFeedEntity feed = new ActivityFeedEntity();
                            feed.setFeedUserId(recipient);
                            feed.setPostUserId(postingUserId);
                            feed.setActivityType(activityType);
                            String activitySummary = null;
                            activitySummary = formatFound.equals(FEED_FORMAT_JSON) ? activityPost.getActivityData() : this.processFreemarker(templateCache, fmTemplate, cfg, model);
                            if (!activitySummary.equals("")) {
                                if (activitySummary.length() > 4000) {
                                    logger.warn((Object)("Skip feed entry (activity post " + activityPost.getId() + ") since activity summary - exceeds " + 4000 + " chars: " + activitySummary));
                                    continue;
                                }
                                feed.setActivitySummary(activitySummary);
                                feed.setActivitySummaryFormat(formatFound);
                                feed.setSiteNetwork(thisSite);
                                feed.setAppTool(activityPost.getAppTool());
                                feed.setPostDate(activityPost.getPostDate());
                                feed.setPostId(activityPost.getId());
                                feed.setFeedDate(new Date());
                                this.insertFeedEntry(feed);
                                ++totalGenerated;
                                continue;
                            }
                            if (!logger.isDebugEnabled()) continue;
                            logger.debug((Object)("Empty template result for activityType '" + activityType + "' using format '" + formatFound + "' hence skip feed entry (activity post " + activityPost.getId() + ")"));
                        }
                    }
                    this.updatePostStatus(activityPost.getId(), ActivityPostEntity.STATUS.PROCESSED);
                    this.commitTransaction();
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)("Processed: " + (recipients.size() - excludedConnections) + " connections for activity post " + activityPost.getId() + " (excluded " + excludedConnections + ")"));
                }
                finally {
                    this.endTransaction();
                }
            }
            postCnt = activityPosts == null ? 0 : activityPosts.size();
        }
        catch (SQLException se) {
            try {
                logger.error((Object)se);
                throw se;
            }
            catch (Throwable throwable) {
                int postCnt2 = activityPosts == null ? 0 : activityPosts.size();
                StringBuilder sb = new StringBuilder();
                sb.append("Generated ").append(totalGenerated).append(" activity feed entr").append(totalGenerated == 1 ? "y" : "ies");
                sb.append(" for ").append(postCnt2).append(" activity post").append(postCnt2 != 1 ? "s" : "").append(" (in ").append(System.currentTimeMillis() - startTime).append(" msecs)");
                logger.info((Object)sb.toString());
                throw throwable;
            }
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Generated ").append(totalGenerated).append(" activity feed entr").append(totalGenerated == 1 ? "y" : "ies");
        sb.append(" for ").append(postCnt).append(" activity post").append(postCnt != 1 ? "s" : "").append(" (in ").append(System.currentTimeMillis() - startTime).append(" msecs)");
        logger.info((Object)sb.toString());
    }

    private Set<String> getRecipients(RepoCtx ctx, String siteId, String postUserId, String tenantDomain, Map<String, Set<String>> siteConnectedUsers, Map<Pair<String, String>, Set<String>> followerConnectedUsers, Map<Pair<String, String>, Boolean> canUserReadSite) throws Exception {
        Pair userTenantKey;
        Set<String> followerUsers;
        HashSet<String> recipients = new HashSet<String>();
        if (siteId.length() > 0) {
            Set<String> connectedUsers = siteConnectedUsers.get(siteId);
            if (connectedUsers == null) {
                try {
                    connectedUsers = this.getSiteMembers(ctx, siteId, tenantDomain);
                    connectedUsers.add("");
                }
                catch (Exception e) {
                    throw new Exception("Failed to get site members: " + e);
                }
                siteConnectedUsers.put(siteId, connectedUsers);
            }
            recipients.addAll(connectedUsers);
        }
        if ((followerUsers = followerConnectedUsers.get(userTenantKey = new Pair((Object)postUserId, (Object)tenantDomain))) == null) {
            try {
                followerUsers = this.getFollowers(postUserId, tenantDomain);
            }
            catch (Exception e) {
                throw new Exception("Failed to get followers: " + e);
            }
            followerConnectedUsers.put((Pair<String, String>)userTenantKey, followerUsers);
        }
        if (siteId.length() > 0) {
            for (String followerUser : followerUsers) {
                Pair userSiteKey = new Pair((Object)followerUser, (Object)siteId);
                Boolean canRead = canUserReadSite.get(userSiteKey);
                if (canRead == null) {
                    canRead = this.canReadSite(ctx, siteId, followerUser, tenantDomain);
                    canUserReadSite.put((Pair<String, String>)userSiteKey, canRead);
                }
                if (!canRead.booleanValue()) continue;
                recipients.add(followerUser);
            }
        } else {
            recipients.addAll(followerUsers);
        }
        recipients.add(postUserId);
        return recipients;
    }

    public abstract void startTransaction() throws SQLException;

    public abstract void commitTransaction() throws SQLException;

    public abstract void rollbackTransaction() throws SQLException;

    public abstract void endTransaction() throws SQLException;

    public abstract List<ActivityPostEntity> selectPosts(ActivityPostEntity var1) throws SQLException;

    public abstract List<FeedControlEntity> selectUserFeedControls(String var1) throws SQLException;

    public abstract long insertFeedEntry(ActivityFeedEntity var1) throws SQLException;

    public abstract int updatePostStatus(long var1, ActivityPostEntity.STATUS var3) throws SQLException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String callWebScript(String urlString, String ticket) throws MalformedURLException, URISyntaxException, IOException {
        URL url = new URL(urlString);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Request URI: " + url.toURI()));
        }
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("GET");
        if (ticket != null) {
            conn.addRequestProperty("Authorization", "Basic " + Base64.encodeBytes((byte[])ticket.getBytes()));
        }
        String result = null;
        InputStream is = null;
        BufferedReader br = null;
        try {
            is = conn.getInputStream();
            br = new BufferedReader(new InputStreamReader(is));
            String line = null;
            StringBuffer sb = new StringBuffer();
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
            result = sb.toString();
            if (logger.isDebugEnabled()) {
                int responseCode = conn.getResponseCode();
                logger.debug((Object)("Response code: " + responseCode));
            }
        }
        finally {
            if (br != null) {
                br.close();
            }
            if (is != null) {
                is.close();
            }
        }
        return result;
    }

    protected String getTenantName(String name, String tenantDomain) {
        return name;
    }

    protected String getTenantDomain(String name) {
        return "";
    }

    protected Set<String> getSiteMembers(RepoCtx ctx, String siteId, String tenantDomain) throws Exception {
        HashSet<String> members = new HashSet<String>();
        if (siteId != null && siteId.length() != 0) {
            StringBuffer sbUrl = new StringBuffer();
            sbUrl.append(ctx.getRepoEndPoint()).append(URL_SERVICE_SITES).append("/").append(siteId).append(URL_MEMBERSHIPS);
            String jsonArrayResult = this.callWebScript(sbUrl.toString(), ctx.getTicket());
            if (jsonArrayResult != null && jsonArrayResult.length() != 0) {
                JSONArray ja = new JSONArray(jsonArrayResult);
                for (int i = 0; i < ja.length(); ++i) {
                    JSONObject member = (JSONObject)ja.get(i);
                    JSONObject person = member.getJSONObject("person");
                    String userName = person.getString("userName");
                    if (!ctx.isUserNamesAreCaseSensitive()) {
                        userName = userName.toLowerCase();
                    }
                    members.add(userName);
                }
            }
        }
        return members;
    }

    protected abstract Set<String> getFollowers(String var1, String var2) throws Exception;

    protected abstract boolean canReadSite(RepoCtx var1, String var2, String var3, String var4) throws Exception;

    protected abstract boolean canRead(RepoCtx var1, String var2, Map<String, Object> var3) throws Exception;

    protected Map<String, List<String>> getActivityTypeTemplates(String repoEndPoint, String ticket, String subPath) throws Exception {
        StringBuffer sbUrl = new StringBuffer();
        sbUrl.append(repoEndPoint).append(URL_SERVICE_TEMPLATES).append(subPath).append("*").append("?format=json");
        String jsonArrayResult = null;
        try {
            jsonArrayResult = this.callWebScript(sbUrl.toString(), ticket);
        }
        catch (FileNotFoundException e) {
            return null;
        }
        ArrayList<String> allTemplateNames = new ArrayList<String>(10);
        if (jsonArrayResult != null && jsonArrayResult.length() != 0) {
            JSONArray ja = new JSONArray(jsonArrayResult);
            for (int i = 0; i < ja.length(); ++i) {
                String name = ja.getString(i);
                allTemplateNames.add(name);
            }
        }
        return this.getActivityTemplates(allTemplateNames);
    }

    protected Map<String, List<String>> getActivityTemplates(List<String> allTemplateNames) {
        HashMap<String, List<String>> activityTemplates = new HashMap<String, List<String>>(10);
        for (String template : allTemplateNames) {
            int idx3;
            int idx2;
            if (template.contains(" (Working Copy).")) continue;
            String baseActivityType = template;
            int idx1 = baseActivityType.lastIndexOf("/");
            if (idx1 != -1) {
                baseActivityType = baseActivityType.substring(idx1 + 1);
            }
            if ((idx2 = baseActivityType.lastIndexOf(".")) == -1 || (idx3 = baseActivityType.substring(0, idx2).lastIndexOf(".")) == -1) continue;
            ArrayList<String> activityTypeTemplateList = (ArrayList<String>)activityTemplates.get(baseActivityType = baseActivityType.substring(0, idx3));
            if (activityTypeTemplateList == null) {
                activityTypeTemplateList = new ArrayList<String>(1);
                activityTemplates.put(baseActivityType, activityTypeTemplateList);
            }
            activityTypeTemplateList.add(template);
        }
        return activityTemplates;
    }

    protected Configuration getFreemarkerConfiguration(RepoCtx ctx) {
        Configuration cfg = new Configuration();
        cfg.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper());
        cfg.setTemplateLoader((TemplateLoader)new TemplateWebScriptLoader(ctx.getRepoEndPoint(), ctx.getTicket()));
        cfg.setLocalizedLookup(false);
        return cfg;
    }

    protected String processFreemarker(Map<String, Template> templateCache, String fmTemplate, Configuration cfg, Map<String, Object> model) throws IOException, TemplateException, Exception {
        Template myTemplate = templateCache.get(fmTemplate);
        if (myTemplate == null) {
            myTemplate = cfg.getTemplate(fmTemplate);
            templateCache.put(fmTemplate, myTemplate);
        }
        StringWriter textWriter = new StringWriter();
        myTemplate.process(model, (Writer)textWriter);
        return textWriter.toString();
    }

    protected List<FeedControlEntity> getFeedControls(String connectedUser) throws SQLException {
        return this.selectUserFeedControls(connectedUser);
    }

    protected boolean acceptActivity(ActivityPostEntity activityPost, List<FeedControlEntity> feedControls) {
        if (feedControls == null) {
            return true;
        }
        for (FeedControlEntity feedControl : feedControls) {
            if (!((feedControl.getSiteNetwork() == null || feedControl.getSiteNetwork().length() == 0) && feedControl.getAppTool() != null ? feedControl.getAppTool().equals(activityPost.getAppTool()) : ((feedControl.getAppTool() == null || feedControl.getAppTool().length() == 0) && feedControl.getSiteNetwork() != null ? feedControl.getSiteNetwork().equals(activityPost.getSiteNetwork()) : feedControl.getSiteNetwork() != null && feedControl.getSiteNetwork().length() > 0 && feedControl.getAppTool() != null && feedControl.getAppTool().length() > 0 && feedControl.getSiteNetwork().equals(activityPost.getSiteNetwork()) && feedControl.getAppTool().equals(activityPost.getAppTool())))) continue;
            return false;
        }
        return true;
    }

    protected void addMissingFormats(String activityType, List<String> fmTemplates, List<String> templatesToAdd) {
        for (String templateToAdd : templatesToAdd) {
            int idx2;
            int idx1 = templateToAdd.lastIndexOf(".");
            if (idx1 == -1 || (idx2 = templateToAdd.substring(0, idx1).lastIndexOf(".")) == -1) continue;
            String templateFormat = templateToAdd.substring(idx2 + 1, idx1);
            boolean found = false;
            for (String fmTemplate : fmTemplates) {
                if (!fmTemplate.contains("." + templateFormat + ".")) continue;
                found = true;
            }
            if (found) continue;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Add template '" + templateToAdd + "' for type '" + activityType + "'"));
            }
            fmTemplates.add(templateToAdd);
        }
    }

    protected String getTemplateSubPath(String activityType) {
        return (!activityType.startsWith("/") ? "/" : "") + activityType.replace(".", "/");
    }

    protected String getBaseActivityType(String activityType) {
        String[] parts = activityType.split("\\.");
        return parts.length != 0 ? parts[parts.length - 1] : "";
    }

    protected class TemplateWebScriptLoader
    extends URLTemplateLoader {
        private String repoEndPoint;
        private String ticketId;

        public TemplateWebScriptLoader(String repoEndPoint, String ticketId) {
            this.repoEndPoint = repoEndPoint;
            this.ticketId = ticketId;
        }

        public URL getURL(String templatePath) {
            try {
                StringBuffer sb = new StringBuffer();
                sb.append(this.repoEndPoint).append(FeedTaskProcessor.URL_SERVICE_TEMPLATE).append("/").append(templatePath).append("?format=text").append("&alf_ticket=").append(this.ticketId);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("getURL: " + sb.toString()));
                }
                return new URL(sb.toString());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

