/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.activities.post.lookup;

import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.domain.activities.ActivityPostDAO;
import org.alfresco.repo.domain.activities.ActivityPostEntity;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.Pair;
import org.alfresco.util.PropertyCheck;
import org.alfresco.util.VmShutdownListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.quartz.JobExecutionException;

public class PostLookup {
    private static Log logger = LogFactory.getLog(PostLookup.class);
    private static VmShutdownListener vmShutdownListener = new VmShutdownListener(PostLookup.class.getName());
    private ActivityPostDAO postDAO;
    private NodeService nodeService;
    private PermissionService permissionService;
    private TransactionService transactionService;
    private PersonService personService;
    private TenantService tenantService;
    private volatile boolean busy;
    public static final String JSON_NODEREF_LOOKUP = "nodeRefL";
    public static final String JSON_NODEREF = "nodeRef";
    public static final String JSON_NODEREF_PARENT = "parentNodeRef";
    public static final String JSON_FIRSTNAME = "firstName";
    public static final String JSON_LASTNAME = "lastName";
    public static final String JSON_NAME = "name";
    public static final String JSON_TYPEQNAME = "typeQName";
    public static final String JSON_PARENT_NODEREF = "parentNodeRef";
    public static final String JSON_DISPLAY_PATH = "displayPath";
    public static final String JSON_TENANT_DOMAIN = "tenantDomain";

    public void setPostDAO(ActivityPostDAO postDAO) {
        this.postDAO = postDAO;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    private void checkProperties() {
        PropertyCheck.mandatory((Object)this, (String)"postDAO", (Object)this.postDAO);
        PropertyCheck.mandatory((Object)this, (String)"nodeService", (Object)this.nodeService);
        PropertyCheck.mandatory((Object)this, (String)"permissionService", (Object)this.permissionService);
        PropertyCheck.mandatory((Object)this, (String)"transactionService", (Object)this.transactionService);
        PropertyCheck.mandatory((Object)this, (String)"personService", (Object)this.personService);
        PropertyCheck.mandatory((Object)this, (String)"tenantService", (Object)this.tenantService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws JobExecutionException {
        this.checkProperties();
        if (this.busy) {
            logger.warn((Object)"Still busy ...");
            return;
        }
        this.busy = true;
        try {
            ActivityPostEntity params = new ActivityPostEntity();
            params.setStatus(ActivityPostEntity.STATUS.PENDING.toString());
            List<ActivityPostEntity> activityPosts = this.postDAO.selectPosts(params);
            if (activityPosts.size() > 0 && logger.isDebugEnabled()) {
                logger.debug((Object)("Update: " + activityPosts.size() + " activity post" + (activityPosts.size() == 1 ? "s" : "")));
            }
            for (final ActivityPostEntity activityPost : activityPosts) {
                final String postUserId = activityPost.getUserId();
                try {
                    String tenantDomain = "";
                    final JSONObject jo = new JSONObject(new JSONTokener(activityPost.getActivityData()));
                    if (!jo.isNull(JSON_TENANT_DOMAIN)) {
                        tenantDomain = jo.getString(JSON_TENANT_DOMAIN);
                    }
                    AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

                        public Object doWork() throws Exception {
                            try {
                                PostLookup.this.postDAO.startTransaction();
                                String activityDataStr = null;
                                if (!jo.isNull(PostLookup.JSON_NODEREF_LOOKUP)) {
                                    String nodeRefStr = jo.getString(PostLookup.JSON_NODEREF_LOOKUP);
                                    NodeRef nodeRef = new NodeRef(nodeRefStr);
                                    JSONObject activityData = PostLookup.this.lookupNode(nodeRef, postUserId, jo);
                                    activityDataStr = activityData.toString();
                                } else {
                                    Pair firstLastName = PostLookup.this.lookupPerson(postUserId);
                                    if (firstLastName != null) {
                                        jo.put(PostLookup.JSON_FIRSTNAME, firstLastName.getFirst());
                                        jo.put(PostLookup.JSON_LASTNAME, firstLastName.getSecond());
                                        activityDataStr = jo.toString();
                                    }
                                }
                                if (activityDataStr != null) {
                                    activityPost.setActivityData(activityDataStr);
                                }
                                if (activityPost.getActivityData() != null && activityPost.getActivityData().length() > 4000) {
                                    throw new IllegalArgumentException("Invalid activity data - exceeds 4000 chars: " + activityPost.getActivityData());
                                }
                                if (activityPost.getSiteNetwork() != null && activityPost.getSiteNetwork().length() > 255) {
                                    throw new IllegalArgumentException("Invalid siteId - exceeds 255 chars: " + activityPost.getSiteNetwork());
                                }
                                activityPost.setLastModified(new Date());
                                PostLookup.this.postDAO.updatePost(activityPost.getId(), activityPost.getSiteNetwork(), activityPost.getActivityData(), ActivityPostEntity.STATUS.POSTED);
                                if (logger.isDebugEnabled()) {
                                    activityPost.setStatus(ActivityPostEntity.STATUS.POSTED.toString());
                                    logger.debug((Object)("Updated: " + activityPost));
                                }
                                PostLookup.this.postDAO.commitTransaction();
                            }
                            catch (IllegalArgumentException e) {
                                logger.error((Object)("Skipping activity post " + activityPost.getId() + ": " + e));
                                PostLookup.this.postDAO.updatePostStatus(activityPost.getId(), ActivityPostEntity.STATUS.ERROR);
                                PostLookup.this.postDAO.commitTransaction();
                            }
                            catch (JSONException e) {
                                logger.error((Object)("Skipping activity post " + activityPost.getId() + ": " + (Object)((Object)e)));
                                PostLookup.this.postDAO.updatePostStatus(activityPost.getId(), ActivityPostEntity.STATUS.ERROR);
                                PostLookup.this.postDAO.commitTransaction();
                            }
                            catch (SQLException e) {
                                logger.error((Object)"Exception during update of post", (Throwable)e);
                                throw new JobExecutionException((Throwable)e);
                            }
                            finally {
                                PostLookup.this.postDAO.endTransaction();
                            }
                            return null;
                        }
                    }, (String)this.tenantService.getDomainUser(AuthenticationUtil.getSystemUserName(), tenantDomain));
                }
                catch (JSONException e) {
                    logger.error((Object)("Skipping activity post " + activityPost.getId() + ": " + (Object)((Object)e)));
                    try {
                        this.postDAO.updatePostStatus(activityPost.getId(), ActivityPostEntity.STATUS.ERROR);
                        this.postDAO.commitTransaction();
                    }
                    finally {
                        this.postDAO.endTransaction();
                    }
                }
            }
        }
        catch (SQLException e) {
            logger.error((Object)"Exception during select of posts", (Throwable)e);
            throw new JobExecutionException((Throwable)e);
        }
        catch (Throwable e) {
            if (vmShutdownListener.isVmShuttingDown()) {
            } else {
                logger.error((Object)"Exception during update of posts", e);
            }
        }
        finally {
            this.busy = false;
        }
    }

    private Pair<String, String> lookupPerson(final String postUserId) throws JSONException {
        RetryingTransactionHelper txnHelper = this.transactionService.getRetryingTransactionHelper();
        RetryingTransactionHelper.RetryingTransactionCallback<Pair<String, String>> lookup = new RetryingTransactionHelper.RetryingTransactionCallback<Pair<String, String>>(){

            @Override
            public Pair<String, String> execute() throws Throwable {
                String firstName = "";
                String lastName = "";
                if (PostLookup.this.personService.personExists(postUserId)) {
                    NodeRef personRef = PostLookup.this.personService.getPerson(postUserId);
                    firstName = (String)((Object)PostLookup.this.nodeService.getProperty(personRef, ContentModel.PROP_FIRSTNAME));
                    lastName = (String)((Object)PostLookup.this.nodeService.getProperty(personRef, ContentModel.PROP_LASTNAME));
                    return new Pair((Object)firstName, (Object)lastName);
                }
                return null;
            }
        };
        return txnHelper.doInTransaction(lookup, true);
    }

    private JSONObject lookupNode(final NodeRef nodeRef, final String postUserId, final JSONObject jo) throws JSONException {
        return (JSONObject)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<JSONObject>(){

            public JSONObject doWork() throws Exception {
                RetryingTransactionHelper txnHelper = PostLookup.this.transactionService.getRetryingTransactionHelper();
                RetryingTransactionHelper.RetryingTransactionCallback<JSONObject> lookup = new RetryingTransactionHelper.RetryingTransactionCallback<JSONObject>(){

                    @Override
                    public JSONObject execute() throws Throwable {
                        String name = "";
                        if (!jo.isNull(PostLookup.JSON_NAME)) {
                            name = jo.getString(PostLookup.JSON_NAME);
                        }
                        NodeRef parentNodeRef = null;
                        if (!jo.isNull("parentNodeRef")) {
                            parentNodeRef = new NodeRef(jo.getString("parentNodeRef"));
                        }
                        String typeQName = "";
                        if (!jo.isNull(PostLookup.JSON_TYPEQNAME)) {
                            typeQName = jo.getString(PostLookup.JSON_TYPEQNAME);
                        }
                        String displayPath = "";
                        Path path = null;
                        String firstName = "";
                        String lastName = "";
                        if (PostLookup.this.personService.personExists(postUserId)) {
                            NodeRef personRef = PostLookup.this.personService.getPerson(postUserId);
                            firstName = (String)((Object)PostLookup.this.nodeService.getProperty(personRef, ContentModel.PROP_FIRSTNAME));
                            lastName = (String)((Object)PostLookup.this.nodeService.getProperty(personRef, ContentModel.PROP_LASTNAME));
                        }
                        if (nodeRef != null && PostLookup.this.nodeService.exists(nodeRef)) {
                            if (name.length() == 0) {
                                name = (String)((Object)PostLookup.this.nodeService.getProperty(nodeRef, ContentModel.PROP_NAME));
                            }
                            if (typeQName.length() == 0) {
                                typeQName = PostLookup.this.nodeService.getType(nodeRef).toPrefixString();
                            }
                            if (parentNodeRef == null) {
                                parentNodeRef = PostLookup.this.nodeService.getPrimaryParent(nodeRef).getParentRef();
                            }
                        }
                        if (parentNodeRef != null && PostLookup.this.nodeService.exists(parentNodeRef)) {
                            path = PostLookup.this.nodeService.getPath(parentNodeRef);
                        }
                        if (path != null) {
                            displayPath = path.toDisplayPath(PostLookup.this.nodeService, PostLookup.this.permissionService);
                            displayPath = displayPath + "/" + name;
                        }
                        jo.put(PostLookup.JSON_NAME, (Object)name);
                        jo.put(PostLookup.JSON_NODEREF, (Object)nodeRef.toString());
                        jo.put(PostLookup.JSON_TYPEQNAME, (Object)typeQName);
                        jo.put("parentNodeRef", (Object)(parentNodeRef != null ? parentNodeRef.toString() : null));
                        jo.put(PostLookup.JSON_DISPLAY_PATH, (Object)displayPath);
                        jo.put(PostLookup.JSON_FIRSTNAME, (Object)firstName);
                        jo.put(PostLookup.JSON_LASTNAME, (Object)lastName);
                        return jo;
                    }
                };
                return txnHelper.doInTransaction(lookup, true);
            }
        }, (String)AuthenticationUtil.getSystemUserName());
    }
}

