/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.admin.patch.impl;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.sql.Savepoint;
import java.util.Date;
import java.util.List;
import org.alfresco.repo.admin.patch.AbstractPatch;
import org.alfresco.repo.batch.BatchProcessor;
import org.alfresco.repo.domain.control.ControlDAO;
import org.alfresco.repo.domain.patch.PatchDAO;
import org.alfresco.repo.domain.permissions.AclCrudDAO;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.util.TempFileProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.I18NUtil;

public class FixAuthoritiesCrcValuesPatch
extends AbstractPatch {
    private static final String MSG_SUCCESS = "patch.fixAuthoritiesCrcValues.result";
    private static final String MSG_REWRITTEN = "patch.fixAuthoritiesCrcValues.fixed";
    private static final String MSG_UNABLE_TO_CHANGE = "patch.fixAuthoritiesCrcValues.unableToChange";
    private final Log logger = LogFactory.getLog(this.getClass());
    private PatchDAO patchDAO;
    private AclCrudDAO aclCrudDAO;
    private ControlDAO controlDAO;

    public void setPatchDAO(PatchDAO patchDAO) {
        this.patchDAO = patchDAO;
    }

    public void setAclCrudDAO(AclCrudDAO aclCrudDAO) {
        this.aclCrudDAO = aclCrudDAO;
    }

    public void setControlDAO(ControlDAO controlDAO) {
        this.controlDAO = controlDAO;
    }

    @Override
    protected void checkProperties() {
        super.checkProperties();
        this.checkPropertyNotNull(this.patchDAO, "patchDAO");
        this.checkPropertyNotNull(this.aclCrudDAO, "aclCrudDAO");
        this.checkPropertyNotNull(this.controlDAO, "controlDAO");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String applyInternal() throws Exception {
        FixAuthoritiesCrcValuesPatchHelper helper = new FixAuthoritiesCrcValuesPatchHelper();
        try {
            String msg;
            String string = msg = helper.fixCrcValues();
            return string;
        }
        finally {
            helper.closeWriter();
        }
    }

    private class FixAuthoritiesCrcValuesPatchHelper {
        private File logFile;
        private FileChannel channel;

        private FixAuthoritiesCrcValuesPatchHelper() throws IOException {
            File tempDir = TempFileProvider.getLongLifeTempDir((String)"patches");
            this.logFile = new File(tempDir, "FixAuthorityCrcValuesPatch.log");
            RandomAccessFile outputFile = new RandomAccessFile(this.logFile, "rw");
            this.channel = outputFile.getChannel();
            this.channel.position(this.channel.size());
            this.writeLine("").writeLine("");
            this.writeLine("FixAuthorityCrcValuesPatch executing on " + new Date());
        }

        private FixAuthoritiesCrcValuesPatchHelper write(Object obj) throws IOException {
            this.channel.write(ByteBuffer.wrap(obj.toString().getBytes("UTF-8")));
            return this;
        }

        private FixAuthoritiesCrcValuesPatchHelper writeLine(Object obj) throws IOException {
            this.write(obj);
            this.write("\n");
            return this;
        }

        private void closeWriter() {
            try {
                this.channel.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        public String fixCrcValues() throws Exception {
            List<String> mismatchedAuthorities = FixAuthoritiesCrcValuesPatch.this.patchDAO.getAuthoritiesWithNonUtf8Crcs();
            BatchProcessor<String> batchProcessor = new BatchProcessor<String>("FixAuthorityCrcValuesPatch", FixAuthoritiesCrcValuesPatch.this.transactionHelper, mismatchedAuthorities, 2, 20, FixAuthoritiesCrcValuesPatch.this.applicationEventPublisher, FixAuthoritiesCrcValuesPatch.this.logger, 1000);
            int updated = batchProcessor.process(new BatchProcessor.BatchProcessWorker<String>(){

                @Override
                public String getIdentifier(String entry) {
                    return entry;
                }

                @Override
                public void beforeProcess() throws Throwable {
                    String systemUsername = AuthenticationUtil.getSystemUserName();
                    AuthenticationUtil.setFullyAuthenticatedUser((String)systemUsername);
                }

                @Override
                public void process(String authority) throws Throwable {
                    Savepoint savepoint = FixAuthoritiesCrcValuesPatch.this.controlDAO.createSavepoint("FixAuthorityCrcValuesPatch");
                    try {
                        FixAuthoritiesCrcValuesPatch.this.aclCrudDAO.renameAuthority(authority, authority);
                        FixAuthoritiesCrcValuesPatch.this.controlDAO.releaseSavepoint(savepoint);
                    }
                    catch (Throwable e) {
                        FixAuthoritiesCrcValuesPatch.this.controlDAO.rollbackToSavepoint(savepoint);
                        String msg = I18NUtil.getMessage((String)FixAuthoritiesCrcValuesPatch.MSG_UNABLE_TO_CHANGE, (Object[])new Object[]{authority, e.getMessage()});
                        if (FixAuthoritiesCrcValuesPatch.this.logger.isDebugEnabled()) {
                            FixAuthoritiesCrcValuesPatch.this.logger.debug((Object)msg, e);
                        } else {
                            FixAuthoritiesCrcValuesPatch.this.logger.warn((Object)msg);
                        }
                        FixAuthoritiesCrcValuesPatchHelper.this.writeLine(msg);
                    }
                    FixAuthoritiesCrcValuesPatchHelper.this.writeLine(I18NUtil.getMessage((String)FixAuthoritiesCrcValuesPatch.MSG_REWRITTEN, (Object[])new Object[]{authority}));
                }

                @Override
                public void afterProcess() throws Throwable {
                }
            }, true);
            String msg = I18NUtil.getMessage((String)FixAuthoritiesCrcValuesPatch.MSG_SUCCESS, (Object[])new Object[]{updated, this.logFile});
            return msg;
        }
    }
}

