/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.admin.patch.impl;

import java.io.Serializable;
import java.util.Map;
import org.alfresco.repo.admin.patch.AbstractPatch;
import org.alfresco.repo.domain.patch.PatchDAO;
import org.alfresco.service.cmr.attributes.AttributeService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ibatis.session.ResultContext;
import org.apache.ibatis.session.ResultHandler;
import org.springframework.extensions.surf.util.I18NUtil;

public class MigrateAttrChainingURSPatch
extends AbstractPatch {
    private Log logger = LogFactory.getLog(this.getClass());
    private static final String MSG_SUCCESS = "patch.migrateAttrChainingURS.result";
    private AttributeService attributeService;
    private PatchDAO patchDAO;

    public void setAttributeService(AttributeService attributeService) {
        this.attributeService = attributeService;
    }

    public void setPatchDAO(PatchDAO patchDAO) {
        this.patchDAO = patchDAO;
    }

    @Override
    protected String applyInternal() throws Exception {
        long startTime = System.currentTimeMillis();
        ChainingURSResultHandler handler = new ChainingURSResultHandler();
        this.patchDAO.migrateOldAttrChainingURS(handler);
        if (handler.total > 0) {
            this.logger.info((Object)("Processed " + handler.total + " Chaining URS attrs in " + (System.currentTimeMillis() - startTime) / 1000L + " secs"));
        }
        String msg = I18NUtil.getMessage((String)MSG_SUCCESS, (Object[])new Object[]{handler.total});
        return msg;
    }

    private class ChainingURSResultHandler
    implements ResultHandler {
        private int total = 0;

        private ChainingURSResultHandler() {
        }

        public void handleResult(ResultContext context) {
            Map result = (Map)context.getResultObject();
            String label = (String)result.get("label");
            String zoneId = (String)result.get("zoneId");
            Long lastModified = (Long)result.get("lastModified");
            MigrateAttrChainingURSPatch.this.attributeService.setAttribute(lastModified, new Serializable[]{".ChainingUserRegistrySynchronizer", label, zoneId});
            if (MigrateAttrChainingURSPatch.this.logger.isTraceEnabled()) {
                MigrateAttrChainingURSPatch.this.logger.trace((Object)("Set Chaining URS attr [label=" + label + ", zoneId=" + zoneId + ", lastModified=" + lastModified + "]"));
            }
            ++this.total;
            if (MigrateAttrChainingURSPatch.this.logger.isDebugEnabled() && (this.total == 0 || this.total % 1000 == 0)) {
                MigrateAttrChainingURSPatch.this.logger.debug((Object)("   Handled " + this.total + " Chaining URS attributes"));
            }
        }
    }
}

