/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.admin.patch.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.WCMAppModel;
import org.alfresco.repo.admin.patch.impl.MoveWCMToGroupBasedPermissionsPatch;
import org.alfresco.repo.domain.PropertyValue;
import org.alfresco.repo.domain.avm.AVMChildEntryEntity;
import org.alfresco.repo.domain.avm.AVMNodeLinksDAO;
import org.alfresco.repo.domain.avm.AVMStoreDAO;
import org.alfresco.repo.domain.patch.PatchDAO;
import org.alfresco.repo.domain.permissions.AclCrudDAO;
import org.alfresco.repo.domain.permissions.AclEntity;
import org.alfresco.repo.domain.permissions.AclUpdateEntity;
import org.alfresco.repo.domain.permissions.Authority;
import org.alfresco.repo.domain.permissions.Permission;
import org.alfresco.repo.search.AVMSnapShotTriggeredIndexingMethodInterceptorImpl;
import org.alfresco.repo.security.permissions.ACEType;
import org.alfresco.repo.security.permissions.ACLType;
import org.alfresco.repo.security.permissions.impl.SimplePermissionReference;
import org.alfresco.service.cmr.admin.PatchException;
import org.alfresco.service.cmr.avm.AVMStoreDescriptor;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.AuthorityType;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.util.GUID;
import org.alfresco.util.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.I18NUtil;

public class ResetWCMToGroupBasedPermissionsPatch
extends MoveWCMToGroupBasedPermissionsPatch {
    private static Log logger = LogFactory.getLog(ResetWCMToGroupBasedPermissionsPatch.class);
    private static final String MSG_SUCCESS = "patch.resetWCMToGroupBasedPermissionsPatch.result";
    private AclCrudDAO aclCrudDAO;
    private AVMStoreDAO avmStoreDAO;
    private AVMNodeLinksDAO avmNodeLinksDAO;
    private PatchDAO patchDAO;
    private HelperDAO helper;
    private PersonService personService;
    private static int batchSize = 500;
    private Map<String, Pair<Long, Long>> stagingData = new HashMap<String, Pair<Long, Long>>(10);

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public void setAvmStoreDAO(AVMStoreDAO avmStoreDAO) {
        this.avmStoreDAO = avmStoreDAO;
    }

    public void setAvmNodeLinksDAO(AVMNodeLinksDAO avmNodeLinksDAO) {
        this.avmNodeLinksDAO = avmNodeLinksDAO;
    }

    public void setAclCrudDAO(AclCrudDAO aclCrudDAO) {
        this.aclCrudDAO = aclCrudDAO;
    }

    public void setPatchDAO(PatchDAO patchDAO) {
        this.patchDAO = patchDAO;
    }

    public void setBatchSize(int batchSizeOverride) {
        batchSize = batchSizeOverride;
    }

    public ResetWCMToGroupBasedPermissionsPatch() {
        this.helper = new HelperDAO();
    }

    @Override
    protected String applyInternal() throws Exception {
        AVMStoreDescriptor store;
        AVMSnapShotTriggeredIndexingMethodInterceptorImpl.StoreType storeType;
        long splitTime = System.currentTimeMillis();
        List<AVMStoreDescriptor> stores = this.avmService.getStores();
        logger.info((Object)("Retrieved list of " + stores.size() + " AVM store descriptors in " + (System.currentTimeMillis() - splitTime) / 1000L + " secs"));
        splitTime = System.currentTimeMillis();
        ArrayList<Pair> wcmStores = new ArrayList<Pair>(stores.size());
        int count = 0;
        for (AVMStoreDescriptor store2 : stores) {
            Map<QName, PropertyValue> storeProperties = this.avmService.getStoreProperties(store2.getName());
            storeType = AVMSnapShotTriggeredIndexingMethodInterceptorImpl.StoreType.getStoreType(store2.getName(), store2, storeProperties);
            if (storeType.equals((Object)AVMSnapShotTriggeredIndexingMethodInterceptorImpl.StoreType.UNKNOWN)) continue;
            wcmStores.add(new Pair((Object)store2, (Object)storeType));
            ++count;
        }
        logger.info((Object)("Retrieved store types for " + count + " WCM stores in " + (System.currentTimeMillis() - splitTime) / 1000L + " secs"));
        splitTime = System.currentTimeMillis();
        count = 0;
        for (Pair wcmStore : wcmStores) {
            store = (AVMStoreDescriptor)wcmStore.getFirst();
            storeType = (AVMSnapShotTriggeredIndexingMethodInterceptorImpl.StoreType)((Object)wcmStore.getSecond());
            switch (storeType) {
                case STAGING: {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Process store " + store.getName() + " (" + (Object)((Object)storeType) + ")"));
                    }
                    ++count;
                    this.makeGroupsIfRequired(store);
                    this.addUsersToGroupIfRequired(store);
                    this.nullifyAvmNodeAclsExcluding(store.getName(), "www");
                    this.setStagingAreaPermissions(store);
                    this.setStagingAreaMasks(store);
                    break;
                }
            }
        }
        if (count > 0) {
            logger.info((Object)("Processed " + count + " WCM staging stores: " + (System.currentTimeMillis() - splitTime) / 1000L + " secs"));
        }
        splitTime = System.currentTimeMillis();
        count = 0;
        for (Pair wcmStore : wcmStores) {
            store = (AVMStoreDescriptor)wcmStore.getFirst();
            storeType = (AVMSnapShotTriggeredIndexingMethodInterceptorImpl.StoreType)((Object)wcmStore.getSecond());
            switch (storeType) {
                case AUTHOR: 
                case AUTHOR_PREVIEW: 
                case AUTHOR_WORKFLOW: 
                case AUTHOR_WORKFLOW_PREVIEW: 
                case WORKFLOW: 
                case WORKFLOW_PREVIEW: 
                case STAGING_PREVIEW: {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Nullify acls for store " + store.getName() + " (" + (Object)((Object)storeType) + ")"));
                    }
                    ++count;
                    this.nullifyAvmNodeAcls(store.getName());
                    break;
                }
            }
        }
        if (count > 0) {
            logger.info((Object)("Nullified acls for " + count + " WCM sandbox stores: " + (System.currentTimeMillis() - splitTime) / 1000L + " secs"));
        }
        if (wcmStores.size() > 0) {
            splitTime = System.currentTimeMillis();
            this.deleteDangling();
            logger.info((Object)("Deleted dangling acls/aces across all stores in " + (System.currentTimeMillis() - splitTime) / 1000L + " secs"));
        }
        splitTime = System.currentTimeMillis();
        count = 0;
        for (Pair wcmStore : wcmStores) {
            store = (AVMStoreDescriptor)wcmStore.getFirst();
            storeType = (AVMSnapShotTriggeredIndexingMethodInterceptorImpl.StoreType)((Object)wcmStore.getSecond());
            switch (storeType) {
                case AUTHOR: 
                case WORKFLOW: {
                    if (this.stagingData.get(this.extractBaseStore(store.getName())) == null) {
                        if (!logger.isDebugEnabled()) break;
                        logger.debug((Object)("Skip store " + store.getName() + " (" + (Object)((Object)storeType) + ") since no corresponding base store"));
                        break;
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Process store " + store.getName() + " (" + (Object)((Object)storeType) + ")"));
                    }
                    ++count;
                    this.setSandboxPermissions(store);
                    this.setSandBoxMasks(store);
                    break;
                }
                case STAGING_PREVIEW: {
                    if (this.stagingData.get(this.extractBaseStore(store.getName())) == null) {
                        if (!logger.isDebugEnabled()) break;
                        logger.debug((Object)("Skip store " + store.getName() + " (" + (Object)((Object)storeType) + ") since no corresponding base store"));
                        break;
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Process store " + store.getName() + " (" + (Object)((Object)storeType) + ")"));
                    }
                    ++count;
                    this.setSandboxPermissions(store);
                    this.setStagingAreaMasks(store);
                    break;
                }
            }
        }
        for (Pair wcmStore : wcmStores) {
            store = (AVMStoreDescriptor)wcmStore.getFirst();
            storeType = (AVMSnapShotTriggeredIndexingMethodInterceptorImpl.StoreType)((Object)wcmStore.getSecond());
            switch (storeType) {
                case AUTHOR_PREVIEW: 
                case AUTHOR_WORKFLOW: 
                case WORKFLOW_PREVIEW: {
                    if (this.stagingData.get(this.extractBaseStore(store.getName())) == null) {
                        if (!logger.isDebugEnabled()) break;
                        logger.debug((Object)("Skip store " + store.getName() + " (" + (Object)((Object)storeType) + ") since no corresponding base store"));
                        break;
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Process store " + store.getName() + " (" + (Object)((Object)storeType) + ")"));
                    }
                    ++count;
                    this.setSandboxPermissions(store);
                    this.setSandBoxMasks(store);
                    break;
                }
            }
        }
        for (Pair wcmStore : wcmStores) {
            store = (AVMStoreDescriptor)wcmStore.getFirst();
            storeType = (AVMSnapShotTriggeredIndexingMethodInterceptorImpl.StoreType)((Object)wcmStore.getSecond());
            switch (storeType) {
                case AUTHOR_WORKFLOW_PREVIEW: {
                    if (this.stagingData.get(this.extractBaseStore(store.getName())) == null) {
                        if (!logger.isDebugEnabled()) break;
                        logger.debug((Object)("Skip store " + store.getName() + " (" + (Object)((Object)storeType) + ") since no corresponding base store"));
                        break;
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Process store " + store.getName() + " (" + (Object)((Object)storeType) + ")"));
                    }
                    ++count;
                    this.setSandboxPermissions(store);
                    this.setSandBoxMasks(store);
                    break;
                }
            }
        }
        if (count > 0) {
            logger.info((Object)("Processed " + count + " WCM sandbox stores: " + (System.currentTimeMillis() - splitTime) / 1000L + " secs"));
        }
        String msg = I18NUtil.getMessage((String)MSG_SUCCESS);
        return msg;
    }

    private void makeGroupsIfRequired(AVMStoreDescriptor stagingStore) {
        long startTime = System.currentTimeMillis();
        String stagingStoreName = stagingStore.getName();
        int count = 0;
        for (String permission : MoveWCMToGroupBasedPermissionsPatch.PERMISSIONS) {
            String shortName = stagingStoreName + "-" + permission;
            String group = this.authorityService.getName(AuthorityType.GROUP, shortName);
            if (!this.authorityService.authorityExists(group)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Create: " + group));
                }
                this.authorityService.createAuthority(AuthorityType.GROUP, shortName);
                ++count;
                continue;
            }
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)("Already exists: " + group));
        }
        if (logger.isDebugEnabled() && count > 0) {
            logger.debug((Object)("Created " + count + " missing groups in " + (System.currentTimeMillis() - startTime) / 1000L + " secs"));
        }
    }

    private void nullifyAvmNodeAcls(String storeName) throws Exception {
        long startTime = System.currentTimeMillis();
        int updatedCount = this.helper.nullifyAvmNodeAcls(storeName);
        if (logger.isDebugEnabled() && updatedCount > 0) {
            logger.debug((Object)("nullifyAvmNodeAcls (" + updatedCount + ") for store: " + storeName + " in " + (System.currentTimeMillis() - startTime) / 1000L + " secs"));
        }
    }

    private void nullifyAvmNodeAclsExcluding(String storeName, String excludeRootChild) throws Exception {
        long startTime = System.currentTimeMillis();
        int updatedCount = this.helper.nullifyAvmNodeAclsExcluding(storeName, excludeRootChild);
        if (logger.isDebugEnabled() && updatedCount > 0) {
            logger.debug((Object)("nullifyAvmNodeAcls (" + updatedCount + ") for store: " + storeName + " excluding '" + excludeRootChild + "' in " + (System.currentTimeMillis() - startTime) / 1000L + " secs"));
        }
    }

    private void deleteDangling() {
        try {
            long startTime = System.currentTimeMillis();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Start deleting dangling acls/aces (across all stores)");
            }
            int aclsDeletedCount = this.helper.deleteDanglingAcls();
            int acesDeletedCount = this.patchDAO.deleteDanglingAces();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Finish deleting dangling acls/aces [" + aclsDeletedCount + "/" + acesDeletedCount + "] (across all stores) in " + (System.currentTimeMillis() - startTime) / 1000L + " secs"));
            }
        }
        catch (Throwable e) {
            String msg = "Failed to delete dangling acls/aces";
            logger.error((Object)msg, e);
            throw new PatchException(msg, e);
        }
    }

    @Override
    protected void setStagingAreaPermissions(AVMStoreDescriptor stagingStore) throws Exception {
        long startTime = System.currentTimeMillis();
        String stagingStoreName = stagingStore.getName();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Start set staging area permissions: " + stagingStoreName));
        }
        Long aclChangeSet = this.aclCrudDAO.createAclChangeSet();
        long definingAclId = this.helper.createWCMGroupBasedAcl(stagingStoreName, aclChangeSet, ACLType.DEFINING, false);
        long sharedAclId = this.helper.createWCMGroupBasedAcl(stagingStoreName, aclChangeSet, ACLType.SHARED, false);
        this.stagingData.put(stagingStoreName, (Pair<Long, Long>)new Pair((Object)aclChangeSet, (Object)sharedAclId));
        this.helper.updateAclInherited(definingAclId, sharedAclId);
        this.helper.updateAclInheritsFrom(sharedAclId, definingAclId);
        this.helper.updateAclInherited(sharedAclId, sharedAclId);
        this.helper.setRootAcl(stagingStoreName, definingAclId);
        int updatedCount = this.helper.setSharedAcls(stagingStoreName, sharedAclId);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Finish set staging area permissions: " + stagingStore.getName() + " in " + (System.currentTimeMillis() - startTime) / 1000L + " secs (updated " + (updatedCount + 1) + ")"));
        }
    }

    protected void setSandboxPermissions(AVMStoreDescriptor sandboxStore) throws Exception {
        long startTime = System.currentTimeMillis();
        String sandboxStoreName = sandboxStore.getName();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Start set sandbox permissions: " + sandboxStoreName));
        }
        Pair<Long, Long> aclData = this.stagingData.get(this.extractBaseStore(sandboxStoreName));
        long aclChangeSet = (Long)aclData.getFirst();
        long baseSharedAclId = (Long)aclData.getSecond();
        String stagingStoreName = this.extractStagingAreaName(sandboxStoreName);
        long layeredAclId = this.helper.createWCMGroupBasedAcl(stagingStoreName, aclChangeSet, ACLType.LAYERED, true);
        long sharedAclId = this.helper.createWCMGroupBasedAcl(stagingStoreName, aclChangeSet, ACLType.SHARED, false);
        this.stagingData.put(sandboxStoreName, (Pair<Long, Long>)new Pair((Object)aclChangeSet, (Object)sharedAclId));
        this.helper.updateAclInheritsFrom(layeredAclId, baseSharedAclId);
        this.helper.updateAclInheritsFrom(sharedAclId, layeredAclId);
        this.helper.setRootAcl(sandboxStoreName, layeredAclId);
        int updatedCount = this.helper.setSharedAcls(sandboxStoreName, sharedAclId);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Finish set sandbox permissions: " + sandboxStoreName + " in " + (System.currentTimeMillis() - startTime) / 1000L + " secs (updated " + (updatedCount + 1) + ")"));
        }
    }

    private void addUsersToGroupIfRequired(AVMStoreDescriptor stagingStore) {
        long startTime = System.currentTimeMillis();
        QName propQName = QName.createQName(null, (String)".web_project.noderef");
        PropertyValue pValue = this.avmService.getStoreProperty(stagingStore.getName(), propQName);
        if (pValue != null) {
            NodeRef webProjectNodeRef = (NodeRef)pValue.getValue(DataTypeDefinition.NODE_REF);
            List userInfoRefs = this.nodeService.getChildAssocs(webProjectNodeRef, (QNamePattern)WCMAppModel.ASSOC_WEBUSER, RegexQNamePattern.MATCH_ALL);
            for (ChildAssociationRef ref : userInfoRefs) {
                NodeRef userInfoRef = ref.getChildRef();
                String username = (String)((Object)this.nodeService.getProperty(userInfoRef, WCMAppModel.PROP_WEBUSERNAME));
                String userrole = (String)((Object)this.nodeService.getProperty(userInfoRef, WCMAppModel.PROP_WEBUSERROLE));
                if (userrole.equals("All")) {
                    userrole = this.replaceAllWith;
                    this.nodeService.setProperty(userInfoRef, WCMAppModel.PROP_WEBUSERROLE, (Serializable)((Object)userrole));
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Set role " + userrole + " for user " + username + " in web project " + stagingStore.getName()));
                    }
                }
                this.addToGroupIfRequired(stagingStore.getName(), username, userrole);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Check and add missing users (if any) to group(s) in " + (System.currentTimeMillis() - startTime) / 1000L + " secs"));
        }
    }

    @Override
    protected void addToGroupIfRequired(String stagingStoreName, String user, String permission) {
        String shortName = stagingStoreName + "-" + permission;
        String group = this.authorityService.getName(AuthorityType.GROUP, shortName);
        Set<String> members = this.authorityService.getContainedAuthorities(AuthorityType.USER, group, true);
        if (!members.contains(user)) {
            if (!this.personService.personExists(user)) {
                logger.warn((Object)("Person does not exist: " + user + " (not added to: " + group));
            } else {
                this.authorityService.addAuthority(group, user);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Added user " + user + " to: " + group));
                }
            }
        }
    }

    protected String extractBaseStore(String name) {
        int index = name.lastIndexOf("--");
        if (index != -1) {
            return name.substring(0, index);
        }
        return name;
    }

    private class HelperDAO {
        private HelperDAO() {
        }

        private int nullifyAvmNodeAcls(String storeName) {
            try {
                long rootId = this.getAVMStoreCurrentRootNodeId(storeName);
                int updatedCount = this.nullifyAvmNodeAcls(rootId);
                ArrayList<Long> childIds = new ArrayList<Long>(1);
                childIds.add(rootId);
                return updatedCount += this.nullifyAvmNodeAclsForChildren(childIds);
            }
            catch (Throwable e) {
                String msg = "Failed to nullify avm node acl ids for: " + storeName;
                logger.error((Object)msg, e);
                throw new PatchException(msg, e);
            }
        }

        private int nullifyAvmNodeAclsExcluding(String storeName, String excludeRootChild) {
            try {
                long rootId = this.getAVMStoreCurrentRootNodeId(storeName);
                List<AVMChildEntryEntity> children = this.getAVMChildrenEntries(rootId);
                int totalUpdatedCount = 0;
                ArrayList<Long> childIds = new ArrayList<Long>(0);
                for (AVMChildEntryEntity child : children) {
                    Long childId = child.getChildId();
                    String name = child.getName();
                    if (name.equals(excludeRootChild)) continue;
                    totalUpdatedCount += this.nullifyAvmNodeAcls(childId);
                    childIds.add(childId);
                }
                if (childIds.size() > 0) {
                    totalUpdatedCount += this.nullifyAvmNodeAclsForChildren(childIds);
                }
                return totalUpdatedCount;
            }
            catch (Throwable e) {
                String msg = "Failed to nullify avm node acl ids for: " + storeName + " (excluding " + excludeRootChild + ")";
                logger.error((Object)msg, e);
                throw new PatchException(msg, e);
            }
        }

        private int nullifyAvmNodeAcls(long parentId) throws Exception {
            List<Long> childIds = this.getAVMChildren(parentId);
            int updatedCount = 0;
            if (childIds.size() > 0) {
                updatedCount = this.nullifyAvmNodeAclsForChildren(childIds);
                for (Long childId : childIds) {
                    updatedCount += this.nullifyAvmNodeAcls(childId);
                }
            }
            return updatedCount;
        }

        private int nullifyAvmNodeAclsForChildren(List<Long> childIds) {
            int totalUpdateCount = 0;
            Iterator<Long> childIdIterator = childIds.iterator();
            ArrayList<Long> batchChildIds = new ArrayList<Long>(batchSize);
            while (childIdIterator.hasNext()) {
                Long childId = childIdIterator.next();
                batchChildIds.add(childId);
                if (batchChildIds.size() != batchSize && childIdIterator.hasNext()) continue;
                int batchUpdateCount = ResetWCMToGroupBasedPermissionsPatch.this.patchDAO.updateAVMNodesNullifyAcl(batchChildIds);
                totalUpdateCount += batchUpdateCount;
                batchChildIds.clear();
            }
            return totalUpdateCount;
        }

        private int updateChildNodeAclIds(long aclId, List<Long> childIds) {
            int totalUpdateCount = 0;
            Iterator<Long> childIdIterator = childIds.iterator();
            ArrayList<Long> batchChildIds = new ArrayList<Long>(batchSize);
            while (childIdIterator.hasNext()) {
                Long childId = childIdIterator.next();
                batchChildIds.add(childId);
                if (batchChildIds.size() != batchSize && childIdIterator.hasNext()) continue;
                int batchUpdateCount = ResetWCMToGroupBasedPermissionsPatch.this.patchDAO.updateAVMNodesSetAcl(aclId, batchChildIds);
                totalUpdateCount += batchUpdateCount;
                batchChildIds.clear();
            }
            return totalUpdateCount;
        }

        private void setRootAcl(String storeName, long aclId) throws Exception {
            try {
                long rootId = this.getAVMStoreCurrentRootNodeId(storeName);
                List<AVMChildEntryEntity> children = this.getAVMChildrenEntries(rootId);
                int totalUpdatedCount = 0;
                for (AVMChildEntryEntity child : children) {
                    Long childId = child.getChildId();
                    String name = child.getName();
                    if (!name.equals("www")) continue;
                    ArrayList<Long> childIds = new ArrayList<Long>(1);
                    childIds.add(childId);
                    int updatedCount = this.updateChildNodeAclIds(aclId, childIds);
                    totalUpdatedCount += updatedCount;
                }
                if (totalUpdatedCount != 1) {
                    throw new AlfrescoRuntimeException("Failed to set top acl for store: " + storeName + " (unexpected updateCount = " + totalUpdatedCount);
                }
            }
            catch (Throwable e) {
                String msg = "Failed to set top acl for store: " + storeName;
                logger.error((Object)msg, e);
                throw new PatchException(msg, e);
            }
        }

        private int setSharedAcls(String storeName, long sharedAclId) throws Exception {
            try {
                long rootId = this.getAVMStoreCurrentRootNodeId(storeName);
                List<AVMChildEntryEntity> children = this.getAVMChildrenEntries(rootId);
                ArrayList<Long> childIds = new ArrayList<Long>(1);
                for (AVMChildEntryEntity child : children) {
                    Long childId = child.getChildId();
                    String name = child.getName();
                    if (!name.equals("www")) continue;
                    childIds.add(childId);
                }
                if (childIds.size() != 1) {
                    throw new AlfrescoRuntimeException("Did not find one 'www' (" + childIds.size() + ") for: " + storeName);
                }
                return this.setSharedAcls((Long)childIds.get(0), sharedAclId);
            }
            catch (Throwable e) {
                String msg = "Failed to set shared acls for store: " + storeName;
                logger.error((Object)msg, e);
                throw new PatchException(msg, e);
            }
        }

        private int setSharedAcls(long parentId, long sharedAclId) throws Exception {
            List<Long> childIds = this.getAVMChildren(parentId);
            int updatedCount = 0;
            if (childIds.size() > 0) {
                updatedCount = this.updateChildNodeAclIds(sharedAclId, childIds);
                for (Long childId : childIds) {
                    updatedCount += this.setSharedAcls(childId, sharedAclId);
                }
            }
            return updatedCount;
        }

        private int deleteDanglingAcls() throws Exception {
            int batchDeletedCount;
            Long aclId;
            List<Long> nonDanglingAclIds = ResetWCMToGroupBasedPermissionsPatch.this.patchDAO.selectNonDanglingAclIds();
            List<Long> aclIds = ResetWCMToGroupBasedPermissionsPatch.this.patchDAO.selectAllAclIds();
            aclIds.removeAll(nonDanglingAclIds);
            int totalDeletedCount = 0;
            Iterator<Long> aclIdIterator = aclIds.iterator();
            ArrayList<Long> batchAclIds = new ArrayList<Long>(batchSize);
            while (aclIdIterator.hasNext()) {
                aclId = aclIdIterator.next();
                batchAclIds.add(aclId);
                if (batchAclIds.size() != batchSize && aclIdIterator.hasNext()) continue;
                batchDeletedCount = ResetWCMToGroupBasedPermissionsPatch.this.patchDAO.deleteAclMembersForAcls(batchAclIds);
                totalDeletedCount += batchDeletedCount;
                batchAclIds.clear();
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Deleted " + totalDeletedCount + " dangling acl members"));
            }
            totalDeletedCount = 0;
            aclIdIterator = aclIds.iterator();
            batchAclIds = new ArrayList(batchSize);
            while (aclIdIterator.hasNext()) {
                aclId = aclIdIterator.next();
                batchAclIds.add(aclId);
                if (batchAclIds.size() != batchSize && aclIdIterator.hasNext()) continue;
                batchDeletedCount = ResetWCMToGroupBasedPermissionsPatch.this.patchDAO.deleteAcls(batchAclIds);
                totalDeletedCount += batchDeletedCount;
                batchAclIds.clear();
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Deleted " + totalDeletedCount + " dangling acls"));
            }
            return totalDeletedCount;
        }

        private long getAVMStoreCurrentRootNodeId(String avmStoreName) {
            return ResetWCMToGroupBasedPermissionsPatch.this.avmStoreDAO.getStore(avmStoreName).getRootNodeId();
        }

        private List<Long> getAVMChildren(long parentId) {
            List<AVMChildEntryEntity> childEntries = this.getAVMChildrenEntries(parentId);
            ArrayList<Long> childIds = new ArrayList<Long>(childEntries.size());
            for (AVMChildEntryEntity childEntry : childEntries) {
                Long childId = childEntry.getChildId();
                childIds.add(childId);
            }
            return childIds;
        }

        private List<AVMChildEntryEntity> getAVMChildrenEntries(long parentId) {
            return ResetWCMToGroupBasedPermissionsPatch.this.avmNodeLinksDAO.getChildEntriesByParent(parentId, null);
        }

        private long findOrCreateAce(String authorityName, String permissionName) throws Exception {
            Authority authority = ResetWCMToGroupBasedPermissionsPatch.this.aclCrudDAO.getOrCreateAuthority(authorityName);
            QName permissionQName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"cmobject");
            SimplePermissionReference permRef = SimplePermissionReference.getPermissionReference(permissionQName, permissionName);
            Permission permission = ResetWCMToGroupBasedPermissionsPatch.this.aclCrudDAO.getOrCreatePermission(permRef);
            return ResetWCMToGroupBasedPermissionsPatch.this.aclCrudDAO.getOrCreateAce(permission, authority, ACEType.ALL, AccessStatus.ALLOWED).getId();
        }

        private long createAcl(long aclChangeSet, ACLType aclType, boolean requiresVersion) throws Exception {
            AclEntity acl = new AclEntity();
            acl.setAclId(GUID.generate());
            acl.setAclType(aclType);
            acl.setAclVersion(1L);
            switch (aclType) {
                case FIXED: 
                case GLOBAL: {
                    acl.setInherits(Boolean.FALSE);
                }
            }
            acl.setInherits(Boolean.TRUE);
            acl.setLatest(Boolean.TRUE);
            switch (aclType) {
                case OLD: {
                    acl.setVersioned(Boolean.FALSE);
                    break;
                }
                default: {
                    acl.setVersioned(Boolean.TRUE);
                }
            }
            acl.setAclChangeSetId(aclChangeSet);
            acl.setRequiresVersion(requiresVersion);
            return ResetWCMToGroupBasedPermissionsPatch.this.aclCrudDAO.createAcl(acl).getId();
        }

        private void updateAclInheritsFrom(long aclId, long inheritsFromId) throws Exception {
            AclUpdateEntity aclEntity = ResetWCMToGroupBasedPermissionsPatch.this.aclCrudDAO.getAclForUpdate(aclId);
            aclEntity.setInheritsFrom(inheritsFromId);
            ResetWCMToGroupBasedPermissionsPatch.this.aclCrudDAO.updateAcl(aclEntity);
        }

        private void updateAclInherited(long aclId, long inheritedAclId) throws Exception {
            AclUpdateEntity aclEntity = ResetWCMToGroupBasedPermissionsPatch.this.aclCrudDAO.getAclForUpdate(aclId);
            aclEntity.setInheritedAcl(inheritedAclId);
            ResetWCMToGroupBasedPermissionsPatch.this.aclCrudDAO.updateAcl(aclEntity);
        }

        private Long createWCMGroupBasedAcl(String stagingStoreName, long aclChangeSet, ACLType aclType, boolean requiresVersion) throws Exception {
            if (stagingStoreName.contains("--")) {
                throw new AlfrescoRuntimeException("Unexpected staging store name: " + stagingStoreName);
            }
            ArrayList<Long> aceIds = new ArrayList<Long>(5);
            long cmAceId = this.findOrCreateAce("GROUP_" + stagingStoreName + "-" + "ContentManager", "ContentManager");
            long cpAceId = this.findOrCreateAce("GROUP_" + stagingStoreName + "-" + "ContentPublisher", "ContentPublisher");
            long ccAceId = this.findOrCreateAce("GROUP_" + stagingStoreName + "-" + "ContentContributor", "ContentContributor");
            long crAceId = this.findOrCreateAce("GROUP_" + stagingStoreName + "-" + "ContentReviewer", "ContentReviewer");
            long erAceId = this.findOrCreateAce("GROUP_EVERYONE", "Read");
            long aclId = this.createAcl(aclChangeSet, aclType, requiresVersion);
            aceIds.add(cmAceId);
            aceIds.add(cpAceId);
            aceIds.add(ccAceId);
            aceIds.add(crAceId);
            aceIds.add(erAceId);
            ResetWCMToGroupBasedPermissionsPatch.this.aclCrudDAO.addAclMembersToAcl(aclId, aceIds, 0);
            return aclId;
        }
    }
}

