/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.audit;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.WeakHashMap;
import java.util.regex.Pattern;
import org.alfresco.repo.audit.AuditFilter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PropertyAuditFilter
implements AuditFilter {
    private static Log logger = LogFactory.getLog(PropertyAuditFilter.class);
    private static final char NOT = '~';
    private static final char REDIRECT = '$';
    private static final String REG_EXP_SEPARATOR = ";";
    private static final char PROPERTY_SEPARATOR = '.';
    private static final String PROPERY_NAME_PREFIX = "audit.filter";
    private static final char ESCAPE = '\\';
    private static final String ESCAPED_REDIRECT = "\\$";
    private static final String ESCAPED_REG_EXP_SEPARATOR = "\\;";
    private static final String ESCAPED_NOT = "\\~";
    private static final String ENABLED = "enabled";
    private static final String DEFAULT = "default";
    static Map<String, Pattern> patternCache = Collections.synchronizedMap(new WeakHashMap());
    Properties properties;

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    @Override
    public boolean accept(String rootPath, Map<String, Serializable> auditMap) {
        String defaultRootProperty;
        String[] root = this.splitPath(rootPath);
        String rootProperty = this.getPropertyName(PROPERY_NAME_PREFIX, this.getPropertyName(root));
        if ("true".equalsIgnoreCase(this.getProperty(rootProperty, defaultRootProperty = this.getDefaultRootProperty(root), ENABLED))) {
            for (Map.Entry<String, Serializable> entry : auditMap.entrySet()) {
                String[] key;
                String propertyValue;
                String stringValue;
                Object value = entry.getValue();
                if (value == null) {
                    value = "null";
                }
                if (this.acceptValue(stringValue = value instanceof String ? (String)value : value.toString(), propertyValue = this.getProperty(rootProperty, defaultRootProperty, key = this.splitPath(entry.getKey())), rootProperty, key)) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Rejected \n\t            " + rootPath + '/' + entry.getKey() + "=" + stringValue + "\n\t" + this.getPropertyName(rootProperty, this.getPropertyName(key)) + "=" + propertyValue));
                }
                return false;
            }
        }
        return true;
    }

    private boolean acceptValue(String value, String regExpValue, String rootProperty, String ... key) {
        if (regExpValue == null || regExpValue.length() == 0) {
            return true;
        }
        for (String regExp : this.getRegExpList(regExpValue, rootProperty, key)) {
            boolean includeExp;
            boolean bl = includeExp = regExp.charAt(0) != '~';
            if (!includeExp || regExp.startsWith(ESCAPED_NOT)) {
                regExp = regExp.substring(1);
            }
            if (!this.getPattern(regExp).matcher(value).matches()) continue;
            return includeExp;
        }
        return false;
    }

    private Pattern getPattern(String regExp) {
        Pattern pattern = patternCache.get(regExp);
        if (pattern == null) {
            pattern = Pattern.compile(regExp);
            patternCache.put(regExp, pattern);
        }
        return pattern;
    }

    private String getDefaultRootProperty(String[] root) {
        String action = root[root.length - 1];
        root[root.length - 1] = DEFAULT;
        String defaultRootProperty = this.getPropertyName(PROPERY_NAME_PREFIX, this.getPropertyName(root));
        root[root.length - 1] = action;
        return defaultRootProperty;
    }

    private String getProperty(String rootProperty, String defaultRootProperty, String ... keyComponents) {
        String keyName = this.getPropertyName(keyComponents);
        String propertyName = this.getPropertyName(rootProperty, keyName);
        String value = this.getProperty(null, propertyName);
        if (value == null) {
            value = this.getProperty(null, this.getPropertyName(defaultRootProperty, keyName));
        }
        return value;
    }

    private String getProperty(List<String> loopCheck, String propertyName) {
        String value = this.properties.getProperty(propertyName);
        if (value != null && value.length() > 0 && value.charAt(0) == '$') {
            String newPropertyName = value.substring(1);
            if (loopCheck == null) {
                loopCheck = new ArrayList<String>();
            }
            if (loopCheck.contains(newPropertyName)) {
                IllegalArgumentException e = new IllegalArgumentException("Redirected property " + newPropertyName + " referes back to itself.");
                logger.error((Object)"Error found in properties for audit filter.", (Throwable)e);
                throw e;
            }
            loopCheck.add(propertyName);
            value = this.getProperty(loopCheck, newPropertyName);
        } else if (value == null && loopCheck != null && !loopCheck.isEmpty()) {
            IllegalArgumentException e = new IllegalArgumentException("Redirected property " + loopCheck.get(loopCheck.size() - 1) + " points to " + propertyName + " but it does not exist.");
            logger.error((Object)"Error found in properties for audit filter.", (Throwable)e);
            throw e;
        }
        return value;
    }

    private List<String> getRegExpList(String value, String rootProperty, String ... key) {
        ArrayList<String> regExpList = new ArrayList<String>();
        int j = 0;
        int i = j - 1;
        do {
            if ((i = value.indexOf(59, i + 1)) == -1 || i != 0 && value.charAt(i - 1) == '\\') continue;
            regExpList.add(value.substring(j, i));
            j = i + 1;
        } while (i != -1);
        if (j < value.length() - 1) {
            regExpList.add(value.substring(j));
        }
        for (int i2 = regExpList.size() - 1; i2 >= 0; --i2) {
            String regExp = (String)regExpList.get(i2);
            if (regExp.startsWith(ESCAPED_REDIRECT)) {
                regExp = regExp.substring(1);
            }
            if ((regExp = regExp.replaceAll(ESCAPED_REG_EXP_SEPARATOR, REG_EXP_SEPARATOR)).length() == 0 || regExp.charAt(0) == '~' && regExp.length() == 1) {
                throw new IllegalArgumentException(this.getPropertyName(rootProperty, this.getPropertyName(key)) + "=" + value + "includes an empty regular expression.");
            }
            regExpList.set(i2, regExp);
        }
        return regExpList;
    }

    private String getPropertyName(String ... components) {
        StringBuilder sb = new StringBuilder();
        for (String component : components) {
            if (sb.length() > 0) {
                sb.append('.');
            }
            sb.append(component);
        }
        return sb.toString();
    }

    private String[] splitPath(String path) {
        if (path.length() > 0 && path.charAt(0) == '/') {
            path = path.substring(1);
        }
        return path.split("/");
    }
}

