/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.avm.ibatis;

import java.util.ArrayList;
import java.util.List;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.avm.AVMDAOs;
import org.alfresco.repo.avm.AVMNode;
import org.alfresco.repo.avm.ChildEntry;
import org.alfresco.repo.avm.ChildEntryDAO;
import org.alfresco.repo.avm.ChildEntryImpl;
import org.alfresco.repo.avm.ChildKey;
import org.alfresco.repo.avm.DirectoryNode;
import org.alfresco.repo.domain.avm.AVMChildEntryEntity;
import org.springframework.dao.ConcurrencyFailureException;

class ChildEntryDAOIbatis
implements ChildEntryDAO {
    ChildEntryDAOIbatis() {
    }

    @Override
    public void save(ChildEntry entry) {
        AVMDAOs.Instance().newAVMNodeLinksDAO.createChildEntry(entry.getKey().getParent().getId(), entry.getKey().getName(), entry.getChild().getId());
    }

    @Override
    public ChildEntry get(ChildKey key) {
        AVMChildEntryEntity childEntryEntity = AVMDAOs.Instance().newAVMNodeLinksDAO.getChildEntry(key.getParent().getId(), key.getName());
        return this.getChildEntryForParent(key.getParent(), childEntryEntity);
    }

    @Override
    public List<ChildEntry> getByParent(DirectoryNode parent, String childNamePattern) {
        List<AVMChildEntryEntity> childEntryEntities = AVMDAOs.Instance().newAVMNodeLinksDAO.getChildEntriesByParent(parent.getId(), childNamePattern);
        ArrayList<ChildEntry> result = new ArrayList<ChildEntry>(childEntryEntities.size());
        for (AVMChildEntryEntity childEntryEntity : childEntryEntities) {
            result.add(this.getChildEntryForParent(parent, childEntryEntity));
        }
        return result;
    }

    @Override
    public boolean existsParentChild(DirectoryNode parent, AVMNode child) {
        AVMChildEntryEntity childEntryEntity = AVMDAOs.Instance().newAVMNodeLinksDAO.getChildEntry(parent.getId(), child.getId());
        return childEntryEntity != null;
    }

    @Override
    public List<ChildEntry> getByChild(AVMNode child) {
        List<AVMChildEntryEntity> childEntryEntities = AVMDAOs.Instance().newAVMNodeLinksDAO.getChildEntriesByChild(child.getId());
        ArrayList<ChildEntry> result = new ArrayList<ChildEntry>(childEntryEntities.size());
        for (AVMChildEntryEntity childEntryEntity : childEntryEntities) {
            result.add(this.getChildEntryForChild(child, childEntryEntity));
        }
        return result;
    }

    @Override
    public void rename(ChildKey key, String newName) {
        if (!key.getName().equalsIgnoreCase(newName)) {
            throw new AlfrescoRuntimeException("Invalid rename (can only change case");
        }
        AVMChildEntryEntity childEntryEntity = AVMDAOs.Instance().newAVMNodeLinksDAO.getChildEntry(key.getParent().getId(), key.getName());
        childEntryEntity.setName(newName);
        AVMDAOs.Instance().newAVMNodeLinksDAO.updateChildEntry(childEntryEntity);
    }

    @Override
    public void delete(ChildEntry child) {
        AVMChildEntryEntity childEntryEntity = new AVMChildEntryEntity();
        childEntryEntity.setParentNodeId(child.getKey().getParent().getId());
        childEntryEntity.setName(child.getKey().getName());
        childEntryEntity.setChildNodeId(child.getChild().getId());
        AVMDAOs.Instance().newAVMNodeLinksDAO.deleteChildEntry(childEntryEntity);
    }

    @Override
    public void deleteByParent(AVMNode parent) {
        AVMDAOs.Instance().newAVMNodeLinksDAO.deleteChildEntriesByParent(parent.getId());
    }

    @Override
    public void evict(ChildEntry entry) {
    }

    private ChildEntry getChildEntryForParent(DirectoryNode parentNode, AVMChildEntryEntity childEntryEntity) {
        if (childEntryEntity == null) {
            return null;
        }
        AVMNode childNode = AVMDAOs.Instance().fAVMNodeDAO.getByID(childEntryEntity.getChildId());
        if (childNode == null) {
            throw new ConcurrencyFailureException("Child node (" + childEntryEntity.getParentNodeId() + ", " + childEntryEntity.getChildId() + ") no longer exists");
        }
        ChildEntryImpl ce = new ChildEntryImpl(new ChildKey(parentNode, childEntryEntity.getName()), childNode);
        return ce;
    }

    private ChildEntry getChildEntryForChild(AVMNode childNode, AVMChildEntryEntity childEntryEntity) {
        if (childEntryEntity == null) {
            return null;
        }
        DirectoryNode parentNode = (DirectoryNode)AVMDAOs.Instance().fAVMNodeDAO.getByID(childEntryEntity.getParentNodeId());
        if (parentNode == null) {
            throw new ConcurrencyFailureException("Parent node (" + childEntryEntity.getParentNodeId() + ", " + childEntryEntity.getChildId() + ") no longer exists");
        }
        ChildEntryImpl ce = new ChildEntryImpl(new ChildKey(parentNode, childEntryEntity.getName()), childNode);
        return ce;
    }
}

