/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.avm.wf;

import java.util.List;
import org.alfresco.mbeans.VirtServerRegistry;
import org.alfresco.repo.avm.util.RawServices;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.transaction.TransactionListenerAdapter;
import org.alfresco.service.cmr.avmsync.AVMDifference;
import org.alfresco.util.VirtServerUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;

public class AVMSubmitTransactionListener
extends TransactionListenerAdapter {
    private static Log log = LogFactory.getLog(AVMSubmitTransactionListener.class);

    @Override
    public void afterCommit() {
        List stagingDiffs = (List)AlfrescoTransactionSupport.getResource("staging_diffs");
        if (stagingDiffs == null) {
            return;
        }
        AVMDifference requiresUpdate = null;
        for (AVMDifference diff : stagingDiffs) {
            if (requiresUpdate != null || !VirtServerUtils.requiresUpdateNotification((String)diff.getDestinationPath())) continue;
            requiresUpdate = diff;
        }
        ApplicationContext springContext = RawServices.Instance().getContext();
        VirtServerRegistry vServerRegistry = (VirtServerRegistry)springContext.getBean("VirtServerRegistry");
        if (requiresUpdate != null) {
            vServerRegistry.updateAllWebapps(requiresUpdate.getDestinationVersion(), requiresUpdate.getDestinationPath(), true);
            if (log.isDebugEnabled()) {
                log.debug((Object)("JMX update to virt server called after commit.  Version: " + requiresUpdate.getDestinationVersion() + "  Path: " + requiresUpdate.getDestinationPath()));
            }
        }
        AlfrescoTransactionSupport.unbindResource("staging_diffs");
        if (log.isDebugEnabled()) {
            log.debug((Object)"staging_diff resource unbound after commit");
        }
    }

    @Override
    public void afterRollback() {
        AlfrescoTransactionSupport.unbindResource("staging_diffs");
        if (log.isDebugEnabled()) {
            log.debug((Object)"staging_diff resource unbound after rollback");
        }
    }
}

