/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.cache;

import java.io.Serializable;
import java.util.Properties;
import org.alfresco.repo.cache.DefaultSimpleCache;
import org.alfresco.repo.cache.HibernateSimpleCacheAdapter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.cache.Cache;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.CacheProvider;
import org.hibernate.cache.Timestamper;

public class DefaultCacheProvider
implements CacheProvider {
    private static final Log log = LogFactory.getLog(DefaultCacheProvider.class);
    private int defaultMaxItems = 500;

    public Cache buildCache(String regionName, Properties properties) throws CacheException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("building cache for regionName=" + regionName + ", with properties: " + properties));
        }
        DefaultSimpleCache<Serializable, Object> cache = new DefaultSimpleCache<Serializable, Object>();
        cache.setMaxItems(this.defaultMaxItems);
        HibernateSimpleCacheAdapter hibCache = new HibernateSimpleCacheAdapter(cache, regionName);
        return hibCache;
    }

    public long nextTimestamp() {
        return Timestamper.next();
    }

    public void start(Properties properties) throws CacheException {
    }

    public void stop() {
    }

    public boolean isMinimalPutsEnabledByDefault() {
        return false;
    }
}

