/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.config.source;

import java.io.InputStream;
import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.InvalidStoreRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.springframework.extensions.config.ConfigException;
import org.springframework.extensions.config.source.UrlConfigSource;

public class RepoUrlConfigSource
extends UrlConfigSource {
    private TenantService tenantService;
    private SearchService searchService;
    private ContentService contentService;
    private NamespaceService namespaceService;
    private NodeService nodeService;

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public RepoUrlConfigSource(String sourceLocation) {
        super(sourceLocation);
    }

    public RepoUrlConfigSource(List<String> sourceLocations) {
        super(sourceLocations);
    }

    public InputStream getInputStream(String sourceUrl) {
        try {
            return super.getInputStream(sourceUrl);
        }
        catch (ConfigException ce) {
            int idx = sourceUrl.indexOf("://");
            if (idx != -1) {
                int idx2 = sourceUrl.indexOf("/", idx + 3);
                String store = sourceUrl.substring(0, idx2);
                String path = sourceUrl.substring(idx2);
                StoreRef storeRef = this.tenantService.getName(new StoreRef(store));
                NodeRef rootNode = null;
                try {
                    rootNode = this.nodeService.getRootNode(storeRef);
                }
                catch (InvalidStoreRefException e) {
                    throw ce;
                }
                List nodeRefs = this.searchService.selectNodes(rootNode, path, null, (NamespacePrefixResolver)this.namespaceService, false);
                if (nodeRefs.size() == 0) {
                    return null;
                }
                if (nodeRefs.size() > 1) {
                    throw new ConfigException("Found duplicate config sources in the repository " + sourceUrl);
                }
                NodeRef nodeRef = (NodeRef)nodeRefs.get(0);
                ContentReader cr = this.contentService.getReader(nodeRef, ContentModel.PROP_CONTENT);
                return cr.getContentInputStream();
            }
            throw ce;
        }
    }
}

