/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.config.xml;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.cache.SimpleCache;
import org.alfresco.repo.security.authentication.AuthenticationContext;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.tenant.TenantAdminService;
import org.alfresco.repo.tenant.TenantDeployer;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.transaction.TransactionService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.extensions.config.ConfigDeployment;
import org.springframework.extensions.config.ConfigImpl;
import org.springframework.extensions.config.ConfigSection;
import org.springframework.extensions.config.ConfigSource;
import org.springframework.extensions.config.evaluator.Evaluator;
import org.springframework.extensions.config.xml.XMLConfigService;
import org.springframework.extensions.config.xml.elementreader.ConfigElementReader;

public class RepoXMLConfigService
extends XMLConfigService
implements TenantDeployer {
    private static final Log logger = LogFactory.getLog(RepoXMLConfigService.class);
    private ReadWriteLock lock = new ReentrantReadWriteLock();
    private Lock readLock = this.lock.readLock();
    private Lock writeLock = this.lock.writeLock();
    private TransactionService transactionService;
    private AuthenticationContext authenticationContext;
    private TenantAdminService tenantAdminService;
    private SimpleCache<String, ConfigData> configDataCache;
    private ThreadLocal<ConfigData> configDataThreadLocal = new ThreadLocal();

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void setAuthenticationContext(AuthenticationContext authenticationContext) {
        this.authenticationContext = authenticationContext;
    }

    public void setTenantAdminService(TenantAdminService tenantAdminService) {
        this.tenantAdminService = tenantAdminService;
    }

    public void setConfigDataCache(SimpleCache<String, ConfigData> configDataCache) {
        this.configDataCache = configDataCache;
    }

    public RepoXMLConfigService(ConfigSource configSource) {
        super(configSource);
    }

    public List<ConfigDeployment> initConfig() {
        return this.resetRepoConfig().getConfigDeployments();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConfigData initRepoConfig(final String tenantDomain) {
        ConfigData configData;
        String currentUser = this.authenticationContext.getCurrentUserName();
        if (currentUser == null) {
            this.authenticationContext.setSystemUserAsCurrentUser();
        }
        try {
            configData = this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<ConfigData>(){

                @Override
                public ConfigData execute() throws Throwable {
                    List configDeployments = RepoXMLConfigService.super.initConfig();
                    ConfigData configData = RepoXMLConfigService.this.getConfigDataLocal(tenantDomain);
                    if (configData != null) {
                        configData.setConfigDeployments(configDeployments);
                    }
                    return configData;
                }
            }, this.transactionService.isReadOnly());
            logger.info((Object)"Config initialised");
        }
        finally {
            if (currentUser == null) {
                this.authenticationContext.clearCurrentSecurityContext();
            }
        }
        return configData;
    }

    public void destroy() {
        super.destroy();
        logger.info((Object)"Config destroyed");
    }

    public void reset() {
        this.resetRepoConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConfigData resetRepoConfig() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Resetting repo config service");
        }
        String tenantDomain = this.getTenantDomain();
        try {
            this.destroy();
            ConfigData configData = this.getConfigDataLocal(tenantDomain);
            if (configData == null) {
                configData = new ConfigData(tenantDomain);
                this.configDataThreadLocal.set(configData);
            }
            if ((configData = this.initRepoConfig(tenantDomain)) == null) {
                throw new AlfrescoRuntimeException("Failed to reset configData " + tenantDomain);
            }
            try {
                this.writeLock.lock();
                this.configDataCache.put((Serializable)((Object)tenantDomain), (Object)configData);
            }
            finally {
                this.writeLock.unlock();
            }
            ConfigData configData2 = configData;
            return configData2;
        }
        finally {
            try {
                this.readLock.lock();
                if (this.configDataCache.get((Serializable)((Object)tenantDomain)) != null) {
                    this.configDataThreadLocal.set(null);
                }
            }
            finally {
                this.readLock.unlock();
            }
        }
    }

    protected void onBootstrap(ApplicationEvent event) {
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

            public Object doWork() {
                RepoXMLConfigService.this.initConfig();
                return null;
            }
        }, (String)AuthenticationUtil.getSystemUserName());
        if (this.tenantAdminService != null && this.tenantAdminService.isEnabled()) {
            this.tenantAdminService.deployTenants(this, logger);
            this.tenantAdminService.register(this);
        }
    }

    protected void onShutdown(ApplicationEvent event) {
    }

    public void onEnableTenant() {
        this.initConfig();
    }

    public void onDisableTenant() {
        this.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConfigData getConfigData() {
        String tenantDomain = this.getTenantDomain();
        ConfigData configData = this.getConfigDataLocal(tenantDomain);
        if (configData != null) {
            return configData;
        }
        try {
            this.readLock.lock();
            configData = (ConfigData)this.configDataCache.get((Serializable)((Object)tenantDomain));
            if (configData != null) {
                ConfigData configData2 = configData;
                return configData2;
            }
        }
        finally {
            this.readLock.unlock();
        }
        configData = this.resetRepoConfig();
        if (configData == null) {
            throw new AlfrescoRuntimeException("Failed to get configData " + tenantDomain);
        }
        return configData;
    }

    private ConfigData getConfigDataLocal(String tenantDomain) {
        ConfigData configData = this.configDataThreadLocal.get();
        if (configData != null && tenantDomain.equals(configData.getTenantDomain())) {
            return configData;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeConfigData() {
        try {
            this.writeLock.lock();
            String tenantDomain = this.getTenantDomain();
            if (this.configDataCache.get((Serializable)((Object)tenantDomain)) != null) {
                this.configDataCache.remove((Serializable)((Object)tenantDomain));
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    protected ConfigImpl getGlobalConfigImpl() {
        return this.getConfigData().getGlobalConfig();
    }

    protected void putGlobalConfig(ConfigImpl globalConfig) {
        this.getConfigData().setGlobalConfig(globalConfig);
    }

    protected void removeGlobalConfig() {
        this.removeConfigData();
    }

    protected Map<String, Evaluator> getEvaluators() {
        return this.getConfigData().getEvaluators();
    }

    protected void putEvaluators(Map<String, Evaluator> evaluators) {
        this.getConfigData().setEvaluators(evaluators);
    }

    protected void removeEvaluators() {
        this.removeConfigData();
    }

    public Map<String, List<ConfigSection>> getSectionsByArea() {
        return this.getConfigData().getSectionsByArea();
    }

    protected void putSectionsByArea(Map<String, List<ConfigSection>> sectionsByArea) {
        this.getConfigData().setSectionsByArea(sectionsByArea);
    }

    protected void removeSectionsByArea() {
        this.removeConfigData();
    }

    public List<ConfigSection> getSections() {
        return this.getConfigData().getSections();
    }

    protected void putSections(List<ConfigSection> sections) {
        this.getConfigData().setSections(sections);
    }

    protected void removeSections() {
        this.removeConfigData();
    }

    protected Map<String, ConfigElementReader> getElementReaders() {
        return this.getConfigData().getElementReaders();
    }

    protected void putElementReaders(Map<String, ConfigElementReader> elementReaders) {
        this.getConfigData().setElementReaders(elementReaders);
    }

    protected void removeElementReaders() {
        this.removeConfigData();
    }

    private String getTenantDomain() {
        return this.tenantAdminService.getCurrentUserDomain();
    }

    private static class ConfigData {
        private ConfigImpl globalConfig;
        private Map<String, Evaluator> evaluators;
        private Map<String, List<ConfigSection>> sectionsByArea;
        private List<ConfigSection> sections;
        private Map<String, ConfigElementReader> elementReaders;
        private List<ConfigDeployment> configDeployments;
        private String tenantDomain;

        public ConfigData(String tenantDomain) {
            this.tenantDomain = tenantDomain;
        }

        public String getTenantDomain() {
            return this.tenantDomain;
        }

        public ConfigImpl getGlobalConfig() {
            return this.globalConfig;
        }

        public void setGlobalConfig(ConfigImpl globalConfig) {
            this.globalConfig = globalConfig;
        }

        public Map<String, Evaluator> getEvaluators() {
            return this.evaluators;
        }

        public void setEvaluators(Map<String, Evaluator> evaluators) {
            this.evaluators = evaluators;
        }

        public Map<String, List<ConfigSection>> getSectionsByArea() {
            return this.sectionsByArea;
        }

        public void setSectionsByArea(Map<String, List<ConfigSection>> sectionsByArea) {
            this.sectionsByArea = sectionsByArea;
        }

        public List<ConfigSection> getSections() {
            return this.sections;
        }

        public void setSections(List<ConfigSection> sections) {
            this.sections = sections;
        }

        public Map<String, ConfigElementReader> getElementReaders() {
            return this.elementReaders;
        }

        public void setElementReaders(Map<String, ConfigElementReader> elementReaders) {
            this.elementReaders = elementReaders;
        }

        public List<ConfigDeployment> getConfigDeployments() {
            return this.configDeployments;
        }

        public void setConfigDeployments(List<ConfigDeployment> configDeployments) {
            this.configDeployments = configDeployments;
        }
    }
}

