/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content;

import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.List;
import java.util.Locale;
import org.alfresco.error.StackTraceUtil;
import org.alfresco.service.cmr.repository.ContentAccessor;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.ContentIOException;
import org.alfresco.service.cmr.repository.ContentStreamListener;
import org.alfresco.util.ParameterCheck;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.AfterReturningAdvice;
import org.springframework.extensions.surf.util.I18NUtil;

public abstract class AbstractContentAccessor
implements ContentAccessor {
    private static Log logger = LogFactory.getLog(AbstractContentAccessor.class);
    private static final Log loggerTrace = LogFactory.getLog((String)(AbstractContentAccessor.class.getName() + ".trace"));
    private StackTraceElement[] traceLoggerChannelAssignTrace;
    private String contentUrl;
    private String mimetype;
    private String encoding;
    private Locale locale;

    protected AbstractContentAccessor(String contentUrl) {
        ParameterCheck.mandatoryString((String)"contentUrl", (String)contentUrl);
        if (contentUrl == null || contentUrl.length() == 0) {
            throw new IllegalArgumentException("contentUrl is invalid:" + contentUrl);
        }
        this.contentUrl = contentUrl;
        this.encoding = "UTF-8";
        this.locale = I18NUtil.getLocale();
    }

    protected void finalize() throws Throwable {
        if (loggerTrace.isDebugEnabled() && this.traceLoggerChannelAssignTrace != null && this.isChannelOpen()) {
            StringBuilder sb = new StringBuilder(1024);
            StackTraceUtil.buildStackTrace((String)("Content IO Channel was opened but not closed: \n" + this), (StackTraceElement[])this.traceLoggerChannelAssignTrace, (StringBuilder)sb, (int)-1);
            loggerTrace.error((Object)sb);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(100);
        sb.append("ContentAccessor").append("[ contentUrl=").append(this.getContentUrl()).append(", mimetype=").append(this.getMimetype()).append(", size=").append(this.getSize()).append(", encoding=").append(this.getEncoding()).append(", locale=").append(this.getLocale()).append("]");
        return sb.toString();
    }

    public ContentData getContentData() {
        ContentData property = new ContentData(this.contentUrl, this.mimetype, this.getSize(), this.encoding, this.locale);
        return property;
    }

    protected final void channelOpened() {
        if (loggerTrace.isDebugEnabled()) {
            Exception e = new Exception();
            e.fillInStackTrace();
            this.traceLoggerChannelAssignTrace = e.getStackTrace();
        }
    }

    public String getContentUrl() {
        return this.contentUrl;
    }

    protected void setContentUrl(String contentUrl) {
        ParameterCheck.mandatoryString((String)"contentUrl", (String)contentUrl);
        this.contentUrl = contentUrl;
    }

    public String getMimetype() {
        return this.mimetype;
    }

    public void setMimetype(String mimetype) {
        this.mimetype = mimetype;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    protected FileChannel getCallbackFileChannel(FileChannel directChannel, List<ContentStreamListener> listeners) throws ContentIOException {
        CallbackFileChannel ret = new CallbackFileChannel(directChannel, listeners);
        return ret;
    }

    static {
        if (loggerTrace.isDebugEnabled()) {
            loggerTrace.warn((Object)"Trace channel assignment logging is on and will affect performance");
        }
    }

    protected class CallbackFileChannel
    extends FileChannel {
        private FileChannel delegate;
        private List<ContentStreamListener> listeners;

        public CallbackFileChannel(FileChannel delegate, List<ContentStreamListener> listeners) {
            if (delegate == null) {
                throw new IllegalArgumentException("FileChannel delegate is required");
            }
            if (delegate instanceof CallbackFileChannel) {
                throw new IllegalArgumentException("FileChannel delegate may not be a CallbackFileChannel");
            }
            this.delegate = delegate;
            this.listeners = listeners;
        }

        @Override
        protected void implCloseChannel() throws IOException {
            this.delegate.close();
            this.fireChannelClosed();
        }

        private void fireChannelClosed() {
            if (this.listeners.size() == 0) {
                return;
            }
            for (ContentStreamListener listener : this.listeners) {
                listener.contentStreamClosed();
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("" + this.listeners.size() + " content listeners called: close"));
            }
        }

        @Override
        public void force(boolean metaData) throws IOException {
            this.delegate.force(metaData);
        }

        @Override
        public FileLock lock(long position, long size, boolean shared) throws IOException {
            return this.delegate.lock(position, size, shared);
        }

        @Override
        public MappedByteBuffer map(FileChannel.MapMode mode, long position, long size) throws IOException {
            return this.delegate.map(mode, position, size);
        }

        @Override
        public long position() throws IOException {
            return this.delegate.position();
        }

        @Override
        public FileChannel position(long newPosition) throws IOException {
            return this.delegate.position(newPosition);
        }

        @Override
        public int read(ByteBuffer dst) throws IOException {
            return this.delegate.read(dst);
        }

        @Override
        public int read(ByteBuffer dst, long position) throws IOException {
            return this.delegate.read(dst, position);
        }

        @Override
        public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
            return this.delegate.read(dsts, offset, length);
        }

        @Override
        public long size() throws IOException {
            return this.delegate.size();
        }

        @Override
        public long transferFrom(ReadableByteChannel src, long position, long count) throws IOException {
            return this.delegate.transferFrom(src, position, count);
        }

        @Override
        public long transferTo(long position, long count, WritableByteChannel target) throws IOException {
            return this.delegate.transferTo(position, count, target);
        }

        @Override
        public FileChannel truncate(long size) throws IOException {
            return this.delegate.truncate(size);
        }

        @Override
        public FileLock tryLock(long position, long size, boolean shared) throws IOException {
            return this.delegate.tryLock(position, size, shared);
        }

        @Override
        public int write(ByteBuffer src) throws IOException {
            return this.delegate.write(src);
        }

        @Override
        public int write(ByteBuffer src, long position) throws IOException {
            return this.delegate.write(src, position);
        }

        @Override
        public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
            return this.delegate.write(srcs, offset, length);
        }
    }

    protected class ChannelCloseCallbackAdvise
    implements AfterReturningAdvice {
        private List<ContentStreamListener> listeners;

        public ChannelCloseCallbackAdvise(List<ContentStreamListener> listeners) {
            this.listeners = listeners;
        }

        public void afterReturning(Object returnValue, Method method, Object[] args, Object target) throws Throwable {
            if (method.getName().equals("close")) {
                this.fireChannelClosed();
            }
        }

        private void fireChannelClosed() {
            if (this.listeners.size() == 0) {
                return;
            }
            for (ContentStreamListener listener : this.listeners) {
                listener.contentStreamClosed();
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("" + this.listeners.size() + " content listeners called: close"));
            }
        }
    }
}

