/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content;

import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.HashSet;
import javax.transaction.UserTransaction;
import junit.framework.TestCase;
import org.alfresco.repo.content.ContentStore;
import org.alfresco.repo.content.UnsupportedContentUrlException;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;

public abstract class AbstractReadOnlyContentStoreTest
extends TestCase {
    protected static final ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
    private static Log logger = LogFactory.getLog(AbstractReadOnlyContentStoreTest.class);
    protected TransactionService transactionService;
    private UserTransaction txn;

    public void setUp() throws Exception {
        this.transactionService = (TransactionService)ctx.getBean("TransactionService");
        this.txn = this.transactionService.getUserTransaction();
        this.txn.begin();
    }

    public void tearDown() throws Exception {
        try {
            this.txn.rollback();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    protected abstract ContentStore getStore();

    protected final ContentReader getReader(String contentUrl) {
        return this.getStore().getReader(contentUrl);
    }

    protected String getExistingContentUrl() {
        ContentStore store = this.getStore();
        try {
            final HashSet contentUrls = new HashSet(5);
            ContentStore.ContentUrlHandler handler = new ContentStore.ContentUrlHandler(){

                @Override
                public void handle(String contentUrl) {
                    if (contentUrls.size() < 50) {
                        contentUrls.add(contentUrl);
                    }
                }
            };
            store.getUrls(handler);
            if (contentUrls.size() > 0) {
                return (String)contentUrls.toArray()[0];
            }
            return null;
        }
        catch (UnsupportedOperationException e) {
            return null;
        }
    }

    public void testSetUp() throws Exception {
        ContentStore store = this.getStore();
        AbstractReadOnlyContentStoreTest.assertNotNull((String)"No store provided", (Object)store);
        AbstractReadOnlyContentStoreTest.assertTrue((String)"The same instance of the store must be returned for getStore", (store == this.getStore() ? 1 : 0) != 0);
    }

    private void checkIllegalReadContentUrl(ContentStore store, String contentUrl) {
        AbstractReadOnlyContentStoreTest.assertFalse((String)"This check is for unsupported content URLs only", (boolean)store.isContentUrlSupported(contentUrl));
        try {
            store.getReader(contentUrl);
            AbstractReadOnlyContentStoreTest.fail((String)("Expected UnsupportedContentUrlException for getReader(), but got nothing: " + contentUrl));
        }
        catch (UnsupportedContentUrlException e) {
            // empty catch block
        }
        try {
            store.exists(contentUrl);
            AbstractReadOnlyContentStoreTest.fail((String)("Expected UnsupportedContentUrlException for exists(), but got nothing: " + contentUrl));
        }
        catch (UnsupportedContentUrlException unsupportedContentUrlException) {
            // empty catch block
        }
    }

    public void testIllegalReadableContentUrls() {
        ContentStore store = this.getStore();
        this.checkIllegalReadContentUrl(store, "://bogus");
        this.checkIllegalReadContentUrl(store, "bogus://");
        this.checkIllegalReadContentUrl(store, "bogus://bogus");
    }

    public void testGetReaderForExistingContentUrl() throws Exception {
        ContentStore store = this.getStore();
        String contentUrl = this.getExistingContentUrl();
        if (contentUrl == null) {
            logger.warn((Object)("Store test " + this.getName() + " not possible on " + store.getClass().getName()));
            return;
        }
        AbstractReadOnlyContentStoreTest.assertTrue((String)"URL returned in set seems to no longer exist", (boolean)store.exists(contentUrl));
        ContentReader reader = store.getReader(contentUrl);
        AbstractReadOnlyContentStoreTest.assertNotNull((String)"Reader should never be null", (Object)reader);
        AbstractReadOnlyContentStoreTest.assertTrue((String)"Reader says content doesn't exist", (boolean)reader.exists());
        AbstractReadOnlyContentStoreTest.assertFalse((String)"Reader should not be closed before a read", (boolean)reader.isClosed());
        AbstractReadOnlyContentStoreTest.assertFalse((String)"The reader channel should not be open yet", (boolean)reader.isChannelOpen());
        ReadableByteChannel readChannel = reader.getReadableChannel();
        readChannel.read(ByteBuffer.wrap(new byte[500]));
        AbstractReadOnlyContentStoreTest.assertFalse((String)"Reader should not be closed during a read", (boolean)reader.isClosed());
        AbstractReadOnlyContentStoreTest.assertTrue((String)"The reader channel should be open during a read", (boolean)reader.isChannelOpen());
        readChannel.close();
        AbstractReadOnlyContentStoreTest.assertTrue((String)"Reader should be closed after a read", (boolean)reader.isClosed());
        AbstractReadOnlyContentStoreTest.assertFalse((String)"The reader channel should be closed after a read", (boolean)reader.isChannelOpen());
    }

    public void testRandomAccessRead() throws Exception {
        ContentStore store = this.getStore();
        String contentUrl = this.getExistingContentUrl();
        if (contentUrl == null) {
            logger.warn((Object)("Store test " + this.getName() + " not possible on " + store.getClass().getName()));
            return;
        }
        ContentReader reader = store.getReader(contentUrl);
        AbstractReadOnlyContentStoreTest.assertNotNull((String)"Reader should never be null", (Object)reader);
        FileChannel fileChannel = reader.getFileChannel();
        AbstractReadOnlyContentStoreTest.assertNotNull((String)"No channel given", (Object)fileChannel);
        try {
            reader.getReadableChannel();
            AbstractReadOnlyContentStoreTest.fail((String)"Second channel access allowed");
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        fileChannel.close();
    }

    public void testBlockedWriteOperations() throws Exception {
        ContentStore store = this.getStore();
        if (store.isWriteSupported()) {
            return;
        }
        try {
            store.getWriter(ContentStore.NEW_CONTENT_CONTEXT);
            AbstractReadOnlyContentStoreTest.fail((String)("Read-only store provided a writer: " + store));
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
        String contentUrl = this.getExistingContentUrl();
        if (contentUrl == null) {
            logger.warn((Object)("Store test " + this.getName() + " not possible on " + store.getClass().getName()));
            return;
        }
        try {
            store.delete(contentUrl);
            AbstractReadOnlyContentStoreTest.fail((String)("Read-only store allowed deletion: " + store));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }
}

