/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import org.alfresco.repo.content.ContentLimitViolationException;
import org.alfresco.repo.content.LimitedStreamCopier;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LimitedStreamCopierTest {
    private static final byte[] ZERO_BYTE_ARRAY = "".getBytes();
    private static final byte[] SHORT_BYTE_ARRAY = "This string is shorter than the limit".getBytes();
    private static final byte[] LIMIT_SIZED_BYTE_ARRAY = "This string's length exactly equals the limit".getBytes();
    private static final byte[] LONG_BYTE_ARRAY = "This test string is longer than the limit. Tum te tum te tum te tum.".getBytes();
    private static final int SIZE_LIMIT = LIMIT_SIZED_BYTE_ARRAY.length;
    private LimitedStreamCopier streamCopier = new LimitedStreamCopier();
    private InputStream in;
    private ByteArrayOutputStream out;

    @Before
    public void initStreamCopier() {
        this.out = new ByteArrayOutputStream();
    }

    @Test
    public void copyStreamSuccessful() throws Exception {
        this.in = new ByteArrayInputStream(SHORT_BYTE_ARRAY);
        int bytesCopied = this.streamCopier.copyStreams(this.in, this.out, SIZE_LIMIT);
        Assert.assertArrayEquals((byte[])SHORT_BYTE_ARRAY, (byte[])this.out.toByteArray());
        Assert.assertEquals((long)SHORT_BYTE_ARRAY.length, (long)bytesCopied);
    }

    @Test
    public void copyStreamSuccessfulZeroBytes() throws Exception {
        this.in = new ByteArrayInputStream(ZERO_BYTE_ARRAY);
        int bytesCopied = this.streamCopier.copyStreams(this.in, this.out, SIZE_LIMIT);
        Assert.assertArrayEquals((byte[])ZERO_BYTE_ARRAY, (byte[])this.out.toByteArray());
        Assert.assertEquals((long)ZERO_BYTE_ARRAY.length, (long)bytesCopied);
    }

    @Test(expected=ContentLimitViolationException.class)
    public void copyStreamUnsuccessfulLimitExceeded() throws Exception {
        this.in = new ByteArrayInputStream(LONG_BYTE_ARRAY);
        int bytesCopied = this.streamCopier.copyStreams(this.in, this.out, SIZE_LIMIT);
        Assert.assertArrayEquals((byte[])LONG_BYTE_ARRAY, (byte[])this.out.toByteArray());
        Assert.assertEquals((long)LONG_BYTE_ARRAY.length, (long)bytesCopied);
    }

    @Test
    public void copyStreamSuccessfulLimitHit() throws Exception {
        this.in = new ByteArrayInputStream(LIMIT_SIZED_BYTE_ARRAY);
        int bytesCopied = this.streamCopier.copyStreams(this.in, this.out, SIZE_LIMIT);
        Assert.assertArrayEquals((byte[])LIMIT_SIZED_BYTE_ARRAY, (byte[])this.out.toByteArray());
        Assert.assertEquals((long)LIMIT_SIZED_BYTE_ARRAY.length, (long)bytesCopied);
    }

    @Test
    public void copyStreamSuccessfulBecauseLimitNotImposed() throws Exception {
        this.in = new ByteArrayInputStream(LONG_BYTE_ARRAY);
        int bytesCopied = this.streamCopier.copyStreams(this.in, this.out, -1L);
        Assert.assertArrayEquals((byte[])LONG_BYTE_ARRAY, (byte[])this.out.toByteArray());
        Assert.assertEquals((long)LONG_BYTE_ARRAY.length, (long)bytesCopied);
    }
}

