/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.metadata;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.content.metadata.MetadataExtracter;
import org.alfresco.repo.content.metadata.MetadataExtracterRegistry;
import org.alfresco.service.cmr.repository.ContentIOException;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.MimetypeService;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractMetadataExtracter
implements MetadataExtracter {
    protected static Log logger = LogFactory.getLog(AbstractMetadataExtracter.class);
    private MimetypeService mimetypeService;
    private MetadataExtracterRegistry registry;
    private Set<String> supportedMimetypes;
    private double reliability;
    private long extractionTime;

    protected AbstractMetadataExtracter(String supportedMimetype, double reliability, long extractionTime) {
        this.supportedMimetypes = Collections.singleton(supportedMimetype);
        this.reliability = reliability;
        this.extractionTime = extractionTime;
    }

    protected AbstractMetadataExtracter(Set<String> supportedMimetypes, double reliability, long extractionTime) {
        this.supportedMimetypes = supportedMimetypes;
        this.reliability = reliability;
        this.extractionTime = extractionTime;
    }

    public void setRegistry(MetadataExtracterRegistry registry) {
        this.registry = registry;
    }

    public void setMimetypeService(MimetypeService mimetypeService) {
        this.mimetypeService = mimetypeService;
    }

    protected MimetypeService getMimetypeService() {
        return this.mimetypeService;
    }

    public void register() {
        if (this.registry == null) {
            logger.warn((Object)("Property 'registry' has not been set.  Ignoring auto-registration: \n   extracter: " + this));
            return;
        }
        this.registry.register(this);
    }

    @Override
    public double getReliability(String mimetype) {
        if (this.supportedMimetypes.contains(mimetype)) {
            return this.reliability;
        }
        return 0.0;
    }

    @Override
    public boolean isSupported(String mimetype) {
        double reliability = this.getReliability(mimetype);
        return reliability > 0.0;
    }

    @Override
    public long getExtractionTime() {
        return this.extractionTime;
    }

    protected void checkReliability(ContentReader reader) {
        String mimetype = reader.getMimetype();
        if (this.getReliability(mimetype) <= 0.0) {
            throw new AlfrescoRuntimeException("Metadata extracter does not support mimetype: \n   reader: " + reader + "\n" + "   supported: " + this.supportedMimetypes + "\n" + "   extracter: " + this);
        }
    }

    @Override
    public Map<QName, Serializable> extract(ContentReader reader, Map<QName, Serializable> destination) {
        return this.extract(reader, MetadataExtracter.OverwritePolicy.PRAGMATIC, destination);
    }

    @Override
    public final Map<QName, Serializable> extract(ContentReader reader, MetadataExtracter.OverwritePolicy overwritePolicy, Map<QName, Serializable> destination) throws ContentIOException {
        this.checkReliability(reader);
        HashMap<QName, Serializable> newProperties = new HashMap<QName, Serializable>(13);
        try {
            this.extractInternal(reader, newProperties);
            Map<QName, Serializable> modifiedProperties = overwritePolicy.applyProperties(newProperties, destination);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Completed metadata extraction: \n   reader: " + reader + "\n" + "   extracter: " + this));
            }
            Map<QName, Serializable> map = modifiedProperties;
            return map;
        }
        catch (Throwable e) {
            throw new ContentIOException("Metadata extraction failed: \n   reader: " + reader, e);
        }
        finally {
            if (reader.isChannelOpen()) {
                logger.error((Object)("Content reader not closed by metadata extracter: \n   reader: " + reader + "\n" + "   extracter: " + this));
            }
        }
    }

    @Override
    public final Map<QName, Serializable> extract(ContentReader reader, MetadataExtracter.OverwritePolicy overwritePolicy, Map<QName, Serializable> destination, Map<String, Set<QName>> propertyMapping) throws ContentIOException {
        return this.extract(reader, destination);
    }

    protected abstract void extractInternal(ContentReader var1, Map<QName, Serializable> var2) throws Throwable;

    protected boolean trimPut(QName prop, Object value, Map<QName, Serializable> destination) {
        if (value == null) {
            return false;
        }
        if (value instanceof String) {
            String svalue = ((String)value).trim();
            if (svalue.length() > 0) {
                destination.put(prop, (Serializable)((Object)svalue));
                return true;
            }
            return false;
        }
        if (value instanceof Serializable) {
            destination.put(prop, (Serializable)value);
        } else {
            destination.put(prop, (Serializable)((Object)value.toString()));
        }
        return true;
    }
}

