/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.transform;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.content.transform.ContentTransformer;
import org.alfresco.repo.content.transform.ContentTransformerRegistry;
import org.alfresco.service.cmr.repository.ContentAccessor;
import org.alfresco.service.cmr.repository.ContentIOException;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.MimetypeService;
import org.alfresco.service.cmr.repository.TransformationOptions;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.ParameterCheck;

@Deprecated
public abstract class AbstractContentTransformer
implements ContentTransformer {
    private static final Log logger = LogFactory.getLog(AbstractContentTransformer.class);
    private MimetypeService mimetypeService;
    private ContentTransformerRegistry registry;
    private List<ContentTransformerRegistry.TransformationKey> explicitTransformations = new ArrayList<ContentTransformerRegistry.TransformationKey>(0);
    private double averageTime = 0.0;
    private long count = 0L;

    protected AbstractContentTransformer() {
    }

    public void setRegistry(ContentTransformerRegistry registry) {
        this.registry = registry;
    }

    public void setMimetypeService(MimetypeService mimetypeService) {
        this.mimetypeService = mimetypeService;
    }

    protected MimetypeService getMimetypeService() {
        return this.mimetypeService;
    }

    protected List<ContentTransformerRegistry.TransformationKey> getExplicitTransformations() {
        return this.explicitTransformations;
    }

    public void setExplicitTransformations(List<ContentTransformerRegistry.TransformationKey> explicitTransformations) {
        this.explicitTransformations = explicitTransformations;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("[ average=").append((long)this.averageTime).append("ms").append("]");
        return sb.toString();
    }

    public void register() {
        if (this.registry == null) {
            logger.warn((Object)("Property 'registry' has not been set.  Ignoring auto-registration: \n   transformer: " + this));
            return;
        }
        this.registry.addTransformer(this);
    }

    protected String getMimetype(ContentAccessor content) {
        String mimetype = content.getMimetype();
        if (mimetype == null) {
            throw new AlfrescoRuntimeException("Mimetype is mandatory for transformation: " + content);
        }
        return mimetype;
    }

    protected abstract double getReliability(String var1, String var2);

    protected void checkReliability(ContentReader reader, ContentWriter writer) {
        String targetMimetype;
        String sourceMimetype = this.getMimetype((ContentAccessor)reader);
        double reliability = this.getReliability(sourceMimetype, targetMimetype = this.getMimetype((ContentAccessor)writer));
        if (reliability <= 0.0) {
            throw new AlfrescoRuntimeException("Zero scoring transformation attempted: \n   reader: " + reader + "\n" + "   writer: " + writer);
        }
    }

    @Override
    public boolean isTransformable(String sourceMimetype, long sourceSize, String targetMimetype, TransformationOptions options) {
        return this.isTransformableMimetype(sourceMimetype, targetMimetype, options) && this.isTransformableSize(sourceMimetype, sourceSize, targetMimetype, options);
    }

    @Override
    public boolean isTransformable(String sourceMimetype, String targetMimetype, TransformationOptions options) {
        ParameterCheck.mandatoryString((String)"sourceMimetype", (String)sourceMimetype);
        ParameterCheck.mandatoryString((String)"targetMimetype", (String)targetMimetype);
        double reliability = this.getReliability(sourceMimetype, targetMimetype);
        boolean result = true;
        if (reliability <= 0.0) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean isTransformableMimetype(String sourceMimetype, String targetMimetype, TransformationOptions options) {
        return this.isTransformable(sourceMimetype, targetMimetype, options);
    }

    @Override
    public boolean isTransformableSize(String sourceMimetype, long sourceSize, String targetMimetype, TransformationOptions options) {
        return true;
    }

    @Override
    public long getMaxSourceSizeKBytes(String sourceMimetype, String targetMimetype, TransformationOptions options) {
        return -1L;
    }

    @Override
    public boolean isExplicitTransformation(String sourceMimetype, String targetMimetype, TransformationOptions options) {
        boolean result = false;
        if (this.explicitTransformations != null) {
            for (ContentTransformerRegistry.TransformationKey transformationKey : this.explicitTransformations) {
                if (!transformationKey.getSourceMimetype().equals(sourceMimetype) || !transformationKey.getTargetMimetype().equals(targetMimetype)) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    protected abstract void transformInternal(ContentReader var1, ContentWriter var2, Map<String, Object> var3) throws Exception;

    @Override
    public final void transform(ContentReader reader, ContentWriter writer) throws ContentIOException {
        Map<String, Object> optionsMap = null;
        this.transform(reader, writer, optionsMap);
    }

    @Override
    public final void transform(ContentReader reader, ContentWriter writer, TransformationOptions options) throws ContentIOException {
        Map<String, Object> optionsMap = options.toMap();
        this.transform(reader, writer, optionsMap);
    }

    @Override
    public final void transform(ContentReader reader, ContentWriter writer, Map<String, Object> options) throws ContentIOException {
        long before = System.currentTimeMillis();
        if (options == null) {
            options = Collections.emptyMap();
        }
        try {
            this.checkReliability(reader, writer);
            this.transformInternal(reader, writer, options);
        }
        catch (Throwable e) {
            this.recordTime(10000L);
            throw new ContentIOException("Content conversion failed: \n   reader: " + reader + "\n" + "   writer: " + writer + "\n" + "   options: " + options, e);
        }
        finally {
            if (reader.isChannelOpen()) {
                logger.error((Object)("Content reader not closed by transformer: \n   reader: " + reader + "\n" + "   transformer: " + this));
            }
            if (writer.isChannelOpen()) {
                logger.error((Object)("Content writer not closed by transformer: \n   writer: " + writer + "\n" + "   transformer: " + this));
            }
        }
        long after = System.currentTimeMillis();
        this.recordTime(after - before);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Completed transformation: \n   reader: " + reader + "\n" + "   writer: " + writer + "\n" + "   options: " + options + "\n" + "   transformer: " + this));
        }
    }

    @Override
    public synchronized long getTransformationTime() {
        return (long)this.averageTime;
    }

    protected final synchronized void recordTime(long transformationTime) {
        if (this.count == Long.MAX_VALUE) {
            this.count /= 2L;
        }
        ++this.count;
        double diffTime = (double)transformationTime - this.averageTime;
        this.averageTime += diffTime / (double)this.count;
    }
}

