/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.transform;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import org.alfresco.repo.content.filestore.FileContentReader;
import org.alfresco.repo.content.filestore.FileContentWriter;
import org.alfresco.repo.content.transform.AbstractContentTransformerTest;
import org.alfresco.repo.content.transform.ContentTransformer;
import org.alfresco.repo.content.transform.MediaWikiContentTransformer;
import org.alfresco.service.cmr.repository.TransformationOptions;
import org.alfresco.util.TempFileProvider;

public class MediaWikiContentTransformerTest
extends AbstractContentTransformerTest {
    private MediaWikiContentTransformer transformer;
    private static final String WIKI_TEXT = "== This is a title ==\n\n'''This is bold'''  and some ''italics on the same line''\n\nHere is a link to the main page .... [[Main Page]]\n\n*and\n*what\n*about\n*a list\n\n  Some indented text that should apear different\n\nWhat about an external link [http://www.alfresco.com Alfresco]\n\n<nowiki>This markup should be ignored [[Main Page]]</nowiki>\n\n----\n\nLets put some text at the end :)\n";

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.transformer = new MediaWikiContentTransformer();
        this.transformer.setMimetypeService(this.mimetypeService);
        this.transformer.setTransformerDebug(this.transformerDebug);
    }

    @Override
    protected ContentTransformer getTransformer(String sourceMimetype, String targetMimetype) {
        return this.transformer;
    }

    @Override
    public void testSetUp() throws Exception {
        MediaWikiContentTransformerTest.assertNotNull((Object)this.transformer);
    }

    public void testIsTransformable() throws Exception {
        MediaWikiContentTransformerTest.assertTrue((boolean)this.transformer.isTransformable("text/mediawiki", -1L, "text/html", new TransformationOptions()));
        MediaWikiContentTransformerTest.assertFalse((boolean)this.transformer.isTransformable("text/html", -1L, "text/mediawiki", new TransformationOptions()));
    }

    public void testMediaWikiToHTML() throws Exception {
        File input = TempFileProvider.createTempFile((String)"mediaWikiTest", (String)".mw");
        FileOutputStream fos = new FileOutputStream(input);
        fos.write(WIKI_TEXT.getBytes());
        fos.close();
        File output = TempFileProvider.createTempFile((String)"mediaWikiTest", (String)".htm");
        FileContentReader contentReader = new FileContentReader(input);
        contentReader.setMimetype("text/mediawiki");
        contentReader.setEncoding("UTF-8");
        FileContentWriter contentWriter = new FileContentWriter(output);
        contentWriter.setMimetype("text/html");
        contentWriter.setEncoding("UTF-8");
        this.transformer.transform(contentReader, contentWriter);
        String line = null;
        BufferedReader reader = new BufferedReader(new FileReader(output));
        while ((line = reader.readLine()) != null) {
            System.out.println(line);
        }
    }
}

