/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.transform;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.action.ParameterDefinitionImpl;
import org.alfresco.repo.action.executer.ActionExecuterAbstractBase;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ParameterDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.detect.DefaultDetector;
import org.apache.tika.detect.Detector;
import org.apache.tika.exception.TikaException;
import org.apache.tika.extractor.EmbeddedResourceHandler;
import org.apache.tika.extractor.ParserContainerExtractor;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.parser.Parser;

public class TikaPoweredContainerExtractor {
    private static final Log logger = LogFactory.getLog(TikaPoweredContainerExtractor.class);
    private NodeService nodeService;
    private ContentService contentService;
    private TikaConfig config;
    private AutoDetectParser parser;
    private Detector detector;

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public void setTikaConfig(TikaConfig tikaConfig) {
        this.config = tikaConfig;
        this.detector = new DefaultDetector(this.config.getMimeRepository());
        this.parser = new AutoDetectParser(this.detector);
    }

    public List<NodeRef> extract(NodeRef source, List<String> mimetypes) {
        NodeRef folder = this.nodeService.getPrimaryParent(source).getParentRef();
        ContentReader reader = this.contentService.getReader(source, ContentModel.PROP_CONTENT);
        TikaInputStream stream = TikaInputStream.get((InputStream)reader.getContentInputStream());
        Extractor handler = new Extractor(folder, mimetypes);
        ParserContainerExtractor extractor = new ParserContainerExtractor((Parser)this.parser, this.detector);
        try {
            logger.info((Object)("Beginning extraction of " + source.toString()));
            extractor.extract(stream, null, (EmbeddedResourceHandler)handler);
            logger.info((Object)("Completed extraction of " + source.toString()));
        }
        catch (TikaException te) {
            throw new AlfrescoRuntimeException("Extraction Failed", (Throwable)te);
        }
        catch (IOException ie) {
            throw new AlfrescoRuntimeException("Extraction Failed", (Throwable)ie);
        }
        try {
            stream.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        return handler.extracted;
    }

    public static class ExtractorActionExecutor
    extends ActionExecuterAbstractBase {
        public static final String NAME = "extractEmbeddedResources";
        public static final String PARAM_MIME_TYPES = "mime-types";
        private TikaPoweredContainerExtractor extractor;

        public void setTikaPoweredContainerExtractor(TikaPoweredContainerExtractor extractor) {
            this.extractor = extractor;
        }

        @Override
        protected void addParameterDefinitions(List<ParameterDefinition> paramList) {
            paramList.add(new ParameterDefinitionImpl(PARAM_MIME_TYPES, DataTypeDefinition.TEXT, false, this.getParamDisplayLabel(PARAM_MIME_TYPES)));
        }

        @Override
        protected void executeImpl(Action action, NodeRef actionedUponNodeRef) {
            ArrayList<String> mimeTypes = null;
            String rawTypes = (String)((Object)action.getParameterValue(PARAM_MIME_TYPES));
            if (rawTypes != null && rawTypes.length() > 0) {
                mimeTypes = new ArrayList<String>();
                StringTokenizer st = new StringTokenizer(rawTypes, ",");
                while (st.hasMoreTokens()) {
                    mimeTypes.add(st.nextToken().trim());
                }
            }
            this.extractor.extract(actionedUponNodeRef, mimeTypes);
        }
    }

    private class Extractor
    implements EmbeddedResourceHandler {
        private List<NodeRef> extracted;
        private Set<MediaType> acceptTypes;
        private NodeRef folder;
        private int anonymousCount = 0;

        private Extractor(NodeRef folder, List<String> types) {
            this.folder = folder;
            this.extracted = new ArrayList<NodeRef>();
            if (types != null && types.size() > 0) {
                this.acceptTypes = new HashSet<MediaType>();
                for (String type : types) {
                    this.acceptTypes.add(MediaType.parse((String)type));
                }
            }
        }

        public void handle(String filename, MediaType mediaType, InputStream stream) {
            if (this.acceptTypes == null || this.acceptTypes.contains(mediaType)) {
                if (filename == null) {
                    ++this.anonymousCount;
                    filename = "embedded" + this.anonymousCount + "." + mediaType.getSubtype();
                }
                logger.info((Object)("Extracting embedded " + mediaType + " entry " + filename));
                HashMap<QName, String> properties = new HashMap<QName, String>();
                properties.put(ContentModel.PROP_NAME, filename);
                NodeRef node = TikaPoweredContainerExtractor.this.nodeService.createNode(this.folder, ContentModel.ASSOC_CONTAINS, QName.createQName((String)filename), ContentModel.TYPE_CONTENT, properties).getChildRef();
                ContentWriter writer = TikaPoweredContainerExtractor.this.contentService.getWriter(node, ContentModel.PROP_CONTENT, true);
                writer.setMimetype(mediaType.toString());
                writer.putContent(stream);
            } else {
                logger.info((Object)("Skipping embedded " + mediaType + " entry " + filename));
            }
        }
    }
}

