/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.deploy;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import org.alfresco.repo.avm.AVMServiceTestBase;
import org.alfresco.repo.domain.PropertyValue;
import org.alfresco.service.cmr.avm.AVMException;
import org.alfresco.service.cmr.avm.AVMNodeDescriptor;
import org.alfresco.service.cmr.avm.AVMNotFoundException;
import org.alfresco.service.cmr.avm.deploy.DeploymentCallback;
import org.alfresco.service.cmr.avm.deploy.DeploymentEvent;
import org.alfresco.service.cmr.avm.deploy.DeploymentReport;
import org.alfresco.service.cmr.avm.deploy.DeploymentReportCallback;
import org.alfresco.service.cmr.avm.deploy.DeploymentService;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.NameMatcher;

public class ASRDeploymentTest
extends AVMServiceTestBase {
    DeploymentService service = null;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.service = (DeploymentService)fContext.getBean("DeploymentService");
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testBasic() throws Exception {
        NameMatcher matcher = (NameMatcher)fContext.getBean("globalPathExcluder");
        String destStore = "ASRDeploymentTest";
        try {
            fService.purgeStore(destStore);
        }
        catch (AVMNotFoundException e) {
            // empty catch block
        }
        fService.createDirectory("main:/", "a");
        String rootText = "Angel is an American television series, a spin-off of the television series Buffy the Vampire Slayer. The series was created by Buffy's creator, Joss Whedon, in collaboration with David Greenwalt, and first aired on October 5, 1999. Like Buffy, it was produced by Whedon's production company, Mutant Enemy.";
        fService.createFile("main:/", "rootFile").close();
        ContentWriter writer = fService.getContentWriter("main:/rootFile", true);
        writer.setEncoding("UTF-16");
        writer.setMimetype("text/plain");
        writer.putContent(rootText);
        fService.createDirectory("main:/a", "b");
        fService.createDirectory("main:/a/b", "c");
        fService.createDirectory("main:/", "d");
        fService.createDirectory("main:/d", "e");
        fService.createDirectory("main:/d/e", "f");
        fService.createFile("main:/a/b/c", "foo").close();
        String fooText = "I am main:/a/b/c/foo";
        writer = fService.getContentWriter("main:/a/b/c/foo", true);
        writer.setEncoding("UTF-8");
        writer.setMimetype("text/plain");
        writer.putContent("I am main:/a/b/c/foo");
        fService.createFile("main:/a/b/c", "bar").close();
        writer = fService.getContentWriter("main:/a/b/c/bar", true);
        writer.setEncoding("UTF-16");
        writer.setMimetype("text/plain");
        writer.putContent("I am main:/a/b/c/bar");
        String buffyText = "This is test data: Buffy the Vampire Slayer is an Emmy Award-winning and Golden Globe-nominated American cult television series that aired from March 10, 1997 until May 20, 2003. The series was created in 1997 by writer-director Joss Whedon under his production tag, Mutant Enemy Productions with later co-executive producers being Jane Espenson, David Fury, and Marti Noxon. The series narrative follows Buffy Summers (played by Sarah Michelle Gellar), the latest in a line of young women chosen by fate to battle against vampires, demons, and the forces of darkness as the Slayer. Like previous Slayers, Buffy is aided by a Watcher, who guides and trains her. Unlike her predecessors, Buffy surrounds herself with a circle of loyal friends who become known as the Scooby Gang.";
        fService.createFile("main:/a/b", "buffy").close();
        writer = fService.getContentWriter("main:/a/b/buffy", true);
        writer.setEncoding("UTF-16");
        writer.setMimetype("text/plain");
        writer.putContent(buffyText);
        fService.createFile("main:/a/b", "fudge.bak").close();
        DeploymentReport report = new DeploymentReport();
        ArrayList<DeploymentCallback> callbacks = new ArrayList<DeploymentCallback>();
        callbacks.add(new DeploymentReportCallback(report));
        String destRef = destStore + ":/www/avm_webapps";
        this.service.deployDifference(-1, "main:/", "localhost", 50500, "admin", "admin", destRef, matcher, true, false, false, callbacks);
        HashSet<DeploymentEvent> firstDeployment = new HashSet<DeploymentEvent>();
        firstDeployment.addAll(report.getEvents());
        ASRDeploymentTest.assertTrue((String)"first deployment no start", (boolean)firstDeployment.contains(new DeploymentEvent(DeploymentEvent.Type.START, null, destRef)));
        ASRDeploymentTest.assertTrue((String)"first deployment no finish", (boolean)firstDeployment.contains(new DeploymentEvent(DeploymentEvent.Type.END, null, destRef)));
        ASRDeploymentTest.assertTrue((String)"first deployment wrong size", (firstDeployment.size() == 12 ? 1 : 0) != 0);
        ASRDeploymentTest.assertTrue((String)"Update missing: /a", (boolean)firstDeployment.contains(new DeploymentEvent(DeploymentEvent.Type.CREATED, null, destRef + "/a")));
        ASRDeploymentTest.assertTrue((String)"Update missing: /rootFile", (boolean)firstDeployment.contains(new DeploymentEvent(DeploymentEvent.Type.CREATED, null, destRef + "/rootFile")));
        ASRDeploymentTest.assertTrue((String)"Update missing: /a/b", (boolean)firstDeployment.contains(new DeploymentEvent(DeploymentEvent.Type.CREATED, null, destRef + "/a/b")));
        ASRDeploymentTest.assertTrue((String)"Update missing: /a/b/c", (boolean)firstDeployment.contains(new DeploymentEvent(DeploymentEvent.Type.CREATED, null, destRef + "/a/b/c")));
        ASRDeploymentTest.assertTrue((String)"Update missing: /d/e", (boolean)firstDeployment.contains(new DeploymentEvent(DeploymentEvent.Type.CREATED, null, destRef + "/d/e")));
        ASRDeploymentTest.assertTrue((String)"Update missing: /a/b/c/foo", (boolean)firstDeployment.contains(new DeploymentEvent(DeploymentEvent.Type.CREATED, null, destRef + "/a/b/c/foo")));
        ASRDeploymentTest.assertTrue((String)"Update missing: /a/b/c/bar", (boolean)firstDeployment.contains(new DeploymentEvent(DeploymentEvent.Type.CREATED, null, destRef + "/a/b/c/bar")));
        ASRDeploymentTest.assertTrue((String)"Update missing: /a/b/buffy", (boolean)firstDeployment.contains(new DeploymentEvent(DeploymentEvent.Type.CREATED, null, destRef + "/a/b/buffy")));
        ASRDeploymentTest.assertFalse((String)"Fudge has not been excluded", (boolean)firstDeployment.contains(new DeploymentEvent(DeploymentEvent.Type.CREATED, null, destRef + "/a/b/fudge.bak")));
        fService.getNodeProperties(-1, destRef + "/a");
        Map<QName, PropertyValue> props = fService.getNodeProperties(-1, destRef + "/a/b/buffy");
        ContentReader reader = fService.getContentReader(-1, destRef + "/a/b/buffy");
        ASRDeploymentTest.assertNotNull((String)"content reader is null", (Object)reader);
        ASRDeploymentTest.assertTrue((String)"UTF-16 buffy text is not correct", (boolean)reader.getContentString().equals(buffyText));
        report = new DeploymentReport();
        callbacks = new ArrayList();
        callbacks.add(new DeploymentReportCallback(report));
        this.service.deployDifference(-1, "main:/", "localhost", 50500, "admin", "admin", destRef, matcher, true, false, false, callbacks);
        int count = 0;
        for (DeploymentEvent event : report) {
            System.out.println(event);
            ++count;
        }
        ASRDeploymentTest.assertEquals((int)2, (int)count);
        fService.removeNode("main:/a/b/c", "bar");
        report = new DeploymentReport();
        callbacks = new ArrayList();
        callbacks.add(new DeploymentReportCallback(report));
        this.service.deployDifference(-1, "main:/", "localhost", 50500, "admin", "admin", destRef, matcher, true, false, false, callbacks);
        HashSet<DeploymentEvent> smallUpdate = new HashSet<DeploymentEvent>();
        smallUpdate.addAll(report.getEvents());
        for (DeploymentEvent event : report) {
            System.out.println(event);
        }
        ASRDeploymentTest.assertTrue((String)"Bar not deleted", (boolean)smallUpdate.contains(new DeploymentEvent(DeploymentEvent.Type.DELETED, null, destRef + "/a/b/c/bar")));
        fService.getNodeProperties(-1, destRef + "/a/b/buffy");
        ContentReader reader2 = fService.getContentReader(-1, destRef + "/a/b/buffy");
        ASRDeploymentTest.assertNotNull((String)"content reader is null", (Object)reader2);
        ASRDeploymentTest.assertTrue((String)"UTF-16 buffy text is not correct", (boolean)reader2.getContentString().equals(buffyText));
        fService.createFile("main:/d", "jonathan").close();
        fService.removeNode("main:/a/b");
        report = new DeploymentReport();
        callbacks = new ArrayList();
        callbacks.add(new DeploymentReportCallback(report));
        this.service.deployDifference(-1, "main:/", "localhost", 50500, "admin", "admin", destRef, matcher, true, false, false, callbacks);
        count = 0;
        for (DeploymentEvent event : report) {
            System.out.println(event);
            ++count;
        }
        ASRDeploymentTest.assertEquals((int)4, (int)count);
        fService.removeNode("main:/d/e");
        fService.createFile("main:/d", "e").close();
        report = new DeploymentReport();
        callbacks = new ArrayList();
        callbacks.add(new DeploymentReportCallback(report));
        this.service.deployDifference(-1, "main:/", "localhost", 50500, "admin", "admin", destRef, matcher, true, false, false, callbacks);
        count = 0;
        for (DeploymentEvent event : report) {
            System.out.println(event);
            ++count;
        }
        ASRDeploymentTest.assertEquals((int)3, (int)count);
        AVMNodeDescriptor desc = fService.lookup(-1, destRef + "/d/e");
        ASRDeploymentTest.assertTrue((String)"e is not a file", (boolean)desc.isFile());
        fService.removeNode("main:/d/e");
        fService.createDirectory("main:/d", "e");
        fService.createFile("main:/d/e", "Warren.txt").close();
        fService.createFile("main:/d/e", "It's a silly name.txt").close();
        report = new DeploymentReport();
        callbacks = new ArrayList();
        callbacks.add(new DeploymentReportCallback(report));
        this.service.deployDifference(-1, "main:/", "localhost", 50500, "admin", "admin", destRef, matcher, true, false, false, callbacks);
        count = 0;
        for (DeploymentEvent event : report) {
            System.out.println(event);
            ++count;
        }
        ASRDeploymentTest.assertEquals((int)5, (int)count);
        try {
            fService.purgeStore(destStore);
        }
        catch (AVMNotFoundException e) {
            // empty catch block
        }
    }

    public void testWrongPassword() {
        NameMatcher matcher = (NameMatcher)fContext.getBean("globalPathExcluder");
        String destStore = "Junk";
        String destRef = destStore + ":/www/avm_webapps";
        try {
            this.service.deployDifference(-1, "main:/", "localhost", 50500, "admin", "wronky", destRef, matcher, true, false, false, null);
            ASRDeploymentTest.fail((String)"Wrong password should throw exception");
        }
        catch (AVMException de) {
            de.printStackTrace();
        }
    }
}

