/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.activities.ibatis;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.domain.activities.ActivityFeedDAO;
import org.alfresco.repo.domain.activities.ActivityFeedEntity;
import org.alfresco.repo.domain.activities.ActivityFeedQueryEntity;
import org.alfresco.repo.domain.activities.ibatis.ActivitiesDAOImpl;
import org.apache.ibatis.session.RowBounds;

public class ActivityFeedDAOImpl
extends ActivitiesDAOImpl
implements ActivityFeedDAO {
    @Override
    public long insertFeedEntry(ActivityFeedEntity activityFeed) throws SQLException {
        this.template.insert("alfresco.activities.insert.insert_activity_feed", (Object)activityFeed);
        Long id = activityFeed.getId();
        return id != null ? id : -1L;
    }

    @Override
    public int deleteFeedEntries(Integer maxIdRange) throws SQLException {
        Long maxId = (Long)this.template.selectOne("alfresco.activities.select_activity_feed_entries_max_id");
        if (maxId == null) {
            return 0;
        }
        Long minId = maxId - (long)maxIdRange.intValue() + 1L;
        if (minId <= 0L) {
            return 0;
        }
        return this.template.delete("alfresco.activities.delete_activity_feed_entries_before_id", (Object)minId);
    }

    @Override
    public int deleteFeedEntries(Date keepDate) throws SQLException {
        return this.template.delete("alfresco.activities.delete_activity_feed_entries_older_than_date", (Object)keepDate);
    }

    @Override
    public int deleteSiteFeedEntries(String siteId) throws SQLException {
        ActivityFeedEntity params = new ActivityFeedEntity();
        params.setSiteNetwork(siteId);
        return this.template.delete("alfresco.activities.delete_activity_feed_for_site_entries", (Object)params);
    }

    @Override
    public int deleteSiteFeedEntries(String siteId, String format, Date keepDate) throws SQLException {
        ActivityFeedEntity params = new ActivityFeedEntity();
        params.setSiteNetwork(siteId);
        params.setActivitySummaryFormat(format);
        params.setPostDate(keepDate);
        return this.template.delete("alfresco.activities.delete_activity_feed_for_site_entries_older_than_date", (Object)params);
    }

    @Override
    public int deleteUserFeedEntries(String feedUserId, String format, Date keepDate) throws SQLException {
        ActivityFeedEntity params = new ActivityFeedEntity();
        params.setFeedUserId(feedUserId);
        params.setActivitySummaryFormat(format);
        params.setPostDate(keepDate);
        return this.template.delete("alfresco.activities.delete_activity_feed_for_feeduser_entries_older_than_date", (Object)params);
    }

    @Override
    public int deleteUserFeedEntries(String feedUserId) throws SQLException {
        ActivityFeedEntity params = new ActivityFeedEntity();
        params.setFeedUserId(feedUserId);
        return this.template.delete("alfresco.activities.delete_activity_feed_for_feeduser_entries", (Object)params);
    }

    @Override
    public List<ActivityFeedEntity> selectUserFeedsToClean(int maxFeedSize) throws SQLException {
        return this.template.selectList("alfresco.activities.select_activity_user_feeds_greater_than_max", (Object)maxFeedSize);
    }

    @Override
    public List<ActivityFeedEntity> selectSiteFeedsToClean(int maxFeedSize) throws SQLException {
        return this.template.selectList("alfresco.activities.select_activity_site_feeds_greater_than_max", (Object)maxFeedSize);
    }

    @Override
    public List<ActivityFeedEntity> selectUserFeedEntries(String feedUserId, String format, String siteId, boolean excludeThisUser, boolean excludeOtherUsers, long minFeedId, int maxFeedSize) throws SQLException {
        ActivityFeedQueryEntity params = new ActivityFeedQueryEntity();
        params.setFeedUserId(feedUserId);
        params.setActivitySummaryFormat(format);
        if (minFeedId > -1L) {
            params.setMinId(minFeedId);
        }
        int rowLimit = maxFeedSize < 0 ? Integer.MAX_VALUE : maxFeedSize;
        RowBounds rowBounds = new RowBounds(0, rowLimit);
        if (siteId != null) {
            params.setSiteNetwork(siteId);
            if (excludeThisUser && excludeOtherUsers) {
                return new ArrayList<ActivityFeedEntity>(0);
            }
            if (!excludeThisUser && !excludeOtherUsers) {
                return this.template.selectList("alfresco.activities.select.select.select_activity_feed_for_feeduser_and_site", (Object)params, rowBounds);
            }
            if (excludeThisUser && !excludeOtherUsers) {
                return this.template.selectList("alfresco.activities.select.select_activity_feed_for_feeduser_others_and_site", (Object)params, rowBounds);
            }
            if (excludeOtherUsers && !excludeThisUser) {
                return this.template.selectList("alfresco.activities.select.select_activity_feed_for_feeduser_me_and_site", (Object)params, rowBounds);
            }
        } else {
            if (excludeThisUser && excludeOtherUsers) {
                return new ArrayList<ActivityFeedEntity>(0);
            }
            if (!excludeThisUser && !excludeOtherUsers) {
                return this.template.selectList("alfresco.activities.select.select_activity_feed_for_feeduser", (Object)params, rowBounds);
            }
            if (excludeThisUser) {
                return this.template.selectList("alfresco.activities.select.select_activity_feed_for_feeduser_others", (Object)params, rowBounds);
            }
            if (excludeOtherUsers) {
                return this.template.selectList("alfresco.activities.select.select_activity_feed_for_feeduser_me", (Object)params, rowBounds);
            }
        }
        throw new AlfrescoRuntimeException("Unexpected: invalid arguments");
    }

    @Override
    public List<ActivityFeedEntity> selectSiteFeedEntries(String siteId, String format, int maxFeedSize) throws SQLException {
        ActivityFeedQueryEntity params = new ActivityFeedQueryEntity();
        params.setSiteNetwork(siteId);
        params.setActivitySummaryFormat(format);
        int rowLimit = maxFeedSize < 0 ? Integer.MAX_VALUE : maxFeedSize;
        RowBounds rowBounds = new RowBounds(0, rowLimit);
        return this.template.selectList("alfresco.activities.select.select_activity_feed_for_site", (Object)params, rowBounds);
    }
}

