/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.download;

import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.sf.acegisecurity.Authentication;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.download.DownloadModel;
import org.alfresco.repo.model.Repository;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.coci.CheckOutCheckInService;
import org.alfresco.service.cmr.download.DownloadService;
import org.alfresco.service.cmr.download.DownloadStatus;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.util.test.junitrules.AlfrescoPerson;
import org.alfresco.util.test.junitrules.ApplicationContextInit;
import org.alfresco.util.test.junitrules.TemporaryNodes;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class DownloadServiceIntegrationTest {
    public static final long MAX_TIME = 5000L;
    private static final long PAUSE_TIME = 1000L;
    public static ApplicationContextInit APP_CONTEXT_INIT = new ApplicationContextInit();
    public static AlfrescoPerson TEST_USER = new AlfrescoPerson(APP_CONTEXT_INIT, "User");
    public static AlfrescoPerson TEST_USER2 = new AlfrescoPerson(APP_CONTEXT_INIT, "User 2");
    public static TemporaryNodes STATIC_TEST_NODES = new TemporaryNodes(APP_CONTEXT_INIT);
    @ClassRule
    public static RuleChain ruleChain = RuleChain.outerRule((TestRule)APP_CONTEXT_INIT).around((TestRule)TEST_USER).around((TestRule)STATIC_TEST_NODES);
    @Rule
    public TemporaryNodes testNodes = new TemporaryNodes(APP_CONTEXT_INIT);
    public static DownloadService DOWNLOAD_SERVICE;
    private static CheckOutCheckInService CHECK_OUT_CHECK_IN_SERVICE;
    private static ContentService CONTENT_SERVICE;
    private static NodeService NODE_SERVICE;
    private static PermissionService PERMISSION_SERVICE;
    private static RetryingTransactionHelper TRANSACTION_HELPER;
    private NodeRef rootFolder;
    private NodeRef rootFile;
    private NodeRef level1Folder1;
    private NodeRef level1Folder2;
    private Set<String> allEntries;
    private NodeRef fileToCheckout;

    @BeforeClass
    public static void init() {
        CHECK_OUT_CHECK_IN_SERVICE = (CheckOutCheckInService)APP_CONTEXT_INIT.getApplicationContext().getBean("CheckOutCheckInService", CheckOutCheckInService.class);
        CONTENT_SERVICE = (ContentService)APP_CONTEXT_INIT.getApplicationContext().getBean("contentService", ContentService.class);
        DOWNLOAD_SERVICE = (DownloadService)APP_CONTEXT_INIT.getApplicationContext().getBean("DownloadService", DownloadService.class);
        NODE_SERVICE = (NodeService)APP_CONTEXT_INIT.getApplicationContext().getBean("NodeService", NodeService.class);
        PERMISSION_SERVICE = (PermissionService)APP_CONTEXT_INIT.getApplicationContext().getBean("PermissionService", PermissionService.class);
        TRANSACTION_HELPER = (RetryingTransactionHelper)APP_CONTEXT_INIT.getApplicationContext().getBean("retryingTransactionHelper", RetryingTransactionHelper.class);
    }

    @Before
    public void createContent() {
        this.allEntries = new TreeSet<String>();
        AuthenticationUtil.setRunAsUserSystem();
        Repository repositoryHelper = (Repository)APP_CONTEXT_INIT.getApplicationContext().getBean("repositoryHelper");
        NodeRef COMPANY_HOME = repositoryHelper.getCompanyHome();
        this.rootFolder = this.testNodes.createNode(COMPANY_HOME, "rootFolder", ContentModel.TYPE_FOLDER, AuthenticationUtil.getAdminUserName());
        this.allEntries.add("rootFolder/");
        this.rootFile = this.testNodes.createNodeWithTextContent(COMPANY_HOME, "rootFile.txt", ContentModel.TYPE_CONTENT, AuthenticationUtil.getAdminUserName(), "Root file content");
        this.allEntries.add("rootFile.txt");
        this.testNodes.createNodeWithTextContent(this.rootFolder, "level1File.txt", ContentModel.TYPE_CONTENT, AuthenticationUtil.getAdminUserName(), "Level 1 file content");
        this.allEntries.add("rootFolder/level1File.txt");
        this.level1Folder1 = this.testNodes.createNode(this.rootFolder, "level1Folder1", ContentModel.TYPE_FOLDER, AuthenticationUtil.getAdminUserName());
        this.allEntries.add("rootFolder/level1Folder1/");
        this.level1Folder2 = this.testNodes.createNode(this.rootFolder, "level1Folder2", ContentModel.TYPE_FOLDER, AuthenticationUtil.getAdminUserName());
        this.allEntries.add("rootFolder/level1Folder2/");
        this.testNodes.createNode(this.rootFolder, "level1EmptyFolder", ContentModel.TYPE_FOLDER, AuthenticationUtil.getAdminUserName());
        this.allEntries.add("rootFolder/level1EmptyFolder/");
        this.testNodes.createNodeWithTextContent(this.level1Folder1, "level2File.txt", ContentModel.TYPE_CONTENT, AuthenticationUtil.getAdminUserName(), "Level 2 file content");
        this.allEntries.add("rootFolder/level1Folder1/level2File.txt");
        this.testNodes.createNodeWithTextContent(this.level1Folder2, "level2File.txt", ContentModel.TYPE_CONTENT, AuthenticationUtil.getAdminUserName(), "Level 2 file content");
        this.allEntries.add("rootFolder/level1Folder2/level2File.txt");
        this.fileToCheckout = this.testNodes.createNodeWithTextContent(this.level1Folder2, "fileToCheckout.txt", ContentModel.TYPE_CONTENT, AuthenticationUtil.getAdminUserName(), "Level 2 file content");
        NODE_SERVICE.addAspect(this.fileToCheckout, ContentModel.ASPECT_VERSIONABLE, null);
        NODE_SERVICE.addAspect(this.fileToCheckout, ContentModel.ASPECT_LOCKABLE, null);
        this.allEntries.add("rootFolder/level1Folder2/fileToCheckout.txt");
        PERMISSION_SERVICE.setPermission(this.level1Folder2, TEST_USER.getUsername(), "All", true);
        PERMISSION_SERVICE.setPermission(this.fileToCheckout, TEST_USER.getUsername(), "All", true);
    }

    @Test
    public void createDownload() throws IOException, InterruptedException {
        final NodeRef downloadNode = DOWNLOAD_SERVICE.createDownload(new NodeRef[]{this.rootFile, this.rootFolder}, true);
        Assert.assertNotNull((Object)downloadNode);
        this.testNodes.addNodeRef(downloadNode);
        TRANSACTION_HELPER.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() throws Throwable {
                Map properties = NODE_SERVICE.getProperties(downloadNode);
                Assert.assertEquals((Object)Boolean.TRUE, properties.get(DownloadModel.PROP_RECURSIVE));
                List associations = NODE_SERVICE.getTargetAssocs(downloadNode, (QNamePattern)DownloadModel.ASSOC_REQUESTED_NODES);
                for (AssociationRef association : associations) {
                    Assert.assertTrue((association.getTargetRef().equals((Object)DownloadServiceIntegrationTest.this.rootFile) || association.getTargetRef().equals((Object)DownloadServiceIntegrationTest.this.rootFolder) ? 1 : 0) != 0);
                }
                return null;
            }
        });
        DownloadStatus status = this.getDownloadStatus(downloadNode);
        while (status.getStatus() == DownloadStatus.Status.PENDING) {
            Thread.sleep(1000L);
            status = this.getDownloadStatus(downloadNode);
        }
        Assert.assertEquals((long)5L, (long)status.getTotalFiles());
        long elapsedTime = this.waitForDownload(downloadNode);
        Assert.assertTrue((String)"Maximum creation time exceeded!", (elapsedTime < 5000L ? 1 : 0) != 0);
        Set<String> entryNames = this.getEntries(downloadNode);
        this.validateEntries(entryNames, this.allEntries, true);
    }

    private void validateEntries(Set<String> entryNames, Set<String> expectedEntries, boolean onlyExpected) {
        TreeSet<String> copy = new TreeSet<String>(entryNames);
        for (String expectedEntry : expectedEntries) {
            Assert.assertTrue((String)("Missing entry:- " + expectedEntry), (boolean)copy.contains(expectedEntry));
            copy.remove(expectedEntry);
        }
        if (onlyExpected) {
            Assert.assertTrue((String)"Unexpected entries", (boolean)copy.isEmpty());
        }
    }

    private Set<String> getEntries(final NodeRef downloadNode) {
        return TRANSACTION_HELPER.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Set<String>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Set<String> execute() throws Throwable {
                TreeSet<String> entryNames = new TreeSet<String>();
                ContentReader reader = CONTENT_SERVICE.getReader(downloadNode, ContentModel.PROP_CONTENT);
                ZipArchiveInputStream zipInputStream = new ZipArchiveInputStream(reader.getContentInputStream());
                try {
                    ZipArchiveEntry zipEntry = zipInputStream.getNextZipEntry();
                    while (zipEntry != null) {
                        String name = zipEntry.getName();
                        entryNames.add(name);
                        zipEntry = zipInputStream.getNextZipEntry();
                    }
                }
                finally {
                    zipInputStream.close();
                }
                return entryNames;
            }
        });
    }

    private long waitForDownload(NodeRef downloadNode) throws InterruptedException {
        long elapsedTime;
        DownloadStatus status;
        long startTime = System.currentTimeMillis();
        do {
            status = this.getDownloadStatus(downloadNode);
            elapsedTime = System.currentTimeMillis() - startTime;
            if (status.isComplete()) continue;
            Thread.sleep(1000L);
        } while (!status.isComplete() && elapsedTime < 5000L);
        return elapsedTime;
    }

    private DownloadStatus getDownloadStatus(final NodeRef downloadNode) {
        return TRANSACTION_HELPER.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<DownloadStatus>(){

            @Override
            public DownloadStatus execute() throws Throwable {
                return DOWNLOAD_SERVICE.getDownloadStatus(downloadNode);
            }
        });
    }

    @Test
    public void deleteBefore() throws InterruptedException {
        NodeRef beforeNodeRef = DOWNLOAD_SERVICE.createDownload(new NodeRef[]{this.level1Folder1}, true);
        this.testNodes.addNodeRef(beforeNodeRef);
        this.waitForDownload(beforeNodeRef);
        Date beforeTime = new Date();
        NodeRef afterNodeRef = DOWNLOAD_SERVICE.createDownload(new NodeRef[]{this.level1Folder2}, true);
        this.testNodes.addNodeRef(afterNodeRef);
        this.waitForDownload(afterNodeRef);
        DOWNLOAD_SERVICE.deleteDownloads(beforeTime);
        Assert.assertFalse((boolean)NODE_SERVICE.exists(beforeNodeRef));
        Assert.assertTrue((boolean)NODE_SERVICE.exists(afterNodeRef));
    }

    @Test
    public void cancel() throws InterruptedException {
        NodeRef downloadNode = DOWNLOAD_SERVICE.createDownload(new NodeRef[]{this.rootFile, this.rootFolder}, true);
        Assert.assertNotNull((Object)downloadNode);
        this.testNodes.addNodeRef(downloadNode);
        DOWNLOAD_SERVICE.cancelDownload(downloadNode);
        DownloadStatus status = this.getDownloadStatus(downloadNode);
        for (int retryCount = 0; status.getStatus() != DownloadStatus.Status.CANCELLED && retryCount < 5; ++retryCount) {
            Thread.sleep(1000L);
            status = this.getDownloadStatus(downloadNode);
        }
        Assert.assertEquals((Object)((Object)DownloadStatus.Status.CANCELLED), (Object)((Object)status.getStatus()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void workingCopies() throws InterruptedException {
        NodeRef workingCopy;
        TreeSet<String> preCheckoutExpectedEntries = new TreeSet<String>();
        preCheckoutExpectedEntries.add("level1Folder2/");
        preCheckoutExpectedEntries.add("level1Folder2/level2File.txt");
        preCheckoutExpectedEntries.add("level1Folder2/fileToCheckout.txt");
        this.validateWorkingCopyFolder(preCheckoutExpectedEntries, this.level1Folder2, TEST_USER.getUsername());
        this.validateWorkingCopyFolder(preCheckoutExpectedEntries, this.level1Folder2, TEST_USER2.getUsername());
        Authentication previousAuth = AuthenticationUtil.getFullAuthentication();
        AuthenticationUtil.setFullyAuthenticatedUser((String)TEST_USER.getUsername());
        try {
            workingCopy = CHECK_OUT_CHECK_IN_SERVICE.checkout(this.fileToCheckout);
        }
        finally {
            AuthenticationUtil.setFullAuthentication((Authentication)previousAuth);
        }
        try {
            this.validateWorkingCopyFolder(preCheckoutExpectedEntries, this.level1Folder2, TEST_USER2.getUsername());
            TreeSet<String> postCheckoutExpectedEntries = new TreeSet<String>();
            postCheckoutExpectedEntries.add("level1Folder2/");
            postCheckoutExpectedEntries.add("level1Folder2/level2File.txt");
            postCheckoutExpectedEntries.add("level1Folder2/fileToCheckout (Working Copy).txt");
            this.validateWorkingCopyFolder(postCheckoutExpectedEntries, this.level1Folder2, TEST_USER.getUsername());
        }
        finally {
            previousAuth = AuthenticationUtil.getFullAuthentication();
            AuthenticationUtil.setFullyAuthenticatedUser((String)TEST_USER.getUsername());
            try {
                CHECK_OUT_CHECK_IN_SERVICE.checkin(workingCopy, null);
            }
            finally {
                AuthenticationUtil.setFullAuthentication((Authentication)previousAuth);
            }
        }
        this.validateWorkingCopyFolder(preCheckoutExpectedEntries, this.level1Folder2, TEST_USER.getUsername());
        this.validateWorkingCopyFolder(preCheckoutExpectedEntries, this.level1Folder2, TEST_USER2.getUsername());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateWorkingCopyFolder(Set<String> expectedEntries, NodeRef folder, String userID) throws InterruptedException {
        Authentication previousAuthentication = AuthenticationUtil.getFullAuthentication();
        AuthenticationUtil.setFullyAuthenticatedUser((String)userID);
        try {
            NodeRef downloadNode = DOWNLOAD_SERVICE.createDownload(new NodeRef[]{folder}, true);
            this.testNodes.addNodeRef(downloadNode);
            this.waitForDownload(downloadNode);
            this.validateEntries(this.getEntries(downloadNode), expectedEntries, true);
        }
        finally {
            AuthenticationUtil.setFullAuthentication((Authentication)previousAuthentication);
        }
    }
}

