/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.googledocs;

import com.google.gdata.util.ServiceException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import javax.transaction.UserTransaction;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.content.transform.AbstractContentTransformerTest;
import org.alfresco.repo.googledocs.GoogleDocsModel;
import org.alfresco.repo.googledocs.GoogleDocsPermissionContext;
import org.alfresco.repo.googledocs.GoogleDocsService;
import org.alfresco.repo.management.subsystems.ApplicationContextFactory;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.coci.CheckOutCheckInService;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.rendition.RenditionDefinition;
import org.alfresco.service.cmr.rendition.RenditionService;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.cmr.site.SiteVisibility;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.GUID;
import org.alfresco.util.PropertyMap;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;

public class GoogleDocumentServiceSystemTest
extends TestCase
implements GoogleDocsModel {
    private NodeService nodeService;
    private GoogleDocsService googleDocsService;
    private SiteService siteService;
    private TransactionService transactionService;
    private FileFolderService fileFolderService;
    private ContentService contentService;
    private CheckOutCheckInService checkOutCheckInService;
    private MutableAuthenticationService authenticationService;
    private PersonService personService;
    private ApplicationContextFactory subsystem;
    private RenditionService renditionService;
    private static final String USER_ONE = "GoogleDocUserOne";
    private static final String USER_TWO = "GoogleDocUserTwo";
    private static final String USER_THREE = "GoogleDocUserThree";
    private static final String USER_FOUR = "GoogleDocUserFour";
    private static final String USER_FIVE = "GoogleDocUserFive";
    private static final String USER_SIX = "GoogleDocUserSix";
    private static final String USER_SEVEN = "GoogleDocUserSeven";
    private NodeRef folder;
    private NodeRef nodeRefDoc;
    private NodeRef nodeRefSpread;
    private NodeRef nodeRefPres;
    private NodeRef nodeRefPdf;
    private NodeRef nodeRef2;
    private UserTransaction userTransaction;
    private String siteId;

    protected void setUp() throws Exception {
        ApplicationContext appContext = ApplicationContextHelper.getApplicationContext();
        this.nodeService = (NodeService)appContext.getBean("nodeService");
        this.siteService = (SiteService)appContext.getBean("siteService");
        this.transactionService = (TransactionService)appContext.getBean("transactionService");
        this.fileFolderService = (FileFolderService)appContext.getBean("fileFolderService");
        this.contentService = (ContentService)appContext.getBean("contentService");
        this.checkOutCheckInService = (CheckOutCheckInService)appContext.getBean("checkOutCheckInService");
        this.authenticationService = (MutableAuthenticationService)appContext.getBean("authenticationService");
        this.personService = (PersonService)appContext.getBean("personService");
        this.renditionService = (RenditionService)appContext.getBean("renditionService");
        this.userTransaction = this.transactionService.getUserTransaction();
        this.userTransaction.begin();
        this.subsystem = (ApplicationContextFactory)appContext.getBean("googledocs");
        if (this.subsystem.getProperty("googledocs.googleeditable.enabled").equals("false")) {
            this.subsystem.stop();
            this.subsystem.setProperty("googledocs.googleeditable.enabled", "true");
            this.subsystem.start();
        }
        ConfigurableApplicationContext childContext = (ConfigurableApplicationContext)this.subsystem.getApplicationContext();
        this.googleDocsService = (GoogleDocsService)childContext.getBean("googleDocsService");
        this.createUser(USER_ONE, "rwetherall@alfresco.com", null);
        this.createUser(USER_TWO, "admin@alfresco.com", "rwetherall@activiti.com");
        this.createUser(USER_THREE, "roy.wetherall@alfresco.com", null);
        this.createUser(USER_FOUR, "roy.wetherall@activiti.com", null);
        this.createUser(USER_FIVE, "admin@alfresco.com", "admin@alfresco.com");
        this.createUser(USER_SIX, "admin@alfresco.com", null);
        this.createUser(USER_SEVEN, null, null);
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_ONE);
        this.siteId = GUID.generate();
        this.siteService.createSite("sitePreset", this.siteId, "My Title", "My Description", SiteVisibility.PUBLIC);
        NodeRef container = this.siteService.createContainer(this.siteId, "testComponent", null, null);
        this.siteService.setMembership(this.siteId, USER_TWO, "SiteCollaborator");
        this.siteService.setMembership(this.siteId, USER_THREE, "SiteContributor");
        this.siteService.setMembership(this.siteId, USER_FOUR, "SiteConsumer");
        this.siteService.setMembership(this.siteId, USER_FIVE, "SiteCollaborator");
        this.siteService.setMembership(this.siteId, USER_SIX, "SiteCollaborator");
        this.siteService.setMembership(this.siteId, USER_SEVEN, "SiteCollaborator");
        this.folder = this.fileFolderService.create(container, "myfolder" + GUID.generate(), ContentModel.TYPE_FOLDER).getNodeRef();
        this.nodeRefDoc = this.createTestDocument("mydoc.docx", "alfresco/subsystems/googledocs/default/test.docx", "application/msword");
        this.nodeRefSpread = this.createTestDocument("mydoc.xls", "alfresco/subsystems/googledocs/default/testBook.xls", "application/vnd.ms-excel");
        this.nodeRef2 = this.fileFolderService.create(this.folder, "mygoogledoc.xls", ContentModel.TYPE_CONTENT).getNodeRef();
        this.nodeService.addAspect(this.nodeRef2, ASPECT_GOOGLEEDITABLE, null);
        ContentWriter contentWriter = this.contentService.getWriter(this.nodeRef2, ContentModel.PROP_CONTENT, true);
        contentWriter.setEncoding("UTF-8");
        contentWriter.setMimetype("application/vnd.ms-excel");
        contentWriter.putContent("");
    }

    private NodeRef createTestDocument(String name, String contentPath, String mimetype) {
        NodeRef nodeRef = this.fileFolderService.create(this.folder, name, ContentModel.TYPE_CONTENT).getNodeRef();
        ContentWriter writer = this.contentService.getWriter(nodeRef, ContentModel.PROP_CONTENT, true);
        writer.setEncoding("UTF-8");
        writer.setMimetype(mimetype);
        InputStream is = this.getClass().getClassLoader().getResourceAsStream(contentPath);
        writer.putContent(is);
        return nodeRef;
    }

    private void createUser(String userName, String email, String googleEmail) {
        if (!this.authenticationService.authenticationExists(userName)) {
            this.authenticationService.createAuthentication(userName, "PWD".toCharArray());
            PropertyMap ppOne = new PropertyMap(4);
            ppOne.put(ContentModel.PROP_USERNAME, userName);
            ppOne.put(ContentModel.PROP_FIRSTNAME, "firstName");
            ppOne.put(ContentModel.PROP_LASTNAME, "lastName");
            ppOne.put(ContentModel.PROP_JOBTITLE, "jobTitle");
            if (email != null) {
                ppOne.put(ContentModel.PROP_EMAIL, email);
            }
            if (googleEmail != null) {
                ppOne.put(ContentModel.PROP_GOOGLEUSERNAME, googleEmail);
            }
            this.personService.createPerson(ppOne);
        }
    }

    protected void tearDown() throws Exception {
        this.siteService.deleteSite(this.siteId);
        if (this.userTransaction != null) {
            this.userTransaction.commit();
        }
    }

    private boolean isGoogleServiceAvailable() {
        return this.googleDocsService.isEnabled();
    }

    public void testGoogleDocUploadDownload() throws Exception {
        if (this.isGoogleServiceAvailable()) {
            this.googleDocsService.createGoogleDoc(this.nodeRefDoc, GoogleDocsPermissionContext.SHARE_WRITE);
            GoogleDocumentServiceSystemTest.assertTrue((boolean)this.nodeService.hasAspect(this.nodeRefDoc, ASPECT_GOOGLERESOURCE));
            GoogleDocumentServiceSystemTest.assertNotNull((Object)this.nodeService.getProperty(this.nodeRefDoc, PROP_URL));
            GoogleDocumentServiceSystemTest.assertNotNull((Object)this.nodeService.getProperty(this.nodeRefDoc, PROP_RESOURCE_ID));
            GoogleDocumentServiceSystemTest.assertNotNull((Object)this.nodeService.getProperty(this.nodeRefDoc, PROP_RESOURCE_TYPE));
            System.out.println("For node ref " + this.nodeRefDoc.toString());
            System.out.println("Google doc URL: " + this.nodeService.getProperty(this.nodeRefDoc, PROP_URL));
            System.out.println("Google doc type: " + this.nodeService.getProperty(this.nodeRefDoc, PROP_RESOURCE_TYPE));
            System.out.println("Google doc id: " + this.nodeService.getProperty(this.nodeRefDoc, PROP_RESOURCE_ID));
            String downloadFile = this.downloadFile(this.googleDocsService.getGoogleDocContent(this.nodeRefDoc), ".doc");
            System.out.println("Download file: " + downloadFile);
            this.googleDocsService.createGoogleDoc(this.nodeRefSpread, GoogleDocsPermissionContext.SHARE_WRITE);
            GoogleDocumentServiceSystemTest.assertTrue((boolean)this.nodeService.hasAspect(this.nodeRefSpread, ASPECT_GOOGLERESOURCE));
            GoogleDocumentServiceSystemTest.assertNotNull((Object)this.nodeService.getProperty(this.nodeRefSpread, PROP_URL));
            GoogleDocumentServiceSystemTest.assertNotNull((Object)this.nodeService.getProperty(this.nodeRefSpread, PROP_RESOURCE_ID));
            GoogleDocumentServiceSystemTest.assertNotNull((Object)this.nodeService.getProperty(this.nodeRefSpread, PROP_RESOURCE_TYPE));
            System.out.println("Google doc URL: " + this.nodeService.getProperty(this.nodeRefSpread, PROP_URL));
            System.out.println("Google doc type: " + this.nodeService.getProperty(this.nodeRefSpread, PROP_RESOURCE_TYPE));
            System.out.println("Google doc id: " + this.nodeService.getProperty(this.nodeRefSpread, PROP_RESOURCE_ID));
            downloadFile = this.downloadFile(this.googleDocsService.getGoogleDocContent(this.nodeRefSpread), ".xls");
            System.out.println("Download file: " + downloadFile);
            this.googleDocsService.createGoogleDoc(this.nodeRef2, GoogleDocsPermissionContext.SHARE_WRITE);
        }
    }

    public void testCheckOutCheckIn() throws Exception {
        if (this.isGoogleServiceAvailable()) {
            NodeRef workingCopy = this.checkOutCheckInService.checkout(this.nodeRef2);
            GoogleDocumentServiceSystemTest.assertTrue((boolean)this.nodeService.hasAspect(workingCopy, ASPECT_GOOGLERESOURCE));
            GoogleDocumentServiceSystemTest.assertNotNull((Object)this.nodeService.getProperty(workingCopy, PROP_URL));
            GoogleDocumentServiceSystemTest.assertNotNull((Object)this.nodeService.getProperty(workingCopy, PROP_RESOURCE_ID));
            GoogleDocumentServiceSystemTest.assertNotNull((Object)this.nodeService.getProperty(workingCopy, PROP_RESOURCE_TYPE));
            System.out.println("Google doc URL: " + this.nodeService.getProperty(workingCopy, PROP_URL));
            System.out.println("Google doc type: " + this.nodeService.getProperty(workingCopy, PROP_RESOURCE_TYPE));
            System.out.println("Google doc id: " + this.nodeService.getProperty(workingCopy, PROP_RESOURCE_ID));
            this.checkOutCheckInService.checkin(workingCopy, null);
            GoogleDocumentServiceSystemTest.assertFalse((boolean)this.nodeService.hasAspect(this.nodeRef2, ASPECT_GOOGLERESOURCE));
            ContentReader contentReader = this.contentService.getReader(this.nodeRef2, ContentModel.PROP_CONTENT);
            GoogleDocumentServiceSystemTest.assertNotNull((Object)contentReader);
            this.nodeService.deleteNode(this.nodeRef2);
        }
    }

    public void testALF5060() throws Exception {
        if (this.isGoogleServiceAvailable()) {
            RenditionDefinition def = this.renditionService.createRenditionDefinition(QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"myDef"), "reformat");
            def.setExecuteAsynchronously(false);
            def.setParameterValue("mime-type", (Serializable)((Object)"application/x-shockwave-flash"));
            File fileDoc = AbstractContentTransformerTest.loadQuickTestFile("doc");
            NodeRef nodeRef = this.fileFolderService.create(this.folder, "testing.doc", ContentModel.TYPE_CONTENT).getNodeRef();
            this.nodeService.addAspect(nodeRef, ASPECT_GOOGLEEDITABLE, null);
            ContentWriter contentWriter = this.contentService.getWriter(nodeRef, ContentModel.PROP_CONTENT, true);
            contentWriter.setEncoding("UTF-8");
            contentWriter.setMimetype("application/msword");
            contentWriter.putContent(fileDoc);
            this.renditionService.render(nodeRef, def);
            NodeRef workingCopy = this.checkOutCheckInService.checkout(nodeRef);
            GoogleDocumentServiceSystemTest.assertTrue((boolean)this.nodeService.hasAspect(workingCopy, ASPECT_GOOGLERESOURCE));
            GoogleDocumentServiceSystemTest.assertNotNull((Object)this.nodeService.getProperty(workingCopy, PROP_URL));
            GoogleDocumentServiceSystemTest.assertNotNull((Object)this.nodeService.getProperty(workingCopy, PROP_RESOURCE_ID));
            GoogleDocumentServiceSystemTest.assertNotNull((Object)this.nodeService.getProperty(workingCopy, PROP_RESOURCE_TYPE));
            System.out.println("Google doc URL: " + this.nodeService.getProperty(workingCopy, PROP_URL));
            System.out.println("Google doc type: " + this.nodeService.getProperty(workingCopy, PROP_RESOURCE_TYPE));
            System.out.println("Google doc id: " + this.nodeService.getProperty(workingCopy, PROP_RESOURCE_ID));
            this.checkOutCheckInService.checkin(workingCopy, null);
            this.renditionService.render(nodeRef, def);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String downloadFile(InputStream inStream, String ext) throws IOException, MalformedURLException, ServiceException {
        File file = File.createTempFile("googleDocTest", ext);
        String filePath = file.getAbsolutePath();
        FileOutputStream outStream = null;
        try {
            int c;
            outStream = new FileOutputStream(filePath);
            while ((c = inStream.read()) != -1) {
                outStream.write(c);
            }
        }
        finally {
            if (inStream != null) {
                inStream.close();
            }
            if (outStream != null) {
                outStream.flush();
                outStream.close();
            }
        }
        return filePath;
    }
}

