/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.imap;

import com.sun.mail.iap.ProtocolException;
import com.sun.mail.iap.Response;
import com.sun.mail.imap.IMAPFolder;
import com.sun.mail.imap.protocol.BODY;
import com.sun.mail.imap.protocol.FetchResponse;
import com.sun.mail.imap.protocol.IMAPProtocol;
import com.sun.mail.imap.protocol.IMAPResponse;
import com.sun.mail.imap.protocol.RFC822DATA;
import com.sun.mail.imap.protocol.UID;
import com.sun.mail.util.ASCIIUtility;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import javax.transaction.UserTransaction;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.model.ImapModel;
import org.alfresco.repo.imap.AlfrescoImapServer;
import org.alfresco.repo.imap.ImapServiceImpl;
import org.alfresco.repo.imap.IncomingImapMessage;
import org.alfresco.repo.importer.ACPImportPackageHandler;
import org.alfresco.repo.management.subsystems.ChildApplicationContextFactory;
import org.alfresco.repo.node.integrity.IntegrityChecker;
import org.alfresco.repo.search.QueryParameterDefImpl;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileFolderUtil;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.QueryParameterDefinition;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.view.ImporterService;
import org.alfresco.service.cmr.view.Location;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.GUID;
import org.alfresco.util.PropertyMap;
import org.alfresco.util.config.RepositoryFolderConfigBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.ClassPathResource;
import org.springframework.mail.javamail.MimeMessageHelper;

public class ImapMessageTest
extends TestCase {
    private static Log logger = LogFactory.getLog(ImapMessageTest.class);
    private static final String PROTOCOL = "imap";
    private static final String HOST = "localhost";
    private static final int PORT = 7143;
    private static final String ADMIN_USER_NAME = "admin";
    private static final String ADMIN_USER_PASSWORD = "admin";
    private static final String IMAP_FOLDER_NAME = "test";
    private Session session = null;
    private Store store = null;
    private IMAPFolder folder = null;
    private static ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
    private ServiceRegistry serviceRegistry;
    private TransactionService transactionService;
    private NodeService nodeService;
    private ImporterService importerService;
    private PersonService personService;
    private SearchService searchService;
    private NamespaceService namespaceService;
    private FileFolderService fileFolderService;
    private MutableAuthenticationService authenticationService;
    private AlfrescoImapServer imapServer;
    String anotherUserName;
    private NodeRef testImapFolderNodeRef;
    private NodeRef storeRootNodeRef;
    private final String storePath = "workspace://SpacesStore";
    private final String companyHomePathInStore = "/app:company_home";
    private static final String TEST_FOLDER = "Alfresco IMAP/test/___-___folder_a/___-___folder_a_a";
    private static final String TEST_FILE = "/cm:test/cm:___-___folder_a/cm:___-___folder_a_a/cm:___-___file_a_a";

    public void setUp() throws Exception {
        logger.debug((Object)"In SetUp");
        this.serviceRegistry = (ServiceRegistry)ctx.getBean("ServiceRegistry");
        this.transactionService = this.serviceRegistry.getTransactionService();
        this.nodeService = this.serviceRegistry.getNodeService();
        this.importerService = this.serviceRegistry.getImporterService();
        this.personService = this.serviceRegistry.getPersonService();
        this.authenticationService = this.serviceRegistry.getAuthenticationService();
        this.searchService = this.serviceRegistry.getSearchService();
        this.namespaceService = this.serviceRegistry.getNamespaceService();
        this.fileFolderService = this.serviceRegistry.getFileFolderService();
        UserTransaction txn = this.transactionService.getUserTransaction();
        txn.begin();
        this.authenticationService.authenticate("admin", "admin".toCharArray());
        IntegrityChecker.setWarnInTransaction();
        this.anotherUserName = "user" + System.currentTimeMillis();
        PropertyMap testUser = new PropertyMap();
        testUser.put(ContentModel.PROP_USERNAME, this.anotherUserName);
        testUser.put(ContentModel.PROP_FIRSTNAME, this.anotherUserName);
        testUser.put(ContentModel.PROP_LASTNAME, this.anotherUserName);
        testUser.put(ContentModel.PROP_EMAIL, this.anotherUserName + "@alfresco.com");
        testUser.put(ContentModel.PROP_JOBTITLE, "jobTitle");
        this.personService.createPerson(testUser);
        this.authenticationService.createAuthentication(this.anotherUserName, this.anotherUserName.toCharArray());
        StoreRef storeRef = new StoreRef("workspace://SpacesStore");
        this.storeRootNodeRef = this.nodeService.getRootNode(storeRef);
        List nodeRefs = this.searchService.selectNodes(this.storeRootNodeRef, "/app:company_home", null, (NamespacePrefixResolver)this.namespaceService, false);
        NodeRef companyHomeNodeRef = (NodeRef)nodeRefs.get(0);
        nodeRefs = this.searchService.selectNodes(this.storeRootNodeRef, "/app:company_home/cm:test", null, (NamespacePrefixResolver)this.namespaceService, false);
        if (nodeRefs != null && nodeRefs.size() > 0) {
            this.fileFolderService.delete((NodeRef)nodeRefs.get(0));
        }
        ChildApplicationContextFactory imap = (ChildApplicationContextFactory)ctx.getBean(PROTOCOL);
        ApplicationContext imapCtx = imap.getApplicationContext();
        ImapServiceImpl imapServiceImpl = (ImapServiceImpl)imapCtx.getBean("imapService");
        this.imapServer = (AlfrescoImapServer)((Object)imapCtx.getBean("imapServer"));
        if (!this.imapServer.isImapServerEnabled()) {
            this.imapServer.setImapServerEnabled(true);
            this.imapServer.setHost(HOST);
            this.imapServer.setPort(7143);
            this.imapServer.startup();
        }
        LinkedList<String> folders = new LinkedList<String>();
        folders.add(IMAP_FOLDER_NAME);
        FileFolderUtil.makeFolders(this.fileFolderService, companyHomeNodeRef, folders, ContentModel.TYPE_FOLDER);
        RepositoryFolderConfigBean imapHome = new RepositoryFolderConfigBean();
        imapHome.setStore("workspace://SpacesStore");
        imapHome.setRootPath("/app:company_home");
        imapHome.setFolderPath(IMAP_FOLDER_NAME);
        imapServiceImpl.setImapHome(imapHome);
        imapServiceImpl.startupInTxn(true);
        nodeRefs = this.searchService.selectNodes(this.storeRootNodeRef, "/app:company_home/cm:test", null, (NamespacePrefixResolver)this.namespaceService, false);
        this.testImapFolderNodeRef = (NodeRef)nodeRefs.get(0);
        this.importInternal("imap/imapservice_test_folder_a.acp", this.testImapFolderNodeRef);
        txn.commit();
        Properties props = new Properties();
        props.setProperty("mail.imap.partialfetch", "false");
        this.session = Session.getDefaultInstance((Properties)props, null);
        this.store = this.session.getStore(PROTOCOL);
        this.store.connect(this.imapServer.getHost(), this.imapServer.getPort(), this.anotherUserName, this.anotherUserName);
        this.folder = (IMAPFolder)this.store.getFolder(TEST_FOLDER);
        this.folder.open(1);
        logger.debug((Object)"End SetUp");
    }

    private void importInternal(String acpName, NodeRef space) throws IOException {
        ClassPathResource acpResource = new ClassPathResource(acpName);
        ACPImportPackageHandler acpHandler = new ACPImportPackageHandler(acpResource.getFile(), null);
        Location importLocation = new Location(space);
        this.importerService.importView(acpHandler, importLocation, null, null);
    }

    public void testMessageModifiedBetweenReads() throws Exception {
        Long uid = ImapMessageTest.getMessageUid(this.folder, 1);
        BODY body = ImapMessageTest.getMessageBody(this.folder, uid);
        MimeMessage message = new MimeMessage(Session.getDefaultInstance((Properties)new Properties()), (InputStream)new BufferedInputStream(body.getByteArrayInputStream()));
        MimeMultipart content = (MimeMultipart)message.getContent();
        ImapMessageTest.assertNotNull((Object)content.getBodyPart(0).getContent());
        ImapMessageTest.assertNotNull((Object)content.getBodyPart(1).getContent());
        NodeRef contentNode = this.findNode("/app:company_home/cm:test/cm:___-___folder_a/cm:___-___folder_a_a/cm:___-___file_a_a");
        UserTransaction txn = this.transactionService.getUserTransaction();
        txn.begin();
        ContentWriter writer = this.fileFolderService.getWriter(contentNode);
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < 2000; ++i) {
            sb.append("test string");
        }
        writer.putContent(sb.toString());
        txn.commit();
        BODY bodyNew = ImapMessageTest.getMessageBody(this.folder, uid);
        ImapMessageTest.assertFalse((boolean)Arrays.equals(bodyNew.data.getBytes(), body.data.getBytes()));
        message = new MimeMessage(Session.getDefaultInstance((Properties)new Properties()), (InputStream)new BufferedInputStream(bodyNew.getByteArrayInputStream()));
        content = (MimeMultipart)message.getContent();
        ImapMessageTest.assertNotNull((Object)content.getBodyPart(0).getContent());
        ImapMessageTest.assertNotNull((Object)content.getBodyPart(1).getContent());
    }

    public void testMessageRenamedBetweenReads() throws Exception {
        Long uid = ImapMessageTest.getMessageUid(this.folder, 1);
        int count = ImapMessageTest.getMessageSize(this.folder, uid);
        BODY body = ImapMessageTest.getMessageBodyPart(this.folder, uid, 0, count - 100);
        NodeRef contentNode = this.findNode("/app:company_home/cm:test/cm:___-___folder_a/cm:___-___folder_a_a/cm:___-___file_a_a");
        UserTransaction txn = this.transactionService.getUserTransaction();
        txn.begin();
        this.fileFolderService.rename(contentNode, "testtesttesttesttesttesttesttesttesttest");
        txn.commit();
        BODY bodyRest = ImapMessageTest.getMessageBodyPart(this.folder, uid, count - 100, 100);
        MimeMessage message = new MimeMessage(Session.getDefaultInstance((Properties)new Properties()), (InputStream)new SequenceInputStream(new BufferedInputStream(body.getByteArrayInputStream()), new BufferedInputStream(bodyRest.getByteArrayInputStream())));
        MimeMultipart content = (MimeMultipart)message.getContent();
        ImapMessageTest.assertNotNull((Object)content.getBodyPart(0).getContent());
        try {
            content.getBodyPart(1).getContent();
            ImapMessageTest.fail((String)"Should raise an IOException");
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    public void dontTestMessageCache() throws Exception {
        int i;
        NodeRef contentNode = this.findNode("/app:company_home/cm:test/cm:___-___folder_a/cm:___-___folder_a_a/cm:___-___file_a_a");
        UserTransaction txn = this.transactionService.getUserTransaction();
        txn.begin();
        for (i = 0; i < 51; ++i) {
            FileInfo fi = this.fileFolderService.create(((ChildAssociationRef)this.nodeService.getParentAssocs(contentNode).get(0)).getParentRef(), IMAP_FOLDER_NAME + i, ContentModel.TYPE_CONTENT);
            ContentWriter writer = this.fileFolderService.getWriter(fi.getNodeRef());
            writer.putContent(IMAP_FOLDER_NAME);
        }
        txn.commit();
        this.folder.close(false);
        this.folder = (IMAPFolder)this.store.getFolder(TEST_FOLDER);
        this.folder.open(1);
        for (i = 1; i < 51; ++i) {
            Long uid = ImapMessageTest.getMessageUid(this.folder, i);
            int count = ImapMessageTest.getMessageSize(this.folder, uid);
            BODY body = ImapMessageTest.getMessageBodyPart(this.folder, uid, 0, count - 100);
            BODY bodyRest = ImapMessageTest.getMessageBodyPart(this.folder, uid, count - 100, 100);
            MimeMessage message = new MimeMessage(Session.getDefaultInstance((Properties)new Properties()), (InputStream)new SequenceInputStream(new BufferedInputStream(body.getByteArrayInputStream()), new BufferedInputStream(bodyRest.getByteArrayInputStream())));
            MimeMultipart content = (MimeMultipart)message.getContent();
            ImapMessageTest.assertNotNull((Object)content.getBodyPart(0).getContent());
            ImapMessageTest.assertNotNull((Object)content.getBodyPart(1).getContent());
        }
    }

    public void testUnmodifiedMessage() throws Exception {
        Long uid = ImapMessageTest.getMessageUid(this.folder, 1);
        int count = ImapMessageTest.getMessageSize(this.folder, uid);
        for (int i = 0; i < 100; ++i) {
            int n = (int)(100.0 * Math.random());
            BODY body = ImapMessageTest.getMessageBodyPart(this.folder, uid, 0, count - n);
            BODY bodyRest = ImapMessageTest.getMessageBodyPart(this.folder, uid, count - n, n);
            MimeMessage message = new MimeMessage(Session.getDefaultInstance((Properties)new Properties()), (InputStream)new SequenceInputStream(new BufferedInputStream(body.getByteArrayInputStream()), new BufferedInputStream(bodyRest.getByteArrayInputStream())));
            MimeMultipart content = (MimeMultipart)message.getContent();
            ImapMessageTest.assertNotNull((Object)content.getBodyPart(0).getContent());
            ImapMessageTest.assertNotNull((Object)content.getBodyPart(1).getContent());
        }
    }

    public void testEncodedFromToAddresses() throws Exception {
        String addressString = "ars.kov@gmail.com";
        String personalString = "\ufffd?\u0440\ufffd?\u0435\u043d\u0438\u0439 \u041a\u043e\u0432\u0430\u043b\u044c\u0447\u0443\u043a";
        InternetAddress address = new InternetAddress(addressString, personalString, "UTF-8");
        String decodedAddress = MimeUtility.decodeText((String)address.toString());
        ImapMessageTest.assertFalse((String)"Non ASCII characters in the address should be encoded", (boolean)decodedAddress.equals(InternetAddress.toString((Address[])new Address[]{address})));
        MimeMessage message = new MimeMessage(Session.getDefaultInstance((Properties)new Properties()));
        MimeMessageHelper messageHelper = new MimeMessageHelper(message, false, "UTF-8");
        messageHelper.setText("This is a sample message for ALF-5647");
        messageHelper.setSubject("This is a sample message for ALF-5647");
        messageHelper.setFrom(address);
        messageHelper.addTo(address);
        messageHelper.addCc(address);
        String name = "Message_" + GUID.generate();
        FileInfo messageFile = this.fileFolderService.create(this.testImapFolderNodeRef, name, ContentModel.TYPE_CONTENT);
        new IncomingImapMessage(messageFile, this.serviceRegistry, message);
        Map properties = this.nodeService.getProperties(messageFile.getNodeRef());
        String cmOriginator = (String)properties.get(ContentModel.PROP_ORIGINATOR);
        String cmAddressee = (String)properties.get(ContentModel.PROP_ADDRESSEE);
        List cmAddressees = (List)properties.get(ContentModel.PROP_ADDRESSEES);
        String imapMessageFrom = (String)properties.get(ImapModel.PROP_MESSAGE_FROM);
        String imapMessageTo = (String)properties.get(ImapModel.PROP_MESSAGE_TO);
        String imapMessageCc = (String)properties.get(ImapModel.PROP_MESSAGE_CC);
        ImapMessageTest.assertNotNull((Object)cmOriginator);
        ImapMessageTest.assertEquals((String)decodedAddress, (String)cmOriginator);
        ImapMessageTest.assertNotNull((Object)cmAddressee);
        ImapMessageTest.assertEquals((String)decodedAddress, (String)cmAddressee);
        ImapMessageTest.assertNotNull((Object)cmAddressees);
        ImapMessageTest.assertEquals((int)1, (int)cmAddressees.size());
        ImapMessageTest.assertEquals((String)decodedAddress, (String)((String)cmAddressees.get(0)));
        ImapMessageTest.assertNotNull((Object)imapMessageFrom);
        ImapMessageTest.assertEquals((String)decodedAddress, (String)imapMessageFrom);
        ImapMessageTest.assertNotNull((Object)imapMessageTo);
        ImapMessageTest.assertEquals((String)decodedAddress, (String)imapMessageTo);
        ImapMessageTest.assertNotNull((Object)imapMessageCc);
        ImapMessageTest.assertEquals((String)decodedAddress, (String)imapMessageCc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEightBitMessage() throws Exception {
        Store lstore = this.session.getStore(PROTOCOL);
        lstore.connect(this.imapServer.getHost(), this.imapServer.getPort(), "admin", "admin");
        String folderName = "Alfresco IMAP/test";
        IMAPFolder lfolder = (IMAPFolder)lstore.getFolder(folderName);
        lfolder.open(2);
        InputStream messageFileInputStream1 = null;
        InputStream messageFileInputStream2 = null;
        try {
            ClassPathResource fileResource = new ClassPathResource("imap/test-8bit-message.eml");
            messageFileInputStream1 = new FileInputStream(fileResource.getFile());
            MimeMessage message = new MimeMessage(Session.getDefaultInstance((Properties)new Properties()), messageFileInputStream1);
            String subject = message.getSubject();
            messageFileInputStream2 = new FileInputStream(fileResource.getFile());
            byte[] original = ASCIIUtility.getBytes((InputStream)messageFileInputStream2);
            Message[] messages = new Message[]{message};
            lfolder.appendMessages(messages);
            String messageXPath = "/app:company_home/cm:test/*[like(@cm:title, $cm:title, true)]";
            QueryParameterDefinition[] params = new QueryParameterDefinition[]{new QueryParameterDefImpl(ContentModel.PROP_TITLE, this.serviceRegistry.getDictionaryService().getDataType(DataTypeDefinition.TEXT), true, subject)};
            List nodeRefs = this.searchService.selectNodes(this.storeRootNodeRef, messageXPath, params, (NamespacePrefixResolver)this.namespaceService, true);
            ImapMessageTest.assertEquals((int)1, (int)nodeRefs.size());
            NodeRef messageNodeRef = (NodeRef)nodeRefs.get(0);
            Long dbid = (Long)this.nodeService.getProperty(messageNodeRef, ContentModel.PROP_NODE_DBID);
            RFC822DATA data = ImapMessageTest.getRFC822Message(lfolder, dbid);
            ImapMessageTest.assertNotNull((String)"Can't fetch a message from the repositiry", (Object)data);
            byte[] processed = ASCIIUtility.getBytes((InputStream)data.getByteArrayInputStream());
            ImapMessageTest.assertTrue((String)"Original message doesn't coincide to the message processed by the repository", (boolean)Arrays.equals(original, processed));
        }
        finally {
            if (messageFileInputStream1 != null) {
                messageFileInputStream1.close();
            }
            if (messageFileInputStream2 != null) {
                messageFileInputStream2.close();
            }
        }
        lfolder.close(true);
        lstore.close();
    }

    private static RFC822DATA getRFC822Message(IMAPFolder folder, final long uid) throws MessagingException {
        return (RFC822DATA)folder.doCommand(new IMAPFolder.ProtocolCommand(){

            public Object doCommand(IMAPProtocol p) throws ProtocolException {
                Response[] r = p.command("UID FETCH " + uid + " (RFC822)", null);
                ImapMessageTest.logResponse(r);
                Response response = r[r.length - 1];
                if (!response.isOK()) {
                    throw new ProtocolException("Unable to retrieve message in RFC822 format");
                }
                FetchResponse fetchResponse = (FetchResponse)r[0];
                return fetchResponse.getItem(RFC822DATA.class);
            }
        });
    }

    private static BODY getMessageBodyPart(IMAPFolder folder, final Long uid, final Integer from, final Integer count) throws MessagingException {
        return (BODY)folder.doCommand(new IMAPFolder.ProtocolCommand(){

            public Object doCommand(IMAPProtocol p) throws ProtocolException {
                Response[] r = p.command("UID FETCH " + uid + " (FLAGS BODY.PEEK[]<" + from + "." + count + ">)", null);
                ImapMessageTest.logResponse(r);
                Response response = r[r.length - 1];
                if (!response.isOK()) {
                    throw new ProtocolException("Unable to retrieve message part <" + from + "." + count + ">");
                }
                FetchResponse fetchResponse = (FetchResponse)r[0];
                BODY body = (BODY)fetchResponse.getItem(BODY.class);
                return body;
            }
        });
    }

    private NodeRef findNode(String path) {
        List nodeRefs = this.searchService.selectNodes(this.storeRootNodeRef, path, null, (NamespacePrefixResolver)this.namespaceService, false);
        return nodeRefs.size() > 0 ? (NodeRef)nodeRefs.get(0) : null;
    }

    private static Long getMessageUid(IMAPFolder folder, final int msn) throws MessagingException {
        return (Long)folder.doCommand(new IMAPFolder.ProtocolCommand(){

            public Object doCommand(IMAPProtocol p) throws ProtocolException {
                String command = "FETCH " + msn + " (UID)";
                Response[] r = p.command(command, null);
                ImapMessageTest.logResponse(r);
                Response response = r[r.length - 1];
                if (!response.isOK()) {
                    throw new ProtocolException("Unable to retrieve message UID");
                }
                for (int i = 0; i < r.length; ++i) {
                    if (!(r[i] instanceof FetchResponse)) continue;
                    FetchResponse fetchResponse = (FetchResponse)r[0];
                    UID uid = (UID)fetchResponse.getItem(UID.class);
                    logger.debug((Object)("MSGNO=" + uid.msgno + ", UID=" + uid.uid));
                    return uid.uid;
                }
                StringBuffer sb = new StringBuffer();
                sb.append("command=" + command);
                sb.append('\n');
                sb.append("resp length=" + r.length);
                sb.append('\n');
                for (int i = 0; i < r.length; ++i) {
                    logger.error((Object)r[i]);
                    sb.append("class=" + r[i].getClass().getName());
                    IMAPResponse unexpected = (IMAPResponse)r[i];
                    sb.append("key=" + unexpected.getKey());
                    sb.append("number=" + unexpected.getNumber());
                    sb.append("rest=" + unexpected.getRest());
                    sb.append("r[" + i + "]=" + r[i] + '\n');
                }
                throw new ProtocolException("getMessageUid: " + sb.toString());
            }
        });
    }

    private static Integer getMessageSize(IMAPFolder folder, Long uid) throws MessagingException {
        return ImapMessageTest.getMessageBody((IMAPFolder)folder, (Long)uid).data.getCount();
    }

    private static BODY getMessageBody(IMAPFolder folder, final Long uid) throws MessagingException {
        return (BODY)folder.doCommand(new IMAPFolder.ProtocolCommand(){

            public Object doCommand(IMAPProtocol p) throws ProtocolException {
                Response[] r = p.command("UID FETCH " + uid + " (FLAGS BODY.PEEK[])", null);
                ImapMessageTest.logResponse(r);
                Response response = r[r.length - 1];
                if (!response.isOK()) {
                    throw new ProtocolException("Unable to retrieve message size");
                }
                FetchResponse fetchResponse = (FetchResponse)r[0];
                BODY body = (BODY)fetchResponse.getItem(BODY.class);
                return body;
            }
        });
    }

    private static void logResponse(Response[] r) {
        for (int i = 0; i < r.length; ++i) {
            logger.debug((Object)r[i]);
        }
    }

    public void tearDown() throws Exception {
        logger.debug((Object)"tearDown ");
        UserTransaction txn = this.transactionService.getUserTransaction();
        txn.begin();
        List nodeRefs = this.searchService.selectNodes(this.storeRootNodeRef, "/app:company_home/cm:test", null, (NamespacePrefixResolver)this.namespaceService, false);
        if (nodeRefs != null && nodeRefs.size() > 0) {
            this.fileFolderService.delete((NodeRef)nodeRefs.get(0));
        }
        this.authenticationService.deleteAuthentication(this.anotherUserName);
        this.personService.deletePerson(this.anotherUserName);
        txn.commit();
        this.folder.close(false);
        this.store.close();
        logger.debug((Object)"tearDown end");
    }
}

