/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.imap;

import com.icegreen.greenmail.store.SimpleStoredMessage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.imap.AbstractMimeMessage;
import org.alfresco.repo.imap.AlfrescoImapFolder;
import org.alfresco.repo.imap.AlfrescoImapUser;
import org.alfresco.repo.imap.ImapService;
import org.alfresco.repo.imap.ImapServiceImpl;
import org.alfresco.repo.management.subsystems.ChildApplicationContextFactory;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileFolderUtil;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.config.RepositoryFolderConfigBean;
import org.springframework.context.ApplicationContext;

public class ImapServiceImplCacheTest
extends TestCase {
    private static final String USER_NAME = "admin";
    private static final String USER_PASSWORD = "admin";
    private static final String TEST_IMAP_FOLDER_NAME = "aaa";
    private static ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
    private NodeService nodeService;
    private MutableAuthenticationService authenticationService;
    private SearchService searchService;
    private NamespaceService namespaceService;
    private FileFolderService fileFolderService;
    private ContentService contentService;
    private FileInfo oldFile;
    private ImapService imapService;
    private NodeRef testImapFolderNodeRef;

    public void setUp() throws Exception {
        ServiceRegistry serviceRegistry = (ServiceRegistry)ctx.getBean("ServiceRegistry");
        this.nodeService = serviceRegistry.getNodeService();
        this.authenticationService = serviceRegistry.getAuthenticationService();
        this.imapService = serviceRegistry.getImapService();
        this.searchService = serviceRegistry.getSearchService();
        this.namespaceService = serviceRegistry.getNamespaceService();
        this.fileFolderService = serviceRegistry.getFileFolderService();
        this.contentService = serviceRegistry.getContentService();
        this.authenticationService.authenticate("admin", "admin".toCharArray());
        String storePath = "workspace://SpacesStore";
        String companyHomePathInStore = "/app:company_home";
        StoreRef storeRef = new StoreRef(storePath);
        NodeRef storeRootNodeRef = this.nodeService.getRootNode(storeRef);
        List nodeRefs = this.searchService.selectNodes(storeRootNodeRef, companyHomePathInStore, null, (NamespacePrefixResolver)this.namespaceService, false);
        NodeRef companyHomeNodeRef = (NodeRef)nodeRefs.get(0);
        ChildApplicationContextFactory imap = (ChildApplicationContextFactory)ctx.getBean("imap");
        ApplicationContext imapCtx = imap.getApplicationContext();
        ImapServiceImpl imapServiceImpl = (ImapServiceImpl)imapCtx.getBean("imapService");
        LinkedList<String> folders = new LinkedList<String>();
        folders.add(TEST_IMAP_FOLDER_NAME);
        FileInfo folder = FileFolderUtil.makeFolders(this.fileFolderService, companyHomeNodeRef, folders, ContentModel.TYPE_FOLDER);
        this.oldFile = this.fileFolderService.create(folder.getNodeRef(), "oldFile", ContentModel.TYPE_CONTENT);
        RepositoryFolderConfigBean imapHome = new RepositoryFolderConfigBean();
        imapHome.setStore(storePath);
        imapHome.setRootPath(companyHomePathInStore);
        imapHome.setFolderPath(TEST_IMAP_FOLDER_NAME);
        imapServiceImpl.setImapHome(imapHome);
        imapServiceImpl.startupInTxn(true);
        nodeRefs = this.searchService.selectNodes(storeRootNodeRef, companyHomePathInStore + "/" + "cm" + ":" + TEST_IMAP_FOLDER_NAME, null, (NamespacePrefixResolver)this.namespaceService, false);
        this.testImapFolderNodeRef = (NodeRef)nodeRefs.get(0);
    }

    public void tearDown() throws Exception {
        this.fileFolderService.delete(this.testImapFolderNodeRef);
    }

    public void testRepoBehaviourWithFoldersCache() throws Exception {
        AlfrescoImapUser localUser = new AlfrescoImapUser("admin@alfresco.com", "admin", "admin");
        String folderName = "ALF9361";
        String mailbox = "Alfresco IMAP/aaa/" + folderName;
        int contentItemsCount = 3;
        FileInfo localRootFolder = this.fileFolderService.create(this.testImapFolderNodeRef, folderName, ContentModel.TYPE_FOLDER);
        ArrayList<FileInfo> subFolders = new ArrayList<FileInfo>(10);
        for (int i = 0; i < 3; ++i) {
            String childMailbox = folderName + "_" + i;
            FileInfo subFolder = this.fileFolderService.create(localRootFolder.getNodeRef(), childMailbox, ContentModel.TYPE_FOLDER);
            for (int j = 0; j < 3; ++j) {
                String subChildMailbox = "sub_" + j;
                this.fileFolderService.create(subFolder.getNodeRef(), subChildMailbox, ContentModel.TYPE_FOLDER);
            }
            subFolders.add(subFolder);
        }
        this.createTestContent(localRootFolder, contentItemsCount);
        this.imapService.listMailboxes(localUser, "*", false);
        this.imapService.listMailboxes(localUser, "*", true);
        AlfrescoImapFolder folder = this.imapService.getOrCreateMailbox(localUser, mailbox, true, false);
        ImapServiceImplCacheTest.assertNotNull((String)"Folder wasn't successfully gotten from IMAP", (Object)folder);
        ImapServiceImplCacheTest.assertEquals((int)contentItemsCount, (int)folder.getMessageCount());
        long uidValidityBefore = folder.getUidValidity();
        this.fileFolderService.move(this.oldFile.getNodeRef(), folder.getFolderInfo().getNodeRef(), folder.getName());
        folder = this.imapService.getOrCreateMailbox(localUser, mailbox, true, false);
        ImapServiceImplCacheTest.assertEquals((int)(++contentItemsCount), (int)folder.getMessageCount());
        long uidValidity = folder.getUidValidity();
        ImapServiceImplCacheTest.assertTrue((String)"UIDVALIDITY wasn't incremented", (uidValidity - uidValidityBefore > 0L ? 1 : 0) != 0);
        this.fileFolderService.delete(((FileInfo)subFolders.get(0)).getNodeRef());
        uidValidityBefore = uidValidity;
        try {
            String subFolderName = mailbox + '/' + folderName + "_0";
            folder = this.imapService.getOrCreateMailbox(localUser, subFolderName, true, false);
            ImapServiceImplCacheTest.fail((String)"The folder still in the cache");
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        try {
            String subSubFolderName = mailbox + '/' + mailbox + "_0" + '/' + "sub_0";
            folder = this.imapService.getOrCreateMailbox(localUser, subSubFolderName, true, false);
            ImapServiceImplCacheTest.fail((String)"The folder still in the cache");
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        folder = this.imapService.getOrCreateMailbox(localUser, mailbox, true, false);
        SimpleStoredMessage message = folder.getMessages().get(0);
        AbstractMimeMessage alfrescoMessage = (AbstractMimeMessage)message.getMimeMessage();
        long uid = message.getUid();
        this.fileFolderService.delete(alfrescoMessage.getMessageInfo().getNodeRef());
        folder = this.imapService.getOrCreateMailbox(localUser, mailbox, true, false);
        ImapServiceImplCacheTest.assertTrue((String)"Messages cache is stale", (contentItemsCount > folder.getMessageCount() ? 1 : 0) != 0);
        long[] uids = folder.getMessageUids();
        Arrays.sort(uids);
        ImapServiceImplCacheTest.assertFalse((String)"Messages msn cache is stale", (Arrays.binarySearch(uids, uid) > 0 ? 1 : 0) != 0);
        ImapServiceImplCacheTest.assertNull((String)"Message is still in the messages cache", (Object)folder.getMessage(uid));
        this.fileFolderService.delete(localRootFolder.getNodeRef());
    }

    private List<FileInfo> createTestContent(FileInfo parent, int count) {
        ArrayList<FileInfo> result = new ArrayList<FileInfo>(count);
        for (int i = 0; i < count; ++i) {
            FileInfo contentItem = this.fileFolderService.create(parent.getNodeRef(), "content_" + i, ContentModel.TYPE_CONTENT, ContentModel.ASSOC_CONTAINS);
            ContentWriter contentWriter = this.contentService.getWriter(contentItem.getNodeRef(), ContentModel.PROP_CONTENT, false);
            contentWriter.setEncoding("UTF-8");
            contentWriter.putContent("TEST" + i);
        }
        return result;
    }
}

