/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.importer;

import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.importer.AVMZipImporter;
import org.alfresco.repo.importer.ImporterBootstrap;
import org.alfresco.repo.security.authentication.AuthenticationContext;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.avm.AVMService;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.PropertyCheck;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tools.zip.ZipFile;
import org.springframework.context.ApplicationEvent;
import org.springframework.extensions.surf.util.AbstractLifecycleBean;

public class AVMZipBootstrap
extends AbstractLifecycleBean {
    private static final Log logger = LogFactory.getLog(AVMZipBootstrap.class);
    private TransactionService transactionService;
    private RetryingTransactionHelper retryingTransactionHelper;
    private NodeService nodeService;
    private AuthenticationContext authenticationContext;
    private AVMService avmService;
    private AVMZipImporter avmZipImporter;
    private boolean allowWrite = true;
    private String location;
    private String avmRoot;

    public void setAllowWrite(boolean write) {
        this.allowWrite = write;
    }

    public void setAvmRoot(String avmRoot) {
        this.avmRoot = avmRoot;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public void setAvmZipImporter(AVMZipImporter avmZipImporter) {
        this.avmZipImporter = avmZipImporter;
    }

    public void setAvmService(AVMService avmService) {
        this.avmService = avmService;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void setRetryingTransactionHelper(RetryingTransactionHelper retryingTransactionHelper) {
        this.retryingTransactionHelper = retryingTransactionHelper;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setAuthenticationContext(AuthenticationContext authenticationContext) {
        this.authenticationContext = authenticationContext;
    }

    public void bootstrap() {
        PropertyCheck.mandatory((Object)((Object)this), (String)"avmZipImporter", (Object)this.avmZipImporter);
        PropertyCheck.mandatory((Object)((Object)this), (String)"retryingTransactionHelper", (Object)this.retryingTransactionHelper);
        PropertyCheck.mandatory((Object)((Object)this), (String)"nodeService", (Object)this.nodeService);
        if (this.avmRoot == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"No AVM Root URL - bootstrap import ignored");
            }
            return;
        }
        if (this.location == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"No Location given to import from - bootstrap import ignored");
            }
            return;
        }
        try {
            AuthenticationUtil.RunAsWork<Object> importRunAs = new AuthenticationUtil.RunAsWork<Object>(){

                public Object doWork() throws Exception {
                    RetryingTransactionHelper.RetryingTransactionCallback<Object> doImportCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

                        @Override
                        public Object execute() throws Throwable {
                            AVMZipBootstrap.this.doImport();
                            return null;
                        }
                    };
                    return AVMZipBootstrap.this.retryingTransactionHelper.doInTransaction(doImportCallback, AVMZipBootstrap.this.transactionService.isReadOnly(), false);
                }
            };
            AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)importRunAs, (String)this.authenticationContext.getSystemUserName());
        }
        catch (Throwable e) {
            throw new AlfrescoRuntimeException("Bootstrap failed", e);
        }
    }

    private void doImport() throws Throwable {
        if (!this.allowWrite) {
            logger.warn((Object)("Skipping import as read-only: " + this.avmRoot));
        } else {
            String store = this.avmRoot.substring(0, this.avmRoot.indexOf(58));
            if (this.avmService.getStore(store) == null) {
                this.avmService.createStore(store);
            }
            logger.debug((Object)("Bootstrapping AVM data from " + this.location + " to " + this.avmRoot));
            ZipFile zip = new ZipFile(ImporterBootstrap.getFile(this.location));
            this.avmZipImporter.importNodes(zip, this.avmRoot);
        }
    }

    protected void onBootstrap(ApplicationEvent event) {
        this.bootstrap();
    }

    protected void onShutdown(ApplicationEvent event) {
    }
}

