/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.importer.view;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.importer.ImportNode;
import org.alfresco.repo.importer.view.ElementContext;
import org.alfresco.repo.importer.view.ParentContext;
import org.alfresco.service.cmr.dictionary.AspectDefinition;
import org.alfresco.service.cmr.dictionary.AssociationDefinition;
import org.alfresco.service.cmr.dictionary.ChildAssociationDefinition;
import org.alfresco.service.cmr.dictionary.ClassDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.AccessPermission;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.AuthorityType;
import org.alfresco.service.namespace.QName;

public class NodeContext
extends ElementContext
implements ImportNode {
    private ParentContext parentContext;
    private boolean isReference = false;
    private NodeRef nodeRef;
    private String importId;
    private String uuid;
    private TypeDefinition typeDef;
    private String childName;
    private Map<QName, AspectDefinition> nodeAspects = new HashMap<QName, AspectDefinition>();
    private Map<QName, ChildAssociationDefinition> nodeChildAssocs = new HashMap<QName, ChildAssociationDefinition>();
    private Map<QName, Serializable> nodeProperties = new HashMap<QName, Serializable>();
    private Map<QName, DataTypeDefinition> propertyDatatypes = new HashMap<QName, DataTypeDefinition>();
    private boolean inherit = true;
    private List<AccessPermission> accessControlEntries = new ArrayList<AccessPermission>();

    public NodeContext(QName elementName, ParentContext parentContext, TypeDefinition typeDef) {
        super(elementName, parentContext.getDictionaryService(), parentContext.getImporter());
        this.parentContext = parentContext;
        this.typeDef = typeDef;
        this.uuid = null;
    }

    @Override
    public ParentContext getParentContext() {
        return this.parentContext;
    }

    @Override
    public TypeDefinition getTypeDefinition() {
        return this.typeDef;
    }

    @Override
    public boolean isReference() {
        return this.isReference;
    }

    public void setReference(boolean isReference) {
        this.isReference = isReference;
    }

    public void setTypeDefinition(TypeDefinition typeDef) {
        this.typeDef = typeDef;
    }

    @Override
    public NodeRef getNodeRef() {
        return this.nodeRef;
    }

    public void setNodeRef(NodeRef nodeRef) {
        this.nodeRef = nodeRef;
    }

    @Override
    public String getUUID() {
        return this.uuid;
    }

    public void setUUID(String uuid) {
        this.uuid = uuid;
    }

    public String getImportId() {
        return this.importId;
    }

    public void setImportId(String importId) {
        this.importId = importId;
    }

    @Override
    public String getChildName() {
        return this.childName;
    }

    public void setChildName(String childName) {
        this.childName = childName;
    }

    public void setInheritPermissions(boolean inherit) {
        this.inherit = inherit;
    }

    @Override
    public boolean getInheritPermissions() {
        return this.inherit;
    }

    public void addPropertyCollection(QName property) {
        ClassDefinition classDef;
        PropertyDefinition propDef = this.getDictionaryService().getProperty(property);
        ClassDefinition classDefinition = classDef = propDef == null ? null : propDef.getContainerClass();
        if (classDef != null && !this.isImportableClass(classDef.getName())) {
            return;
        }
        ArrayList values = new ArrayList();
        this.nodeProperties.put(property, values);
    }

    public void addProperty(QName property, Serializable value) {
        ClassDefinition classDef;
        PropertyDefinition propDef = this.getDictionaryService().getProperty(property);
        if (this.uuid == null && propDef != null && propDef.getName().equals((Object)ContentModel.PROP_NODE_UUID)) {
            this.uuid = value.toString();
        }
        ClassDefinition classDefinition = classDef = propDef == null ? null : propDef.getContainerClass();
        if (classDef != null && !this.isImportableClass(classDef.getName())) {
            return;
        }
        Serializable newValue = value;
        Serializable existingValue = this.nodeProperties.get(property);
        if (existingValue != null) {
            if (existingValue instanceof Collection) {
                ((Collection)((Object)existingValue)).add(value);
                newValue = existingValue;
            } else {
                ArrayList<Object> values = new ArrayList<Object>();
                values.add((String)((Object)existingValue));
                values.add(value);
                newValue = values;
            }
        }
        this.nodeProperties.put(property, newValue);
    }

    public void addDatatype(QName property, DataTypeDefinition datatype) {
        this.propertyDatatypes.put(property, datatype);
    }

    public Map<QName, DataTypeDefinition> getPropertyDatatypes() {
        return this.propertyDatatypes;
    }

    @Override
    public Map<QName, Serializable> getProperties() {
        return this.nodeProperties;
    }

    @Override
    public DataTypeDefinition getPropertyDataType(QName propertyName) {
        PropertyDefinition propDef;
        DataTypeDefinition valueDataType = this.propertyDatatypes.get(propertyName);
        if (valueDataType == null && (propDef = this.getDictionaryService().getProperty(propertyName)) != null) {
            valueDataType = propDef.getDataType();
        }
        return valueDataType;
    }

    public void addAspect(AspectDefinition aspect) {
        if (this.isImportableClass(aspect.getName())) {
            this.nodeAspects.put(aspect.getName(), aspect);
        }
    }

    @Override
    public Set<QName> getNodeAspects() {
        return this.nodeAspects.keySet();
    }

    public void addAccessControlEntry(AccessStatus accessStatus, String authority, String permission) {
        if (permission.equalsIgnoreCase("guest")) {
            permission = "Consumer";
        }
        ACE ace = new ACE(accessStatus, authority, permission);
        this.accessControlEntries.add(ace);
    }

    @Override
    public List<AccessPermission> getAccessControlEntries() {
        return this.accessControlEntries;
    }

    public Object determineDefinition(QName defName) {
        AspectDefinition def = this.determineAspect(defName);
        if (def == null && (def = this.determineProperty(defName)) == null) {
            def = this.determineAssociation(defName);
        }
        return def;
    }

    public AspectDefinition determineAspect(QName defName) {
        AspectDefinition def = this.nodeAspects.get(defName);
        if (def == null) {
            def = this.getDictionaryService().getAspect(defName);
        }
        return def;
    }

    public PropertyDefinition determineProperty(QName defName) {
        PropertyDefinition def = null;
        if (!this.nodeProperties.containsKey(defName)) {
            PropertyDefinition propertyDefinition = def = this.typeDef == null ? null : this.getDictionaryService().getProperty(this.typeDef.getName(), defName);
            if (def == null) {
                HashSet<AspectDefinition> allAspects = new HashSet<AspectDefinition>();
                if (this.typeDef != null) {
                    allAspects.addAll(this.typeDef.getDefaultAspects());
                }
                allAspects.addAll(this.nodeAspects.values());
                for (AspectDefinition aspectDef : allAspects) {
                    def = this.getDictionaryService().getProperty(aspectDef.getName(), defName);
                    if (def == null) continue;
                    break;
                }
            }
        }
        return def;
    }

    public AssociationDefinition determineAssociation(QName defName) {
        AssociationDefinition def = null;
        if (!this.nodeChildAssocs.containsKey(defName)) {
            def = this.getDictionaryService().getAssociation(defName);
        }
        return def;
    }

    private boolean isImportableClass(QName className) {
        return !this.getImporter().isExcludedClass(className);
    }

    public String toString() {
        return "NodeContext[childName=" + this.getChildName() + ",type=" + (this.typeDef == null ? "null" : this.typeDef.getName()) + ",nodeRef=" + this.nodeRef + ",aspects=" + this.nodeAspects.values() + ",parentContext=" + this.parentContext.toString() + "]";
    }

    public static class ACE
    implements AccessPermission {
        private AccessStatus accessStatus;
        private String authority;
        private String permission;

        public ACE(AccessStatus accessStatus, String authority, String permission) {
            this.accessStatus = accessStatus;
            this.authority = authority;
            this.permission = permission;
        }

        public String getPermission() {
            return this.permission;
        }

        public AccessStatus getAccessStatus() {
            return this.accessStatus;
        }

        public String getAuthority() {
            return this.authority;
        }

        public AuthorityType getAuthorityType() {
            return null;
        }

        public int getPosition() {
            return 0;
        }

        public boolean isInherited() {
            return false;
        }

        public boolean isSetDirectly() {
            return true;
        }
    }
}

